/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.actionCodes.amqp;

import com.indy.engine.actionCodes.Messages;
import com.rabbitmq.client.Delivery;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import org.apache.commons.io.IOUtils;

public class AMQPUtils {
    public static void _assert(boolean condition, String message) {
        if (!condition) {
            throw new RuntimeException(message);
        }
    }

    public static byte[] inputStreamToByteArray(InputStream myStream) throws IOException {
        try (BufferedInputStream bis = null;){
            bis = new BufferedInputStream(myStream);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)bis, (OutputStream)baos);
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
    }

    public static byte[] fileToByteArray(File _file) throws IOException {
        File file = _file;
        if (!_file.exists()) {
            throw new IOException(String.valueOf(Messages.getString("AMQP.ERROR_031")) + file);
        }
        if (!_file.isFile()) {
            throw new IOException(String.valueOf(Messages.getString("AMQP.ERROR_032")) + file);
        }
        try (FileInputStream is = null;){
            is = new FileInputStream(file);
            byte[] byArray = AMQPUtils.inputStreamToByteArray(new FileInputStream(file));
            return byArray;
        }
    }

    public static void byteToOutputStream(byte[] body, FileOutputStream fos, boolean b) throws IOException {
        fos.write(body);
    }

    public static String getStringProperty(Delivery deliv, String name, int number) throws UnsupportedEncodingException {
        if (name.startsWith("AMQP_")) {
            AMQPProperty _prop = AMQPProperty.valueOf(name);
            switch (_prop) {
                case AMQP_ROUTING_KEY: {
                    return deliv.getEnvelope().getRoutingKey();
                }
                case AMQP_STRING_CONTENT: {
                    if (deliv.getProperties().getContentEncoding() != null) {
                        return new String(deliv.getBody(), deliv.getProperties().getContentEncoding());
                    }
                    return new String(deliv.getBody());
                }
                case AMQP_DELIVERY_TAG: {
                    return String.valueOf(deliv.getEnvelope().getDeliveryTag());
                }
                case AMQP_EXCHANGE_NAME: {
                    return deliv.getEnvelope().getExchange();
                }
                case AMQP_MESSAGE_ID: {
                    return deliv.getProperties().getMessageId();
                }
                case AMQP_CORRELATION_ID: {
                    return deliv.getProperties().getCorrelationId();
                }
                case AMQP_EXPIRATION: {
                    return deliv.getProperties().getExpiration();
                }
                case AMQP_APP_ID: {
                    return deliv.getProperties().getAppId();
                }
                case AMQP_CLASS_NAME: {
                    return deliv.getProperties().getClassName();
                }
                case AMQP_CLUSTER_ID: {
                    return deliv.getProperties().getClusterId();
                }
                case AMQP_CONTENT_ENCODING: {
                    return deliv.getProperties().getContentEncoding();
                }
                case AMQP_CONTENT_TYPE: {
                    return deliv.getProperties().getContentType();
                }
                case AMQP_REPLY_TO: {
                    return deliv.getProperties().getReplyTo();
                }
                case AMQP_TYPE: {
                    return deliv.getProperties().getType();
                }
                case AMQP_USER_ID: {
                    return deliv.getProperties().getUserId();
                }
                case AMQP_BODY_SIZE: {
                    return String.valueOf(deliv.getProperties().getBodySize());
                }
                case AMQP_TIMESTAMP: {
                    return deliv.getProperties().getTimestamp().toString();
                }
                case AMQP_DELIVERY_MODE: {
                    if (deliv.getProperties().getDeliveryMode() != null) {
                        return deliv.getProperties().getDeliveryMode().toString();
                    }
                    return null;
                }
                case AMQP_PRIORITY: {
                    if (deliv.getProperties().getPriority() != null) {
                        return deliv.getProperties().getPriority().toString();
                    }
                    return null;
                }
                case AMQP_MESSAGE_NUMBER: {
                    return String.valueOf(number);
                }
            }
        } else {
            Object o;
            Map headers = deliv.getProperties().getHeaders();
            if (headers != null && (o = headers.get(name)) != null) {
                return o.toString();
            }
        }
        return null;
    }

    public static enum AMQPProperty {
        AMQP_ROUTING_KEY("VARCHAR"),
        AMQP_STRING_CONTENT("VARCHAR"),
        AMQP_DELIVERY_TAG("BIGINT"),
        AMQP_EXCHANGE_NAME("VARCHAR"),
        AMQP_MESSAGE_ID("VARCHAR"),
        AMQP_CORRELATION_ID("VARCHAR"),
        AMQP_EXPIRATION("VARCHAR"),
        AMQP_APP_ID("VARCHAR"),
        AMQP_CLASS_NAME("VARCHAR"),
        AMQP_CLUSTER_ID("VARCHAR"),
        AMQP_CONTENT_ENCODING("VARCHAR"),
        AMQP_CONTENT_TYPE("VARCHAR"),
        AMQP_REPLY_TO("VARCHAR"),
        AMQP_TYPE("VARCHAR"),
        AMQP_USER_ID("BIGINT"),
        AMQP_BODY_SIZE("VARCHAR"),
        AMQP_TIMESTAMP("DATE"),
        AMQP_DELIVERY_MODE("INTEGER"),
        AMQP_PRIORITY("INTEGER"),
        AMQP_MESSAGE_NUMBER("BIGINT");

        private String sqlType;

        public String getSqlType() {
            return this.sqlType;
        }

        private AMQPProperty(String sqlType) {
            this.sqlType = sqlType;
        }
    }
}

