/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.actionCodes.file;

import com.indy.engine.action.common.BindExpressionReplacer;
import com.indy.engine.core.actionCodes.convert.JdbcConverter;
import com.indy.engine.core.api.impl.CellMapProperties;
import com.indy.runtime.api.ICellWriter;
import com.stambia.jdbc.driver.file.FileDriver;
import com.stambia.jdbc.driver.file.FileDriverConnection;
import com.stambia.jdbc.driver.file.FileDriverGenericStatement;
import com.stambia.jdbc.driver.file.FileDriverPreparedStatement;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.UnsupportedEncodingException;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class HierarchicalFileStreamWriter
implements XMLStreamWriter {
    Map<String, StatementWrapper> statements = new HashMap<String, StatementWrapper>();
    private FileDriverConnection connection;
    boolean firstWrite = false;
    String path = "";
    String localName = "";
    StatementWrapper st;
    List<String> pile = new ArrayList<String>();

    public HierarchicalFileStreamWriter(File file, String metadata, Map<String, String> inserts, String verifyLength) throws SQLException, UnsupportedEncodingException, FileNotFoundException {
        FileDriver fd = new FileDriver();
        Properties prop = new Properties();
        prop.setProperty("metadata", metadata);
        prop.setProperty("file", file.getAbsolutePath());
        this.connection = (FileDriverConnection)fd.connect("jdbc:semarchy:file", prop);
        for (String name : inserts.keySet()) {
            StatementWrapper si = new StatementWrapper();
            String sql = inserts.get(name);
            BindExpressionReplacer.BindedExpressionPlaceHolder expr = BindExpressionReplacer.replaceBindedExpressions((String)sql);
            if (expr.hasSessionVariablesToResolve()) {
                throw new SQLException("This action does support to resolve variables on bind expressions");
            }
            si.statement = this.connection.prepareStatement(expr.getBindedExpression());
            if (si.statement instanceof FileDriverGenericStatement) {
                try {
                    ((FileDriverGenericStatement)si.statement).setVerifyLength(verifyLength);
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    // empty catch block
                }
            }
            si.map = BindExpressionReplacer.parseBindedParameters((String)sql, (String)"\"", (String)"\"");
            this.statements.put(name, si);
        }
    }

    void addSegment(String str) {
        this.localName = str;
        this.path = String.valueOf(this.path) + "/" + this.localName;
        this.pile.add(str);
    }

    void removeSegment() {
        this.pile.remove(this.pile.size() - 1);
        if (this.pile.size() > 0) {
            this.path = this.path.substring(0, this.path.length() - this.localName.length() - 1);
            this.localName = this.pile.get(this.pile.size() - 1);
        } else {
            this.path = "";
            this.localName = "";
        }
    }

    @Override
    public void writeStartElement(String localName) throws XMLStreamException {
        if (this.st != null) {
            try {
                this.st.closeBatch();
            }
            catch (SQLException e) {
                throw new XMLStreamException(e);
            }
        }
        this.addSegment(localName);
        this.st = this.statements.get(this.path);
        if (this.st != null) {
            this.st.openBatch();
        }
    }

    @Override
    public void writeStartElement(String namespaceURI, String localName) throws XMLStreamException {
    }

    @Override
    public void writeStartElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
    }

    @Override
    public void writeEmptyElement(String namespaceURI, String localName) throws XMLStreamException {
    }

    @Override
    public void writeEmptyElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
    }

    @Override
    public void writeEmptyElement(String localName) throws XMLStreamException {
    }

    @Override
    public void writeEndElement() throws XMLStreamException {
        if (this.path != null && this.st != null) {
            try {
                this.st.closeBatch();
            }
            catch (SQLException e) {
                throw new XMLStreamException(e);
            }
        }
        this.removeSegment();
        this.st = this.statements.get(this.path);
    }

    @Override
    public void writeEndDocument() throws XMLStreamException {
    }

    @Override
    public void close() throws XMLStreamException {
        try {
            for (StatementWrapper si : this.statements.values()) {
                if (si.statement == null) continue;
                si.statement.close();
            }
            if (this.connection != null) {
                this.connection.close();
                this.connection = null;
            }
        }
        catch (SQLException e) {
            throw new XMLStreamException(e);
        }
    }

    @Override
    public void flush() throws XMLStreamException {
    }

    void writeAttribute(String localName, Object value, int sourceType) throws XMLStreamException {
        if (this.st != null) {
            try {
                List<Integer> indexes = this.st.map.get(localName);
                for (Integer index : indexes) {
                    CellMapProperties cmp = new CellMapProperties();
                    cmp.sourceType = sourceType;
                    cmp.targetIndex = index;
                    ICellWriter cw = JdbcConverter.getPreparedStatementCellWriter((CellMapProperties)cmp, null);
                    cw.write((Object)this.st.statement, value);
                }
            }
            catch (SQLException e) {
                throw new XMLStreamException(e);
            }
            catch (Exception e) {
                throw new XMLStreamException(e);
            }
        }
    }

    @Override
    public void writeAttribute(String localName, String value) throws XMLStreamException {
    }

    @Override
    public void writeAttribute(String prefix, String namespaceURI, String localName, String value) throws XMLStreamException {
    }

    @Override
    public void writeAttribute(String namespaceURI, String localName, String value) throws XMLStreamException {
    }

    @Override
    public void writeNamespace(String prefix, String namespaceURI) throws XMLStreamException {
    }

    @Override
    public void writeDefaultNamespace(String namespaceURI) throws XMLStreamException {
    }

    @Override
    public void writeComment(String data) throws XMLStreamException {
    }

    @Override
    public void writeProcessingInstruction(String target) throws XMLStreamException {
    }

    @Override
    public void writeProcessingInstruction(String target, String data) throws XMLStreamException {
    }

    @Override
    public void writeCData(String data) throws XMLStreamException {
    }

    @Override
    public void writeDTD(String dtd) throws XMLStreamException {
    }

    @Override
    public void writeEntityRef(String name) throws XMLStreamException {
    }

    @Override
    public void writeStartDocument() throws XMLStreamException {
    }

    @Override
    public void writeStartDocument(String version) throws XMLStreamException {
    }

    @Override
    public void writeStartDocument(String encoding, String version) throws XMLStreamException {
    }

    @Override
    public void writeCharacters(String text) throws XMLStreamException {
    }

    @Override
    public void writeCharacters(char[] text, int start, int len) throws XMLStreamException {
    }

    @Override
    public String getPrefix(String uri) throws XMLStreamException {
        return null;
    }

    @Override
    public void setPrefix(String prefix, String uri) throws XMLStreamException {
    }

    @Override
    public void setDefaultNamespace(String uri) throws XMLStreamException {
    }

    @Override
    public void setNamespaceContext(NamespaceContext context) throws XMLStreamException {
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return null;
    }

    @Override
    public Object getProperty(String name) throws IllegalArgumentException {
        return null;
    }

    class StatementWrapper {
        PreparedStatement statement;
        Map<String, List<Integer>> map;
        boolean batchOpen = false;

        StatementWrapper() {
        }

        void openBatch() {
            this.batchOpen = true;
        }

        void closeBatch() throws SQLException {
            if (this.batchOpen) {
                this.statement.addBatch();
                this.statement.executeBatch();
                this.batchOpen = false;
                if (!HierarchicalFileStreamWriter.this.firstWrite) {
                    HierarchicalFileStreamWriter.this.firstWrite = true;
                    for (StatementWrapper sw : HierarchicalFileStreamWriter.this.statements.values()) {
                        ((FileDriverPreparedStatement)sw.statement).setHasWriteRow(true);
                    }
                }
            }
        }
    }
}

