/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.actionCodes.jdbc;

import com.indy.engine.action.common.ActionCodeTypeI;
import com.indy.engine.actionCodes.jdbc.Messages;
import com.indy.engine.core.common.VariableType;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public abstract class SimpleJdbcActionCodeTypeI
extends ActionCodeTypeI {
    protected String sqlActionType;
    public int sqlBatchSize;
    int sqlTransCommitNb;
    Statement DMLStatement = null;
    boolean inVerifyConsommation = false;
    int nbBindExecuted = 0;
    boolean isEmptyCode = false;
    int statSize = 1000;

    public abstract void handleBatch();

    public SimpleJdbcActionCodeTypeI(String actionCodeName) {
        super(actionCodeName, true);
        this.actionCodeName = actionCodeName;
        this.actionClassName = ((Object)((Object)this)).getClass().getName();
        this.connectionName = "";
        this.sqlActionType = "";
        this.sqlTransName = null;
        this.sqlTransType = null;
        this.sqlTransCommitNb = -1;
    }

    public void stopAction(Thread th) {
        this.write(this.sessionName, "JdbcActionCode=>stopAction(th)", String.valueOf(this.actionName) + Messages.getString("SimpleJdbcActionCodeTypeI.0"), 1, this.actionLevel, "DEBUG");
        this.setStoppingAction(true);
        try {
            this.write(this.sessionName, "JdbcActionCode=>stopAction(th)", String.valueOf(this.actionName) + Messages.getString("SimpleJdbcActionCodeTypeI.1"), 1, this.actionLevel, "DEBUG");
            th.interrupt();
        }
        catch (Exception e) {
            this.write(this.sessionName, "SimpleJdbcActionCode=>stopAction(th)", String.valueOf(this.actionName) + Messages.getString("SimpleJdbcActionCodeTypeI.2"), 1, this.actionLevel, "ERROR");
            th.interrupt();
        }
    }

    private int prepareSetConnection() throws EngineExceptionI {
        int ret = 0;
        this.setTransactionAndCommit(this.getLocalStringParameter("SQL_TRANSACTION_TYPE", null), false);
        try {
            this.sqlTransactionIsolation = -1;
            String pTransIsolation = this.getLocalStringParameter("SQL_TRANSACTION_ISOLATION");
            if (pTransIsolation != null) {
                if (pTransIsolation.equals("TRANSACTION_NONE")) {
                    this.sqlTransactionIsolation = 0;
                } else if (pTransIsolation.equals("TRANSACTION_READ_COMMITTED")) {
                    this.sqlTransactionIsolation = 2;
                } else if (pTransIsolation.equals("TRANSACTION_READ_UNCOMMITTED")) {
                    this.sqlTransactionIsolation = 1;
                } else if (pTransIsolation.equals("TRANSACTION_REPEATABLE_READ")) {
                    this.sqlTransactionIsolation = 4;
                } else if (pTransIsolation.equals("TRANSACTION_SERIALIZABLE")) {
                    this.sqlTransactionIsolation = 8;
                }
            }
        }
        catch (NullPointerException pTransIsolation) {
        }
        catch (EngineExceptionI pTransIsolation) {
            // empty catch block
        }
        try {
            this.sqlTransName = this.getLocalStringParameter("SQL_TRANSACTION_NAME");
        }
        catch (NullPointerException e) {
            this.sqlTransName = "T1";
        }
        catch (EngineExceptionI e) {
            this.sqlTransName = "T1";
        }
        if (this.sqlTransType.equals("AUTONOMOUS")) {
            this.sqlTransName = this.actionName;
        }
        try {
            this.sqlTransCommitNb = this.getLocalIntegerParameter("SQL_TRANSACTION_COMMIT_NB");
        }
        catch (NullPointerException e) {
            this.sqlTransCommitNb = -1;
        }
        catch (EngineExceptionI e) {
            this.sqlTransCommitNb = -1;
        }
        return ret;
    }

    public int prepareConnection() throws EngineExceptionI {
        int ret = 0;
        if (!this.sqlActionType.equals("DDL_DML")) {
            this.write(this.sessionName, "JdbcActionCode=>prepareExecuteCode", String.valueOf(this.actionName) + Messages.getString("SimpleJdbcActionCodeTypeI.3") + this.sqlActionType, 2, this.actionLevel, "DEBUG");
            try {
                this.connectionName = this.getStringParameter(String.valueOf(this.runtimeContext.VAR_PREFIXE) + this.actionName + this.runtimeContext.VARIABLE_PATH_SUFFIXE + "SQL_CONNECTION");
            }
            catch (EngineExceptionI e) {
                this.write(this.sessionName, "JdbcActionCode=>prepareExecuteCode", String.valueOf(this.actionName) + Messages.getString("SimpleJdbcActionCodeTypeI.4") + e.getMessage(), 1, this.actionLevel, "ERROR");
                this.addVariableWithULog(String.valueOf(this.runtimeContext.VAR_PREFIXE) + this.actionName + this.runtimeContext.VARIABLE_PATH_SUFFIXE + VariableType.CORE_RET_MESS.getName(), String.valueOf(Messages.getString("SimpleJdbcActionCodeTypeI.5")) + e.getMessage(), "String", false);
                throw new EngineExceptionI(Messages.getString("SimpleJdbcActionCodeTypeI.6"), (Throwable)e);
            }
            try {
                ret = this.prepareSetConnection();
                if (ret == 0) {
                    this.jdbcConnection = this.setConnection(this.connectionName, this.sqlTransName, this.sqlTransType);
                    ret = 0;
                }
            }
            catch (EngineExceptionI e) {
                this.write(this.sessionName, "JdbcActionCode=>prepareExecuteCode", String.valueOf(this.actionName) + Messages.getString("SimpleJdbcActionCodeTypeI.7") + e.getMessage(), 1, this.actionLevel, "ERROR");
                this.addVariableWithULog(String.valueOf(this.runtimeContext.VAR_PREFIXE) + this.actionName + this.runtimeContext.VARIABLE_PATH_SUFFIXE + VariableType.CORE_RET_MESS.getName(), String.valueOf(Messages.getString("SimpleJdbcActionCodeTypeI.8")) + e.getMessage(), "String", false);
                ret = -1;
                throw new EngineExceptionI(Messages.getString("SimpleJdbcActionCodeTypeI.9"), (Throwable)e);
            }
            this.write(this.sessionName, "JdbcActionCode=>prepareExecuteCode", String.valueOf(this.actionName) + Messages.getString("SimpleJdbcActionCodeTypeI.10") + this.sqlActionType, 2, this.actionLevel, "DEBUG");
        }
        return ret;
    }

    public int finalizeStatement(int numRecord, WrappedPreparedStatement preparedStatement) throws EngineExceptionI {
        int ret = 0;
        this.debugLog("finalizeDirectBindedFetch", "Entering", 1, this.runtimeContext.LOG_INFO);
        if (preparedStatement != null) {
            try {
                if (!this.sqlActionType.equals("DDL_DML")) {
                    if (preparedStatement.currentBatchSize > 0) {
                        ret = preparedStatement.executeBatch();
                    }
                    if ((this.sqlActionType.equals("INSERT") || this.sqlActionType.equals("UPDATE") || this.sqlActionType.equals("DELETE")) && this.sqlTransType.equals("COMMIT")) {
                        this.jdbcConnection.commit();
                    }
                    preparedStatement.close();
                }
            }
            catch (SQLException e) {
                this.addVariableWithULog(String.valueOf(this.runtimeContext.VAR_PREFIXE) + this.actionName + this.runtimeContext.VARIABLE_PATH_SUFFIXE + VariableType.CORE_RET_MESS.getName(), String.valueOf(this.actionClassName) + "=>finalizeDirectBindedFetch, " + e.getMessage(), "String", false);
                throw new EngineExceptionI((Throwable)e);
            }
        }
        this.debugLog("finalizeDirectBindedFetch", "OK", 1, this.runtimeContext.LOG_INFO);
        return ret;
    }

    public int executeStatement(int numRecord, WrappedPreparedStatement preparedStatement, UpdateStatement updateStatement) throws Exception {
        if (Thread.interrupted()) {
            this.debugLog("executeTrgDirectBindedInsert", "InterruptedException", 1, this.runtimeContext.LOG_ERROR);
            throw new InterruptedException();
        }
        preparedStatement.addBatch();
        if (this.sqlTransType.equals("COMMIT") && this.sqlTransCommitNb != -1 && preparedStatement.totalRealRow % this.sqlTransCommitNb == 0) {
            this.jdbcConnection.commit();
        }
        int nb = preparedStatement.executeBatch(this.sqlBatchSize);
        if (this.statSize > 0 && nb > 0 && preparedStatement.totalRealRow % this.statSize == 0) {
            this.handleBatch();
        }
        return nb;
    }

    public int prepareBatchSize(ResultSet rs) throws EngineExceptionI {
        int ret = 0;
        if (this.sqlActionType.equals("INSERT") || this.sqlActionType.equals("UPDATE") || this.sqlActionType.equals("DELETE")) {
            try {
                this.sqlBatchSize = this.getIntegerParameter(String.valueOf(this.runtimeContext.VAR_PREFIXE) + this.actionName + this.runtimeContext.VARIABLE_PATH_SUFFIXE + "SQL_BATCH_SIZE");
            }
            catch (EngineExceptionI e) {
                this.sqlBatchSize = this.sqlServerBatchSize != -1 ? this.sqlServerBatchSize : this.runtimeContext.DEFAULT_BATCH_SIZE;
            }
            this.statSize = this.getLocalIntegerBindedParameter(rs, "STAT_REFRESH_FREQUENCY", -1);
            if (this.statSize < 0) {
                this.statSize = this.sqlBatchSize < 1000 ? 1000 : this.sqlBatchSize;
            }
            this.debugLog("prepareDirectBindedFetch", String.valueOf(Messages.getString("SimpleJdbcActionCodeTypeI.11")) + this.sqlBatchSize, 3, this.runtimeContext.LOG_INFO);
        }
        this.debugLog("prepareDirectBindedFetch", "OK", 3, this.runtimeContext.LOG_INFO);
        return ret;
    }

    public int finalizeExecuteCode() throws EngineExceptionI {
        int ret = 0;
        if (this.sqlTransType.equals("AUTONOMOUS") || this.sqlTransType.equals("AUTOCOMMIT")) {
            this.closeConnection(this.connectionName, this.sqlTransName, this.sqlTransType, true);
        }
        return ret;
    }

    public static interface UpdateStatement {
        public int update() throws Exception;
    }

    public static class WrappedPreparedStatement {
        PreparedStatement preparedStatement;
        int currentBatchSize;
        public int totalRealRow;

        public WrappedPreparedStatement(PreparedStatement prepareStatement) {
            this.preparedStatement = prepareStatement;
        }

        int executeBatch(int batchSize) throws SQLException {
            if (this.currentBatchSize % batchSize == 0) {
                int _currentBatchSize = this.currentBatchSize;
                this.executeBatch();
                return _currentBatchSize;
            }
            return 0;
        }

        public int executeBatch() throws SQLException {
            if (this.currentBatchSize > 0) {
                int[] ret = this.preparedStatement.executeBatch();
                if (ret == null) {
                    ret = new int[]{1};
                }
                int _ret = 0;
                int[] nArray = ret;
                int n = ret.length;
                int n2 = 0;
                while (n2 < n) {
                    int c = nArray[n2];
                    _ret += c == -2 ? 1 : c;
                    ++n2;
                }
                this.totalRealRow += _ret;
                this.currentBatchSize = 0;
                return _ret;
            }
            return 0;
        }

        void close() throws SQLException {
            if (this.preparedStatement != null) {
                this.preparedStatement.close();
                this.preparedStatement = null;
            }
        }

        public void addBatch() throws SQLException {
            this.preparedStatement.addBatch();
            ++this.currentBatchSize;
        }

        public PreparedStatement getPreparedStatement() {
            return this.preparedStatement;
        }

        public ParameterMetaData getParameterMetaData() throws SQLException {
            return this.preparedStatement.getParameterMetaData();
        }
    }
}

