/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.actionCodes.jms;

import com.indy.engine.action.common.ActionCodeTypeI;
import com.indy.engine.actionCodes.jms.JMSConnectionProperties;
import com.indy.engine.actionCodes.jms.JMSFileSender;
import com.indy.engine.actionCodes.jms.Messages;
import com.indy.engine.secret.ISecretContext;
import com.indy.engine.secret.ISecretStatement;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import java.util.HashMap;
import java.util.Map;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.Topic;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class JMSConnection {
    private InitialContext initialContext;
    private Connection connection;
    private JMSConnectionProperties jcp;
    Map<String, SessionInfo> sessions = new HashMap<String, SessionInfo>();

    public JMSConnection(JMSConnectionProperties jcp) {
        this.jcp = jcp;
    }

    public synchronized void connect(ActionCodeTypeI action) throws JMSException, NamingException, EngineExceptionI {
        action.secret((ISecretStatement)new ISecretStatement<Object>(){

            public Object execute(ISecretContext context) throws Throwable {
                JMSConnection.this.initialContext = new InitialContext(JMSConnection.this.jcp.getProperties());
                ConnectionFactory connectionFactory = (ConnectionFactory)JMSConnection.this.initialContext.lookup(JMSConnection.this.jcp.getConnectionFactoryName());
                if (JMSConnection.this.jcp.getJmsLogin() == null) {
                    JMSConnection.this.connection = connectionFactory.createConnection();
                } else {
                    JMSConnection.this.connection = connectionFactory.createConnection(JMSConnection.this.jcp.getJmsLogin().getString(context), JMSConnection.this.jcp.getJmsPassword().decryptString(context));
                }
                if (JMSConnection.this.jcp.getJmsClientId() != null) {
                    JMSConnection.this.connection.setClientID(JMSConnection.this.jcp.getJmsClientId());
                }
                JMSConnection.this.connection.start();
                return null;
            }
        });
    }

    public Destination getDestination(String destinationName) throws NamingException {
        return (Destination)this.initialContext.lookup(destinationName);
    }

    public synchronized void createSession(String name, int sessionAcknowledgePolicy) throws JMSException {
        this.createSession(name, sessionAcknowledgePolicy, true);
    }

    public synchronized void createSession(String name, int sessionAcknowledgePolicy, boolean throwErrorIfAlreadyExists) throws JMSException {
        SessionInfo sessionInfo = this.sessions.get(name);
        if (sessionInfo != null && throwErrorIfAlreadyExists) {
            throw new JMSException(String.valueOf(Messages.getString("JMSConnection.0")) + name + Messages.getString("JMSConnection.1"));
        }
        if (sessionInfo != null) {
            if (sessionInfo.session.getAcknowledgeMode() != sessionAcknowledgePolicy) {
                throw new JMSException(String.valueOf(Messages.getString("JMSConnection.2")) + name + Messages.getString("JMSConnection.3"));
            }
            return;
        }
        Session session = null;
        if (sessionAcknowledgePolicy == 0) {
            session = this.connection.createSession(true, 0);
            if (session.getAcknowledgeMode() != 0) {
                throw new JMSException(Messages.getString("JMSConnection.4"));
            }
        } else {
            session = this.connection.createSession(false, sessionAcknowledgePolicy);
        }
        SessionInfo si = new SessionInfo();
        si.session = session;
        this.sessions.put(name, si);
    }

    SessionInfo getSessionInfo(String sessionName) throws JMSException {
        return this.getSessionInfo(sessionName, true);
    }

    SessionInfo getSessionInfo(String sessionName, boolean throwErroIfNotExists) throws JMSException {
        SessionInfo sessionInfo = this.sessions.get(sessionName);
        if (sessionInfo == null && throwErroIfNotExists) {
            throw new JMSException(String.valueOf(Messages.getString("JMSConnection.5")) + sessionName + Messages.getString("JMSConnection.6"), "JMS_SESSION_NOT_EXISTS");
        }
        return sessionInfo;
    }

    Session getSession(String sessionName) throws JMSException {
        SessionInfo sessionInfo = this.getSessionInfo(sessionName);
        return sessionInfo.session;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized MessageConsumer createMessageConsumer(String sessionName, String destinationName, String subscriber, String messageSelector, boolean noLocal) throws JMSException, NamingException {
        SessionInfo sessionInfo = this.getSessionInfo(sessionName);
        MessageConsumer consumer = sessionInfo.consumers.get(destinationName);
        if (consumer != null) throw new JMSException(String.valueOf(Messages.getString("JMSConnection.8")) + destinationName);
        Destination destination = this.getDestination(destinationName);
        if (subscriber != null && !subscriber.isEmpty()) {
            if (!(destination instanceof Topic)) throw new JMSException(Messages.getString("JMSConnection.7"));
            consumer = sessionInfo.session.createDurableSubscriber((Topic)destination, subscriber, messageSelector, noLocal);
        } else {
            consumer = sessionInfo.session.createConsumer(destination, messageSelector, noLocal);
        }
        sessionInfo.consumers.put(String.valueOf(destinationName) + "::SUBSCRIBER::" + subscriber, consumer);
        return consumer;
    }

    public synchronized void closeMessageConsumer(String sessionName, String destinationName, String subscriber) throws JMSException, NamingException {
        MessageConsumer consumer;
        SessionInfo sessionInfo = this.getSessionInfo(sessionName, false);
        if (sessionInfo != null && (consumer = sessionInfo.consumers.get(String.valueOf(destinationName) + "::SUBSCRIBER::" + subscriber)) != null) {
            consumer.close();
            sessionInfo.consumers.remove(String.valueOf(destinationName) + "::SUBSCRIBER::" + subscriber);
        }
    }

    public synchronized void closeMessageProducer(String sessionName, String destinationName) throws JMSException, NamingException {
        MessageProducer producer;
        SessionInfo sessionInfo = this.getSessionInfo(sessionName, false);
        if (sessionInfo != null && (producer = sessionInfo.producers.get(destinationName)) != null) {
            producer.close();
            sessionInfo.producers.remove(destinationName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commitSession(String sessionName) throws JMSException {
        SessionInfo si = this.getSessionInfo(sessionName);
        if (si.session.getAcknowledgeMode() == 0) {
            String string = si.lock;
            synchronized (string) {
                si.session.commit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollbackSession(String sessionName) throws JMSException {
        SessionInfo si = this.getSessionInfo(sessionName);
        if (si.session.getAcknowledgeMode() != 0) {
            throw new JMSException(Messages.getString("JMSConnection.9"));
        }
        String string = si.lock;
        synchronized (string) {
            si.session.rollback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeSession(String sessionName) throws JMSException {
        SessionInfo si = this.getSessionInfo(sessionName);
        String string = si.lock;
        synchronized (string) {
            si.session.close();
            this.sessions.remove(sessionName);
        }
    }

    public synchronized MessageProducer createMessageProducer(String sessionName, String destinationName) throws JMSException, NamingException {
        SessionInfo sessionInfo = this.getSessionInfo(sessionName);
        MessageProducer producer = sessionInfo.producers.get(destinationName);
        if (producer != null) {
            throw new JMSException(String.valueOf(Messages.getString("JMSConnection.10")) + destinationName);
        }
        Destination destination = this.getDestination(destinationName);
        Session session = this.getSession(sessionName);
        producer = session.createProducer(destination);
        sessionInfo.producers.put(destinationName, producer);
        return producer;
    }

    public MessageConsumer createMessage(String sessionName, String destinationName) throws JMSException, NamingException {
        Session session = this.getSession(sessionName);
        Destination destination = this.getDestination(destinationName);
        return session.createConsumer(destination);
    }

    public synchronized void closeConnection() throws JMSException, NamingException {
        for (String sessionName : this.sessions.keySet()) {
            SessionInfo si = this.sessions.get(sessionName);
            si.close();
        }
        this.sessions.clear();
        if (this.connection != null) {
            this.connection.stop();
            this.connection.close();
        }
        if (this.initialContext != null) {
            this.initialContext.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acknowledgeSession(String sessionName) throws JMSException {
        SessionInfo si = this.getSessionInfo(sessionName);
        if (si.session.getAcknowledgeMode() != 2) {
            throw new JMSException(Messages.getString("JMSConnection.11"));
        }
        String string = si.lock;
        synchronized (string) {
            Message message = si.getLastReceiveMessage();
            if (message != null) {
                message.acknowledge();
                si.setLastReceiveMessage(null);
            }
        }
    }

    public static void main(String[] args) throws Exception {
        JMSConnectionProperties jcp = new JMSConnectionProperties();
        jcp.setJndiProviderUrl("tcp://qauactivemq-01.stambia.fr69:61616");
        jcp.setConnectionFactoryName("ConnectionFactory");
        jcp.setInitialContextFactory("org.apache.activemq.jndi.ActiveMQInitialContextFactory");
        jcp.setProperty("wireFormat.maxInactivityDuration", "0");
        jcp.setProperty("queue.queue1", "queue2");
        JMSConnection conn = new JMSConnection(jcp);
        System.out.println("connected");
        conn.createSession("S1", 0);
        conn.createSession("R1", 0);
        JMSFileSender jfs = new JMSFileSender();
        jfs.setSendDirectory("d:/temp/jms/send");
        jfs.setFileMask("*.txt");
        jfs.setMessageType(JMSFileSender.JMSMessageType.TextMessage);
        jfs.setDestinationName("topic1");
        jfs.setSessionName("S1");
        jfs.send(conn);
        System.out.println("send");
        conn.commitSession("S1");
        System.out.println("commit S1");
        conn.closeConnection();
        System.out.println("closed");
    }

    public void commit() throws JMSException {
        for (String sessionName : this.sessions.keySet()) {
            this.commitSession(sessionName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recoverSession(String jmsSessionName) throws JMSException {
        SessionInfo si = this.getSessionInfo(jmsSessionName);
        String string = si.lock;
        synchronized (string) {
            si.session.recover();
        }
    }

    class SessionInfo {
        Map<String, MessageProducer> producers = new HashMap<String, MessageProducer>();
        Map<String, MessageConsumer> consumers = new HashMap<String, MessageConsumer>();
        Session session;
        private Message lastReceiveMessage;
        String lock = "";

        SessionInfo() {
        }

        public void close() throws JMSException {
            this.session.close();
            for (String destinationName : this.producers.keySet()) {
                this.producers.get(destinationName).close();
            }
            for (String destinationName : this.consumers.keySet()) {
                this.consumers.get(destinationName).close();
            }
            this.producers.clear();
            this.consumers.clear();
            this.setLastReceiveMessage(null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Message getLastReceiveMessage() {
            String string = this.lock;
            synchronized (string) {
                return this.lastReceiveMessage;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setLastReceiveMessage(Message lastReceiveMessage) {
            String string = this.lock;
            synchronized (string) {
                this.lastReceiveMessage = lastReceiveMessage;
            }
        }
    }
}

