/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.actionCodes.jms;

import com.indy.engine.actionCodes.jms.JMSConnection;
import com.indy.engine.actionCodes.jms.JMSMessageListener;
import com.indy.engine.actionCodes.jms.JMSMessageReceiver;
import com.indy.engine.actionCodes.jms.JMSUtils;
import com.indy.engine.actionCodes.jms.Messages;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.naming.NamingException;

public class JMSFileReceiver
extends JMSMessageReceiver
implements JMSMessageListener {
    String receiveDirectory;
    String fileMask = "[JMSMessageId].data";

    public void setReceiveDirectory(String receiveDirectory) {
        this.receiveDirectory = receiveDirectory;
    }

    public void setFileMask(String fileMask) {
        this.fileMask = fileMask;
    }

    @Override
    public void clear() {
        super.clear();
    }

    @Override
    public void receive(JMSConnection connection) throws JMSException, NamingException, InterruptedException {
        if (this.receiveDirectory != null) {
            File directory = new File(this.receiveDirectory);
            if (!directory.exists()) {
                throw new JMSException(String.valueOf(Messages.getString("JMSFileReceiver.0")) + this.receiveDirectory + Messages.getString("JMSFileReceiver.1"));
            }
            if (directory.isFile()) {
                throw new JMSException(String.valueOf(Messages.getString("JMSFileReceiver.2")) + this.receiveDirectory + Messages.getString("JMSFileReceiver.3"));
            }
        }
        super.receive(connection);
    }

    private static String replaceWord(Message message, String word, int count) throws JMSException {
        String _word = word.substring(1, word.length() - 1);
        if (message != null) {
            if (_word.toUpperCase().equals("JMSNORMALIZEDMESSAGEID")) {
                return JMSUtils.getJMSNormalizedMessageId(message);
            }
            if (_word.toUpperCase().equals("JMSTYPE")) {
                String str = message.getJMSType();
                return str;
            }
            if (_word.toUpperCase().equals("JMSMESSAGEID")) {
                String str = message.getJMSMessageID();
                return str;
            }
            if (_word.toUpperCase().equals("JMSTIMESTAMP")) {
                String str = String.valueOf(message.getJMSTimestamp());
                return str;
            }
            if (_word.toUpperCase().equals("JMSDELIVERYMODE")) {
                String str = String.valueOf(message.getJMSDeliveryMode());
                return str;
            }
            if (_word.toUpperCase().equals("JMSDESTINATION")) {
                Destination dest = message.getJMSDestination();
                if (dest != null) {
                    return dest.toString();
                }
            } else {
                if (_word.toUpperCase().equals("JMSMESSAGECOUNT")) {
                    return String.valueOf(count);
                }
                String str = message.getStringProperty(_word);
                return str;
            }
        }
        return null;
    }

    private static String getFileName(Message message, String fileMask, int count) throws JMSException {
        Pattern pattern = Pattern.compile("(\\[[A-Za-z0-9]+\\])");
        Matcher matcher = pattern.matcher(fileMask);
        int last = 0;
        String ret = "";
        while (matcher.find()) {
            String word = matcher.group(1);
            if (word == null) continue;
            if (matcher.start(1) > last) {
                ret = String.valueOf(ret) + fileMask.substring(last, matcher.start(1));
            }
            ret = String.valueOf(ret) + JMSFileReceiver.replaceWord(message, word, count);
            last = matcher.end(1);
        }
        if (last < fileMask.length()) {
            ret = String.valueOf(ret) + fileMask.substring(last);
        }
        return ret;
    }

    @Override
    public void onMessage(Message message, int count) throws JMSException {
        File directory = new File(this.receiveDirectory);
        String fileName = JMSFileReceiver.getFileName(message, this.fileMask, count);
        File file = new File(directory, fileName);
        FileOutputStream fos = null;
        try {
            try {
                fos = new FileOutputStream(file);
                long l = JMSUtils.messageToOutputStream(message, fos, false);
            }
            catch (FileNotFoundException e) {
                throw new JMSException(e.getMessage());
            }
            catch (IOException e) {
                throw new JMSException(e.getMessage());
            }
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

