/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.actionCodes.jms;

import com.indy.engine.actionCodes.jms.Messages;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import org.apache.commons.io.IOUtils;

public class JMSUtils {
    public static void stringToMessage(Session session, String txt, Message message) throws JMSException, IOException {
        block11: {
            try (BufferedInputStream bis = null;){
                if (message instanceof BytesMessage) {
                    BytesMessage byteMessage = (BytesMessage)message;
                    byteMessage.writeUTF(txt);
                    break block11;
                }
                if (message instanceof TextMessage) {
                    TextMessage textMessage = (TextMessage)message;
                    textMessage.setText(txt);
                    break block11;
                }
                if (message instanceof StreamMessage) {
                    StreamMessage streamMessage = (StreamMessage)message;
                    try (ByteArrayInputStream bais = null;){
                        bais = new ByteArrayInputStream(txt.getBytes());
                        JMSUtils.inputStreamToMessage(bais, (Message)streamMessage);
                        break block11;
                    }
                }
                throw new JMSException(String.valueOf(Messages.getString("JMSUtils.0")) + message.getClass().getName() + Messages.getString("JMSUtils.1"));
            }
        }
    }

    public static void copyBytesMessageToOutputStream(BytesMessage input, OutputStream output) throws IOException, JMSException {
        int bytesRead;
        byte[] buffer = new byte[1024];
        while ((bytesRead = input.readBytes(buffer)) != -1) {
            output.write(buffer, 0, bytesRead);
        }
    }

    public static long copyStreamMessageToOutputStream(StreamMessage input, OutputStream output) throws IOException, JMSException {
        int bytesRead;
        byte[] buffer = new byte[1024];
        long nb = 0L;
        while ((bytesRead = input.readBytes(buffer)) != -1) {
            nb += (long)bytesRead;
            output.write(buffer, 0, bytesRead);
        }
        return nb;
    }

    public static long messageToOutputStream(Message message, OutputStream out, boolean reset) throws JMSException, IOException {
        if (message instanceof BytesMessage) {
            BytesMessage byteMessage = (BytesMessage)message;
            if (reset) {
                byteMessage.reset();
            }
            JMSUtils.copyBytesMessageToOutputStream(byteMessage, out);
            return byteMessage.getBodyLength();
        }
        if (message instanceof TextMessage) {
            TextMessage textMessage = (TextMessage)message;
            byte[] b = textMessage.getText().getBytes();
            out.write(b);
            return b.length;
        }
        if (message instanceof StreamMessage) {
            StreamMessage streamMessage = (StreamMessage)message;
            if (reset) {
                streamMessage.reset();
            }
            return JMSUtils.copyStreamMessageToOutputStream(streamMessage, out);
        }
        throw new JMSException(String.valueOf(Messages.getString("JMSUtils.2")) + message.getClass().getName() + Messages.getString("JMSUtils.3"));
    }

    public static void inputStreamToMessage(InputStream myStream, Message message) throws JMSException, IOException {
        block9: {
            try (BufferedInputStream bis = null;){
                bis = new BufferedInputStream(myStream);
                if (message instanceof BytesMessage) {
                    BytesMessage byteMessage = (BytesMessage)message;
                    int tmpChar = bis.read();
                    while (tmpChar > -1) {
                        byteMessage.writeByte((byte)tmpChar);
                        tmpChar = bis.read();
                    }
                    break block9;
                }
                if (message instanceof TextMessage) {
                    TextMessage textMessage = (TextMessage)message;
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    IOUtils.copy((InputStream)bis, (OutputStream)baos);
                    String str = new String(baos.toByteArray());
                    textMessage.setText(str);
                    break block9;
                }
                if (message instanceof StreamMessage) {
                    StreamMessage streamMessage = (StreamMessage)message;
                    int tmpChar = bis.read();
                    while (tmpChar > -1) {
                        streamMessage.writeByte((byte)tmpChar);
                        tmpChar = bis.read();
                    }
                    break block9;
                }
                throw new JMSException(String.valueOf(Messages.getString("JMSUtils.4")) + message.getClass().getName() + Messages.getString("JMSUtils.5"));
            }
        }
    }

    public static long fileToMessage(String file, Message message) throws JMSException, IOException {
        File _file = new File(file);
        if (!_file.exists()) {
            throw new IOException(String.valueOf(Messages.getString("JMSUtils.6")) + file);
        }
        if (!_file.isFile()) {
            throw new IOException(String.valueOf(Messages.getString("JMSUtils.7")) + file);
        }
        try (FileInputStream is = null;){
            is = new FileInputStream(file);
            JMSUtils.inputStreamToMessage(new FileInputStream(file), message);
            long l = _file.length();
            return l;
        }
    }

    public static String getJMSNormalizedMessageId(Message message) throws JMSException {
        String msgId = message.getJMSMessageID();
        if (msgId != null) {
            return msgId.replace(":", "_").replace("?", "_").replace("/", "_").replace("\\", "_").replace("*", "_").replace("<", "_").replace(">", "_").replace("|", "_").replace("\"", "_");
        }
        return null;
    }
}

