/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.actionCodes.proxy;

import com.indy.engine.actionCodes.proxy.Messages;
import com.jcraft.jsch.Proxy;
import com.jcraft.jsch.ProxyHTTP;
import com.jcraft.jsch.ProxySOCKS4;
import com.jcraft.jsch.ProxySOCKS5;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.net.SocketFactory;
import org.apache.logging.log4j.Logger;

public class JCraftProxyFactory
extends SocketFactory {
    public static final int SOCKS5 = 0;
    public static final int SOCKS4 = 1;
    public static final int HTTP = 2;
    public static final int SOCKS = 3;
    public static final int DISABLE = -1;
    Proxy proxy;
    private String proxyHost = null;
    private Integer proxyPort = null;
    private String proxyUser = null;
    private String proxyPassword = null;
    private int timeout = 0;
    private Logger logger;

    public JCraftProxyFactory(int type, String pSocksProxyHost) {
        this.proxyHost = pSocksProxyHost;
        this.init(type);
    }

    public JCraftProxyFactory(int type, String pSocksProxyHost, Integer pSocksProxyPort) {
        this.proxyHost = pSocksProxyHost;
        this.proxyPort = pSocksProxyPort;
        this.init(type);
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    private void init(int type) {
        switch (type) {
            case 0: {
                this.proxy = this.proxyPort != null ? new ProxySOCKS5(this.proxyHost, this.proxyPort.intValue()) : new ProxySOCKS5(this.proxyHost);
                if (this.proxyUser == null) break;
                ((ProxySOCKS5)this.proxy).setUserPasswd(this.proxyUser, this.proxyPassword);
                break;
            }
            case 1: {
                this.proxy = this.proxyPort != null ? new ProxySOCKS4(this.proxyHost, this.proxyPort.intValue()) : new ProxySOCKS4(this.proxyHost);
                if (this.proxyUser == null) break;
                ((ProxySOCKS4)this.proxy).setUserPasswd(this.proxyUser, this.proxyPassword);
                break;
            }
            case 2: {
                this.proxy = this.proxyPort != null ? new ProxyHTTP(this.proxyHost, this.proxyPort.intValue()) : new ProxyHTTP(this.proxyHost);
                if (this.proxyUser == null) break;
                ((ProxyHTTP)this.proxy).setUserPasswd(this.proxyUser, this.proxyPassword);
            }
        }
    }

    @Override
    public Socket createSocket() throws IOException {
        return new Socket();
    }

    public JCraftProxyFactory(int type, String pSocksProxyHost, Integer pSocksProxyPort, String pSocksUserName, String pSocksPassword) {
        this.proxyHost = pSocksProxyHost;
        this.proxyPort = pSocksProxyPort;
        this.proxyUser = pSocksUserName;
        this.proxyPassword = pSocksPassword;
        this.init(type);
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        try {
            this.logger.debug("createSocket proxyHost: " + this.proxyHost + " proxyPort: " + this.proxyPort + " userName: " + this.proxyUser + " password: " + this.proxyPassword);
            this.proxy.connect(null, host, port, this.timeout);
            this.logger.debug("socket created: " + this.proxyHost + " proxyPort: " + this.proxyPort + " userName: " + this.proxyUser + " password: " + this.proxyPassword);
        }
        catch (Exception e) {
            this.logger.error(Messages.getString("JCraftProxyFactory.0"), (Throwable)e);
            throw new IOException(e);
        }
        return this.proxy.getSocket();
    }

    @Override
    public Socket createSocket(InetAddress host, int port) throws IOException {
        return this.createSocket(host.getCanonicalHostName(), port);
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException, UnknownHostException {
        Socket socket = this.createSocket(host, localPort);
        socket.bind(new InetSocketAddress(localHost, localPort));
        return socket;
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        Socket socket = this.createSocket(address, localPort);
        socket.bind(new InetSocketAddress(localAddress, localPort));
        return socket;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public Proxy getProxy() {
        return this.proxy;
    }
}

