/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.actionCodes;

import com.indy.engine.action.common.ActionCodeTypeI;
import com.indy.engine.actionCodes.Messages;
import com.indy.engine.common.action.ActionConfiguration;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class sqlToParameters
extends ActionCodeTypeI {
    public static final String rootElement = "sqlToParameters";
    private static String defaultDateTimeFormat;

    public sqlToParameters() {
        this.actionCodeName = "Sql to parameters";
        this.actionClassName = ((Object)((Object)this)).getClass().getName();
        this.bNullCodeAllowed = false;
        if (defaultDateTimeFormat == null && (defaultDateTimeFormat = ActionConfiguration.getOverloadValue((String)((Object)((Object)this)).getClass().getName(), (String)"defaultDateTimeFormat")) == null) {
            defaultDateTimeFormat = "yyyy/MM/dd HH:mm:ss.SSS";
        }
    }

    private String parseTxtForMetadata(String txt) {
        String xmlDefPattern = "(<sqlToParameters[^\\e]*</sqlToParameters>)";
        String xmlPart = null;
        Pattern patt = Pattern.compile(xmlDefPattern);
        Matcher m1 = patt.matcher(txt);
        if (m1.find()) {
            xmlPart = m1.group(1);
        }
        return xmlPart;
    }

    public int prepareSimpleExecuteCode() throws EngineExceptionI {
        int ret = 0;
        this.debugLog("=>prepareSimpleExecuteCode", "Preparing parameters", 3, "DEBUG");
        try {
            this.connectionName = this.getStringParameter(String.valueOf(this.runtimeContext.VAR_PREFIXE) + this.actionName + this.runtimeContext.VARIABLE_PATH_SUFFIXE + "SQL_CONNECTION");
        }
        catch (EngineExceptionI e) {
            this.connectionName = "";
        }
        try {
            this.sqlTransName = this.getStringParameter(String.valueOf(this.runtimeContext.VAR_PREFIXE) + this.actionName + this.runtimeContext.VARIABLE_PATH_SUFFIXE + "SQL_TRANSACTION_NAME");
        }
        catch (EngineExceptionI e) {
            this.sqlTransName = "T1";
        }
        try {
            this.sqlTransType = this.getStringParameter(String.valueOf(this.runtimeContext.VAR_PREFIXE) + this.actionName + this.runtimeContext.VARIABLE_PATH_SUFFIXE + "SQL_TRANSACTION_TYPE");
        }
        catch (EngineExceptionI e) {
            this.sqlTransType = "AUTOCOMMIT";
        }
        this.setTransactionAndCommit(this.sqlTransType, true);
        try {
            this.sqlSchemaName = this.getStringParameter(String.valueOf(this.runtimeContext.VAR_PREFIXE) + this.actionName + this.runtimeContext.VARIABLE_PATH_SUFFIXE + "SQL_SCHEMA_NAME");
            if (!this.sqlSchemaName.equals("")) {
                this.sqlSchemaName = String.valueOf(this.sqlSchemaName) + ".";
            }
        }
        catch (EngineExceptionI e) {
            this.sqlSchemaName = "";
        }
        this.debugLog("=>prepareSimpleExecuteCode", "Parameters Prepared", 3, "DEBUG");
        return ret;
    }

    public Document getDocumentFromXmlPart(String xmlDef) throws EngineExceptionI {
        try {
            DocumentBuilderFactory docBuilderFactory = null;
            try {
                docBuilderFactory = DocumentBuilderFactory.newInstance(this.runtimeContext.defaultDocumentBuilderFactoryClass, null);
            }
            catch (FactoryConfigurationError e) {
                docBuilderFactory = DocumentBuilderFactory.newInstance();
            }
            docBuilderFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            docBuilderFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            return docBuilder.parse(new ByteArrayInputStream(xmlDef.getBytes()));
        }
        catch (SAXException e) {
            throw new EngineExceptionI((Throwable)e);
        }
        catch (FileNotFoundException e) {
            throw new EngineExceptionI((Throwable)e);
        }
        catch (IOException e) {
            throw new EngineExceptionI((Throwable)e);
        }
        catch (ParserConfigurationException e) {
            throw new EngineExceptionI((Throwable)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String executeSQLCode(String SQL, String type, boolean failsIfNoRecord, String defaultValue, String dateTimeFormat) throws EngineExceptionI, SQLException {
        String ret;
        block23: {
            ret = null;
            Statement stmtSelect = null;
            ResultSet sourceRSet = null;
            try {
                stmtSelect = sqlToParameters.createResultSetStatement((Connection)this.jdbcConnection);
                sourceRSet = stmtSelect.executeQuery(SQL);
                if (sourceRSet.next()) {
                    if (type.equals("String")) {
                        if (dateTimeFormat != null && !dateTimeFormat.isEmpty()) {
                            try {
                                SimpleDateFormat sdf = new SimpleDateFormat(dateTimeFormat);
                                int _type = sourceRSet.getMetaData().getColumnType(1);
                                if (_type == 93) {
                                    Timestamp ts = sourceRSet.getTimestamp(1);
                                    ret = sdf.format(ts);
                                    break block23;
                                }
                                if (_type == 91) {
                                    Date dt = sourceRSet.getDate(1);
                                    ret = sdf.format(dt);
                                    break block23;
                                }
                                if (_type == 92) {
                                    Time t = sourceRSet.getTime(1);
                                    ret = sdf.format(t);
                                    break block23;
                                }
                                ret = sourceRSet.getString(1);
                            }
                            catch (Exception e) {
                                ret = sourceRSet.getString(1);
                            }
                            break block23;
                        }
                        ret = sourceRSet.getString(1);
                        break block23;
                    }
                    if (type.equals("Integer") || type.equals("Long")) {
                        BigDecimal bd = sourceRSet.getBigDecimal(1);
                        if (bd != null) {
                            ret = sourceRSet.getBigDecimal(1).toString();
                        }
                    } else {
                        if (!type.equals("Boolean")) throw new EngineExceptionI(String.valueOf(Messages.getString("sqlToParameters.0")) + type + Messages.getString("sqlToParameters.1"));
                        boolean b = sourceRSet.getBoolean(1);
                        if (!sourceRSet.wasNull()) {
                            ret = Boolean.toString(b);
                        }
                    }
                    break block23;
                }
                if (failsIfNoRecord) {
                    throw new EngineExceptionI(Messages.getString("sqlToParameters.2"));
                }
            }
            finally {
                try {
                    if (sourceRSet != null) {
                        sourceRSet.close();
                    }
                }
                finally {
                    if (stmtSelect != null) {
                        stmtSelect.close();
                    }
                }
            }
        }
        if (ret != null) return ret;
        return defaultValue;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void parseAndExecute(Document doc) throws EngineExceptionI {
        try {
            doc.getDocumentElement().normalize();
            NodeList nlChildOfParameters = null;
            Node nodeParameter = null;
            Node childOfParameter = null;
            Node attName = null;
            Node attType = null;
            NamedNodeMap attributes = null;
            String queryValue = null;
            Node root = doc.getFirstChild();
            if (root == null) return;
            NodeList nlParameters = root.getChildNodes();
            int i = 0;
            while (i < nlParameters.getLength()) {
                nodeParameter = nlParameters.item(i);
                if (nodeParameter.getNodeName().equals("parameter")) {
                    String defaultValue;
                    nlChildOfParameters = nodeParameter.getChildNodes();
                    attributes = nodeParameter.getAttributes();
                    attName = attributes.getNamedItem("name");
                    attType = attributes.getNamedItem("type");
                    Node attFailsIfNoRecord = attributes.getNamedItem("failsIfNoRecord");
                    boolean failsIfNoRecord = attFailsIfNoRecord == null || attFailsIfNoRecord.getNodeValue() == null || !attFailsIfNoRecord.getNodeValue().equals("false");
                    Node attDefaultValue = attributes.getNamedItem("defaultValue");
                    Node attDateFormat = attributes.getNamedItem("dateTimeFormat");
                    String dateFormat = defaultDateTimeFormat;
                    if (attDateFormat != null) {
                        dateFormat = attDateFormat.getNodeValue();
                    }
                    String string = defaultValue = attDefaultValue != null && attDefaultValue.getNodeValue() != null && !attDefaultValue.getNodeValue().isEmpty() ? attDefaultValue.getNodeValue() : null;
                    if (attName == null) throw new EngineExceptionI(Messages.getString("sqlToParameters.5"));
                    if (attType == null) throw new EngineExceptionI(String.valueOf(Messages.getString("sqlToParameters.3")) + attName.getNodeValue() + Messages.getString("sqlToParameters.4"));
                    int j = 0;
                    while (j < nlChildOfParameters.getLength()) {
                        childOfParameter = nlChildOfParameters.item(j);
                        if ((childOfParameter.getNodeName().equals("#text") || childOfParameter.getNodeName().equals("#cdata-section")) && (queryValue = this.executeSQLCode(childOfParameter.getNodeValue(), attType.getNodeValue(), failsIfNoRecord, defaultValue, dateFormat)) != null) {
                            this.addVariableWithULog(this.engineContext.resolveVariableName(attName.getNodeValue(), this.actionName), queryValue, attType.getNodeValue(), true);
                        }
                        ++j;
                    }
                }
                ++i;
            }
            return;
        }
        catch (Exception e) {
            if (!(e instanceof EngineExceptionI)) throw new EngineExceptionI((Throwable)e);
            throw (EngineExceptionI)((Object)e);
        }
    }

    public int executeSimpleCode() throws EngineExceptionI {
        try {
            if (this.connectionName != null && !this.connectionName.equals("")) {
                this.debugLog("executeSimpleCode", "Testing connection : " + this.connectionName, 3, "DEBUG");
                this.jdbcConnection = this.setConnection(this.connectionName, this.sqlTransName, this.sqlTransType);
                ActionCodeTypeI.setAutoCommit((Connection)this.jdbcConnection, (boolean)this.isAutoCommit());
                String xmlPart = this.parseTxtForMetadata(this.actionTxtCode);
                if (xmlPart != null) {
                    this.parseAndExecute(this.getDocumentFromXmlPart(xmlPart));
                }
            }
            if (this.sqlTransType.equals("AUTONOMOUS") || this.sqlTransType.equals("AUTOCOMMIT")) {
                this.closeConnection(this.connectionName, this.sqlTransName, this.sqlTransType, true);
            }
        }
        catch (Exception e) {
            throw new EngineExceptionI((Throwable)e);
        }
        return 0;
    }
}

