/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.actionCodes.xml.unload;

import com.indy.engine.action.common.ActionCodeTypeI;
import com.indy.engine.actionCodes.JdbcToXmlActionCodeI;
import com.indy.engine.actionCodes.xml.unload.Messages;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.io.FileUtils;

public abstract class AbstractXmlWriterAPI {
    static UniqueTimestampGenerator utg = new UniqueTimestampGenerator();
    public static Map<String, XmlTransaction> transactions = new HashMap<String, XmlTransaction>();
    public XMLStreamWriter xmlw;
    protected OutputStreamWriter osw;
    private File temporaryFile;
    private String temporaryFilePrefix;
    int temporaryFileIndex = 1;
    NoDataBehaviour noDataBehaviour = NoDataBehaviour.raiseException;
    FileAlreadyExistsBehaviour fileAlreadyExistsBehaviour = FileAlreadyExistsBehaviour.replace;
    private boolean commit;
    protected String encoding;
    private boolean writeXmlDeclaration;
    private String xmlVersion;
    private File outFile;
    private ActionCodeTypeI actionCode;
    long nbOpenedElement = 0L;

    public AbstractXmlWriterAPI(boolean commit, String encoding, boolean writeXmlDeclaration, String xmlVersion, File outFile, ActionCodeTypeI actionCode, NoDataBehaviour noDataBehaviour, FileAlreadyExistsBehaviour fileAreaydExistsBehaviour) {
        this.noDataBehaviour = noDataBehaviour;
        this.fileAlreadyExistsBehaviour = fileAreaydExistsBehaviour;
        this.commit = commit;
        this.encoding = encoding;
        this.writeXmlDeclaration = writeXmlDeclaration;
        this.xmlVersion = xmlVersion;
        this.outFile = outFile;
        this.actionCode = actionCode;
        this.temporaryFilePrefix = String.valueOf(outFile.getParent()) + "/" + actionCode.getActionContext().getSessionId() + "." + utg.newTimestamp() + ".temp.";
    }

    private void _close() throws Exception {
        this.xmlw.close();
        this.closeCurrent();
    }

    public void close() throws EngineExceptionI {
        if (this.commit && this.xmlw != null) {
            try {
                this._close();
            }
            catch (Exception e) {
                throw new EngineExceptionI((Throwable)e);
            }
        }
    }

    public abstract void closeCurrent() throws Exception;

    public boolean startNewDocument(boolean hasRawData) throws XMLStreamException, IOException {
        boolean opening;
        String sessionId = this.actionCode.getActionContext().getSessionId();
        String transactionId = this.outFile.getAbsolutePath();
        XmlTransaction xmlTransac = transactions.get(String.valueOf(sessionId) + transactionId);
        if (xmlTransac == null) {
            this.temporaryFile = new File(String.valueOf(this.temporaryFilePrefix) + this.temporaryFileIndex++ + "." + this.outFile.getName());
            if (!this.temporaryFile.getParentFile().exists()) {
                this.temporaryFile.getParentFile().mkdirs();
            }
            this.xmlw = this.createWriter(this.temporaryFile, hasRawData);
            if (this.writeXmlDeclaration) {
                this.xmlw.writeStartDocument(this.encoding != null ? this.encoding : Charset.defaultCharset().displayName(), this.xmlVersion);
            }
            opening = true;
        } else {
            opening = false;
            this.xmlw = xmlTransac.xmlw;
        }
        return opening;
    }

    public abstract XMLStreamWriter createWriter(File var1, boolean var2) throws XMLStreamException, FileNotFoundException, IOException;

    public boolean endCurrentDocument(File file) throws Exception {
        boolean ret = false;
        if (this.commit) {
            boolean hasData;
            boolean bl = hasData = this.nbOpenedElement > 0L;
            if (!hasData) {
                this.addRoot();
            }
            this.xmlw.writeEndDocument();
            this._close();
            if (this.temporaryFile.exists() && (hasData || this.noDataBehaviour == NoDataBehaviour.createEmptyFile)) {
                boolean toWrite = true;
                if (file.exists()) {
                    if (this.fileAlreadyExistsBehaviour == FileAlreadyExistsBehaviour.raiseException) {
                        throw new EngineExceptionI(String.valueOf(Messages.getString("AbstractXmlWriterAPI.0")) + file.toString() + Messages.getString("AbstractXmlWriterAPI.1"));
                    }
                    if (this.fileAlreadyExistsBehaviour == FileAlreadyExistsBehaviour.replace) {
                        boolean deleted = file.delete();
                        if (!deleted) {
                            throw new EngineExceptionI(String.valueOf(Messages.getString("AbstractXmlWriterAPI.2")) + file.getAbsolutePath());
                        }
                    } else if (this.fileAlreadyExistsBehaviour == FileAlreadyExistsBehaviour.preserve) {
                        toWrite = false;
                    }
                }
                if (toWrite) {
                    int code;
                    if (!file.getParentFile().exists()) {
                        file.getParentFile().mkdirs();
                    }
                    if ((code = this.renameTo(this.temporaryFile, file)) < 1) {
                        throw new EngineExceptionI(String.valueOf(Messages.getString("AbstractXmlWriterAPI.3")) + code + ") :" + this.temporaryFile.getAbsolutePath() + Messages.getString("AbstractXmlWriterAPI.4") + file.getAbsolutePath());
                    }
                } else {
                    this.temporaryFile.delete();
                }
                ret = true;
            } else {
                boolean deleted;
                this.temporaryFile.delete();
                if (file.exists() && !(deleted = file.delete())) {
                    throw new EngineExceptionI(String.valueOf(Messages.getString("AbstractXmlWriterAPI.5")) + file.getAbsolutePath());
                }
                switch (this.noDataBehaviour) {
                    case deleteExistingFile: {
                        break;
                    }
                    case createEmptyFile: {
                        file.createNewFile();
                        ret = true;
                        break;
                    }
                    case raiseException: {
                        throw new EngineExceptionI(Messages.getString("AbstractXmlWriterAPI.6"));
                    }
                }
            }
        } else {
            ret = false;
            String id = this.actionCode.getActionContext().getSessionId();
            String transactionId = this.outFile.getAbsolutePath();
            XmlTransaction xmlTransac = transactions.get(String.valueOf(id) + transactionId);
            transactions.put(String.valueOf(id) + transactionId, new XmlTransaction(id, transactionId, this.xmlw));
        }
        return ret;
    }

    private int renameTo(File source, File dest) throws IOException {
        if (!source.renameTo(dest)) {
            try {
                FileUtils.copyFile((File)source, (File)dest);
            }
            catch (IOException io) {
                return -1;
            }
            if (!source.delete()) {
                return -2;
            }
            return 2;
        }
        return 1;
    }

    public abstract void addRoot() throws XMLStreamException;

    public File getOutFile() {
        return this.outFile;
    }

    public void writeAttribute(JdbcToXmlActionCodeI.IndyAttribute attribute, String strValue, Object value, int sourceType) throws Exception {
        if (attribute.getNSUri() != null) {
            if (attribute.getPrefix() != null) {
                this.xmlw.writeAttribute(attribute.getPrefix(), attribute.getNSUri(), attribute.getLocalName(), strValue);
            } else {
                this.xmlw.writeAttribute(attribute.getNSUri(), attribute.getLocalName(), strValue);
            }
        } else {
            this.xmlw.writeAttribute(attribute.getLocalName(), strValue);
        }
    }

    public void writeStartElement(JdbcToXmlActionCodeI.IndyElement element) throws XMLStreamException {
        if (element.getNSUri() != null) {
            if (element.getPrefix() != null) {
                this.writeStartElement(element.getPrefix(), element.getLocalName(), element.getNSUri());
            } else {
                this.xmlw.setDefaultNamespace(element.getNSUri());
                this.writeStartElement(element.getLocalName());
            }
        } else {
            this.writeStartElement(element.getLocalName());
        }
    }

    public void writeText(JdbcToXmlActionCodeI.IndyElement indyElement, String data, Object value, int sourceType) throws Exception {
        if (indyElement.useCDATA) {
            this.xmlw.writeCData(data);
        } else {
            this.xmlw.writeCharacters(data);
        }
    }

    public abstract void writeNewLineCharacter() throws Exception;

    public void incNbOpenedElement(int nbelt) {
        this.nbOpenedElement += (long)nbelt;
    }

    public void writeStartElement(String paramString1, String paramString2, String paramString3) throws XMLStreamException {
        this.xmlw.writeStartElement(paramString1, paramString2, paramString3);
        this.incNbOpenedElement(1);
    }

    public void writeStartElement(String paramString) throws XMLStreamException {
        this.xmlw.writeStartElement(paramString);
        this.incNbOpenedElement(1);
    }

    public void writeStartElement(String paramString1, String paramString2) throws XMLStreamException {
        this.xmlw.writeStartElement(paramString1, paramString2);
        this.incNbOpenedElement(1);
    }

    public void interrupt() {
    }

    public void writeEndElement(JdbcToXmlActionCodeI.IndyElement element) throws XMLStreamException {
        this.xmlw.writeEndElement();
    }

    public void writeNamespace(String prefix, String nameSpaceUri) throws XMLStreamException {
        this.xmlw.writeNamespace(prefix, nameSpaceUri);
    }

    public void writeDefaultNamespace(String targetNamespace) throws XMLStreamException {
        this.xmlw.writeDefaultNamespace(targetNamespace);
    }

    public Exception getWrapperException() {
        return null;
    }

    public static enum FileAlreadyExistsBehaviour {
        replace,
        raiseException,
        preserve;

    }

    public static enum NoDataBehaviour {
        raiseException,
        createEmptyFile,
        deleteExistingFile;

    }

    static class UniqueTimestampGenerator {
        long currentTimestamp;
        int currentSequence;

        UniqueTimestampGenerator() {
        }

        public synchronized String newTimestamp() {
            long newTimestamp = System.currentTimeMillis();
            if (newTimestamp == this.currentTimestamp) {
                ++this.currentSequence;
            } else {
                this.currentTimestamp = newTimestamp;
                this.currentSequence = 0;
            }
            return String.valueOf(this.currentTimestamp) + "." + this.currentSequence;
        }
    }

    class XmlTransaction {
        XMLStreamWriter xmlw;
        String sessionId;
        String transactionId;

        public XmlTransaction(String sessionId, String transactionId, XMLStreamWriter xmlw) {
            this.sessionId = sessionId;
            this.transactionId = transactionId;
            this.xmlw = xmlw;
        }
    }
}

