/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.actionCodes.xml.unload;

import com.indy.engine.actionCodes.utils.IndyContentHandler;
import com.indy.engine.actionCodes.xml.unload.XmlContainer;
import com.indy.engine.actionCodes.xml.unload.XmlField;
import com.indy.engine.core.actionCodes.convert.ParserProvider;
import com.indy.runtime.json.JsonUtils;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public abstract class AnalyzeContentHandler
extends IndyContentHandler {
    List<XmlContainer> pile = new ArrayList<XmlContainer>();
    Node root = new Node();
    protected String superRootName;
    String firstElementName;
    private ParserProvider parserProvider;
    private boolean attributeAsElement;
    private boolean isJson;
    private int absolutePosition = 0;
    List<XmlContainer> allContainers = new ArrayList<XmlContainer>();

    void addContainer(XmlContainer container, String regexp) {
        for (Node current : this.initNode(container.path)) {
            current.container = container;
        }
        this.allContainers.add(container);
    }

    void addField(String path, XmlField field, String functionName, String regexp) {
        for (Node current : this.initNode(path)) {
            current.field = field;
            if (functionName == null) continue;
            current.function = this.getInternalFunctionHelper(functionName, current);
            current.parent.childrenFunction.add(current);
        }
    }

    public Node getRoot() {
        return this.root;
    }

    private List<Node> initNode(String[] fullPath, int index, Node currentNode) {
        String path = fullPath[index];
        ArrayList<Node> nodes = new ArrayList<Node>();
        if (this.isJson) {
            this.initNode(fullPath, index, currentNode, path, nodes);
        } else {
            String[] stringArray = path.split("\\|");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String _path = stringArray[n2];
                this.initNode(fullPath, index, currentNode, _path, nodes);
                ++n2;
            }
        }
        return nodes;
    }

    private void initNode(String[] fullPath, int index, Node currentNode, String path, List<Node> nodes) {
        Node node = currentNode.getLocalNode(path, true);
        if (index == fullPath.length - 1) {
            nodes.add(node);
        } else {
            nodes.addAll(this.initNode(fullPath, ++index, node));
        }
    }

    public List<Node> initNode(String fullPath) {
        if (fullPath.startsWith("//")) {
            fullPath = fullPath.substring(2);
        }
        String[] split = fullPath.split("/");
        return this.initNode(split, 0, this.root);
    }

    public AnalyzeContentHandler(String superRoot, ParserProvider parserProvider, boolean attributeAsElement, boolean isJson) {
        this.superRootName = superRoot;
        this.parserProvider = parserProvider;
        this.attributeAsElement = attributeAsElement;
        this.isJson = isJson;
    }

    public abstract XmlField createNewField();

    public abstract XmlContainer createNewContainer();

    public abstract Callable getInternalFunctionHelper(String var1, Node var2);

    public void startElement(String nameSpaceURI, String localName, String rawName, Attributes attributs) throws SAXException {
        if (localName.equals("field")) {
            XmlField field = this.createNewField();
            String functionName = null;
            String regexp = null;
            if (this.pile.size() > 0) {
                field.setDatastore(this.pile.get(this.pile.size() - 1));
            }
            int index = 0;
            while (index < attributs.getLength()) {
                String tmp1 = attributs.getValue(index);
                if (attributs.getQName(index).equals("id")) {
                    field.id = attributs.getValue(index);
                } else if (attributs.getQName(index).equals("name")) {
                    field.name = attributs.getValue(index);
                } else if (attributs.getQName(index).equals("fullPath")) {
                    field.path = String.valueOf(this.superRootName) + attributs.getValue(index);
                    if (this.attributeAsElement) {
                        field.path = field.path.replace("@", "");
                    }
                } else if (attributs.getQName(index).equals("type")) {
                    field.parser = this.parserProvider.getParser(attributs.getValue(index));
                } else if (attributs.getQName(index).equals("property")) {
                    functionName = attributs.getValue(index);
                }
                ++index;
            }
            this.addField(field.path, field, functionName, regexp);
        }
        if (localName.equals("datastore")) {
            XmlContainer datastore = null;
            datastore = this.createNewContainer();
            String regexp = null;
            if (this.pile.size() > 0) {
                datastore.parent = this.pile.get(this.pile.size() - 1);
            }
            this.pile.add(datastore);
            if (datastore != null) {
                int index = 0;
                while (index < attributs.getLength()) {
                    if (attributs.getQName(index).equals("id")) {
                        datastore.id = attributs.getValue(index);
                    } else if (attributs.getQName(index).equals("name")) {
                        datastore.name = attributs.getValue(index);
                    } else if (attributs.getQName(index).equals("fullPath")) {
                        String tt = attributs.getValue(index);
                        if (this.firstElementName == null) {
                            int _index = tt.indexOf("/");
                            _index = _index == -1 ? tt.length() : _index;
                            this.firstElementName = tt.substring(0, _index);
                        }
                        datastore.path = String.valueOf(this.superRootName) + tt;
                    } else if (attributs.getQName(index).equals("regexpSelector")) {
                        regexp = attributs.getValue(index);
                    }
                    ++index;
                }
            }
            this.addContainer(datastore, regexp);
        }
    }

    public void endElement(String nameSpaceURI, String localName, String rawName) throws SAXException {
        if (localName.equals("datastore") && this.pile.size() > 0) {
            this.pile.remove(this.pile.size() - 1);
        }
    }

    public void characters(char[] ch, int start, int end) throws SAXException {
        this.pile.size();
    }

    public String getFirstElementName() {
        return this.firstElementName;
    }

    public List<XmlContainer> allContainers() {
        return this.allContainers;
    }

    public final class Node {
        Map<String, Node> children = new HashMap<String, Node>();
        Map<String, Node> attributes = new HashMap<String, Node>();
        List<Node> childrenFunction = new ArrayList<Node>();
        Map<String, Node> regexpNode = new HashMap<String, Node>();
        public Node parent;
        public String regexp;
        public Callable<String> function;
        public String currentName;
        public Boolean textDone = null;
        public XmlContainer container;
        public XmlField field;
        public String name;
        int position = 0;

        public String toString() {
            if (this.currentName == null) {
                return "/";
            }
            return String.valueOf(this.parent != null ? this.parent.toString() : "") + "/" + this.currentName;
        }

        public List<Node> getFunctions() {
            return this.childrenFunction;
        }

        private String decode(String decode) {
            if (decode.startsWith("_.") && decode.endsWith("._")) {
                String _decode = decode.substring(2, decode.length() - 2);
                try {
                    return JsonUtils.decodeHexString((String)_decode);
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            }
            return decode;
        }

        public Node getLocalNode(String str, boolean init) {
            if (str.startsWith("@")) {
                return this.getLocalNode(true, str.substring(1), init);
            }
            return this.getLocalNode(false, str, init);
        }

        public Node getLocalNode(boolean attribute, String str, boolean init) {
            Node child;
            Node node = child = attribute ? this.attributes.get(str) : this.children.get(str);
            if (child != null) {
                return child;
            }
            if (child == null && this.regexpNode.size() > 0) {
                if (init) {
                    child = this.regexpNode.get(str);
                } else {
                    for (Node node2 : this.regexpNode.values()) {
                        String decode = this.decode(str);
                        if (node2.regexp == null || !decode.matches(node2.regexp)) continue;
                        node2.currentName = decode;
                        return node2;
                    }
                }
            }
            if (child == null) {
                child = new Node();
                child.currentName = this.decode(str);
                child.parent = this;
                if (init && str.startsWith("regexp:")) {
                    if (this.regexpNode.get(str) == null) {
                        child.regexp = str.substring(7);
                        this.regexpNode.put(str, child);
                    }
                } else if (attribute) {
                    this.attributes.put(str, child);
                } else {
                    this.children.put(str, child);
                }
            }
            return child;
        }

        public String getPath() {
            String _parent = this.parent != null && this.parent.currentName != null ? this.parent.getPath() : "";
            return String.valueOf(_parent) + "/" + this.currentName + "[" + this.position + "]";
        }

        public int getPosition() {
            return this.position;
        }

        public int getAbsolutePosition() {
            return AnalyzeContentHandler.this.absolutePosition;
        }

        public void incrPosition() {
            ++this.position;
            AnalyzeContentHandler analyzeContentHandler = AnalyzeContentHandler.this;
            analyzeContentHandler.absolutePosition = analyzeContentHandler.absolutePosition + 1;
        }

        public void clearPosition() {
            for (Node child : this.children.values()) {
                child.position = 0;
            }
            for (Node child : this.attributes.values()) {
                child.position = 0;
            }
        }
    }
}

