/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.component.azure.table.storage.runtime;

import com.azure.data.tables.TableClient;
import com.azure.data.tables.TableServiceClient;
import com.azure.data.tables.TableServiceClientBuilder;
import com.azure.data.tables.models.TableEntity;
import com.azure.data.tables.models.TableTransactionAction;
import com.azure.data.tables.models.TableTransactionActionType;
import com.azure.data.tables.models.TableTransactionFailedException;
import com.indy.engine.common.tools.OutputStreamTransformer;
import com.indy.engine.common.tools.impl.JavaObjectHandler;
import com.indy.engine.common.tools.impl.JavaRealObjectHandler;
import com.semarchy.xdi.component.azure.table.storage.runtime.AzureTableMetadata;
import com.semarchy.xdi.component.azure.table.storage.runtime.Messages;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AzureTableTransformer
implements JavaRealObjectHandler<Object, AzureTableMetadata> {
    private TableServiceClient tableServiceClient;
    private TableClient tableClient;
    private List<TableTransactionAction> batchedActions;
    private Integer batchSize;
    private OutputStreamTransformer.StatisticHandler sh = null;
    private Logger logger = LogManager.getLogger(this.getClass());

    public void init(AzureTableMetadata metadata, JavaObjectHandler.InitHandler handler) throws Exception {
        this.tableServiceClient = new TableServiceClientBuilder().connectionString(metadata.getConnectionString()).buildClient();
        this.tableClient = this.tableServiceClient.getTableClient(metadata.getTableName());
        this.batchedActions = new ArrayList<TableTransactionAction>();
        this.batchSize = metadata.getBatchSize() >= 1 ? metadata.getBatchSize() : (metadata.getBatchSize() == -1 ? Integer.valueOf(Integer.MAX_VALUE) : Integer.valueOf(1));
    }

    public void handleObject(Object objExchange, AzureTableMetadata metadata, OutputStreamTransformer.StatisticHandler sh) throws Exception {
        this.sh = sh;
        Map exchange = (Map)objExchange;
        if (metadata.getOperation() == null) {
            throw new EngineExceptionI(Messages.getString("AzureTableTransformer.0"));
        }
        if (metadata.getOperation().equals((Object)AzureTableMetadata.Operation.get)) {
            this.handleGet(exchange);
        } else {
            TableEntity entity = this.createEntity(metadata, exchange);
            TableTransactionAction action = this.createAction(metadata.getOperation(), entity);
            if (action != null) {
                this.batchedActions.add(action);
                if (this.batchedActions.size() == this.batchSize.intValue()) {
                    try {
                        this.tableClient.submitTransaction(this.batchedActions);
                    }
                    catch (TableTransactionFailedException e) {
                        this.logger.warn("The operation failed with the following exception : ", (Object)e.getValue());
                        throw e;
                    }
                    for (TableTransactionAction act : this.batchedActions) {
                        this.handleStatistic(act.getActionType());
                    }
                    this.batchedActions.clear();
                }
            }
        }
    }

    public void close() throws Exception {
        if (!this.batchedActions.isEmpty()) {
            try {
                this.tableClient.submitTransaction(this.batchedActions);
            }
            catch (TableTransactionFailedException e) {
                this.logger.warn("The operation failed with the following exception : ", (Object)e.getValue());
                throw e;
            }
            for (TableTransactionAction act : this.batchedActions) {
                this.handleStatistic(act.getActionType());
            }
        }
    }

    private void handleStatistic(TableTransactionActionType type) {
        switch (type) {
            case CREATE: {
                this.sh.handle("AZURE_TABLE_STORAGE_CREATE", 1L);
                break;
            }
            case DELETE: {
                this.sh.handle("AZURE_TABLE_STORAGE_DELETE", 1L);
                break;
            }
            case UPDATE_MERGE: {
                this.sh.handle("AZURE_TABLE_STORAGE_UPDATE", 1L);
                break;
            }
            case UPSERT_MERGE: {
                this.sh.handle("AZURE_TABLE_STORAGE_UPSERT", 1L);
                break;
            }
        }
    }

    public int batchSize() {
        return this.batchSize;
    }

    private Object convertValueToType(Object value, AzureTableMetadata.ODataType type) {
        Object converted = null;
        switch (type) {
            case Binary: {
                converted = value.toString().getBytes();
                break;
            }
            case Boolean: {
                converted = Boolean.valueOf(value.toString());
                break;
            }
            case DateTime: {
                converted = OffsetDateTime.parse(value.toString());
                break;
            }
            case Guid: {
                converted = UUID.fromString(value.toString());
                break;
            }
            case Int32: {
                converted = Integer.parseInt(value.toString());
                break;
            }
            case Int64: {
                converted = Long.parseLong(value.toString());
                break;
            }
            case Double: {
                converted = Double.parseDouble(value.toString());
                break;
            }
            case String: {
                converted = value.toString();
                break;
            }
            default: {
                converted = value;
            }
        }
        return converted;
    }

    private TableEntity createEntity(AzureTableMetadata metadata, Map<String, Object> data) {
        String partitionKey = (String)data.remove("partitionkey");
        String rowKey = (String)data.remove("rowkey");
        TableEntity entity = new TableEntity(partitionKey, rowKey);
        for (Map.Entry<String, Object> entry : data.entrySet()) {
            AzureTableMetadata.ODataType type = metadata.getType(entry.getKey());
            if (type != null) {
                Object value = this.convertValueToType(entry.getValue(), type);
                entity.addProperty(entry.getKey(), value);
                continue;
            }
            entity.addProperty(entry.getKey(), entry.getValue());
        }
        return entity;
    }

    private TableTransactionAction createAction(AzureTableMetadata.Operation operation, TableEntity entity) {
        TableTransactionAction action = null;
        switch (operation) {
            case create: {
                action = new TableTransactionAction(TableTransactionActionType.CREATE, entity);
                break;
            }
            case update: {
                action = new TableTransactionAction(TableTransactionActionType.UPDATE_MERGE, entity);
                break;
            }
            case upsert: {
                action = new TableTransactionAction(TableTransactionActionType.UPSERT_MERGE, entity);
                break;
            }
            case delete: {
                action = new TableTransactionAction(TableTransactionActionType.DELETE, entity);
                break;
            }
        }
        return action;
    }

    private void handleGet(Map<String, Object> exchange) {
        String partitionKey = (String)exchange.remove("partitionkey");
        String rowKey = (String)exchange.remove("rowkey");
        TableEntity fetchedEntity = this.tableClient.getEntity(partitionKey, rowKey);
        for (Map.Entry entry : fetchedEntity.getProperties().entrySet()) {
            exchange.put(((String)entry.getKey()).toLowerCase(), entry.getValue().toString());
        }
        this.sh.handle("AZURE_TABLE_STORAGE_GET", 1L);
    }
}

