/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ui.utils;

import com.indy.engine.log.engine.EngineRegistry;
import com.indy.ui.tools.widget.ItemSelectionDialog;
import com.indy.ui.utils.Messages;
import com.stambia.ui.tools.Activator;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

public class DeliveryUtils {
    public static void executeDelivery(String host, int port, String user, String password, String deliveryName, String sessionName, Map<String, Object> variables, String[] confs, String repoDir, String logLevel) {
        try {
            MessageBox mb;
            boolean avoid = false;
            if (EngineRegistry.getDefault().isExternalizedDelivery(host, port, user, password, deliveryName, repoDir, logLevel)) {
                if (confs.length == 0) {
                    mb = new MessageBox(Display.getDefault().getActiveShell(), 1);
                    mb.setText(Messages.DeliveryUtils_0);
                    mb.setMessage(Messages.DeliveryUtils_1);
                    mb.open();
                    avoid = true;
                } else {
                    ItemSelectionDialog confSelectionDialog = new ItemSelectionDialog(Display.getDefault().getActiveShell(), confs, Messages.DeliveryUtils_2, Messages.DeliveryUtils_3, Messages.DeliveryUtils_4);
                    int i = confSelectionDialog.open();
                    if (i == 1) {
                        avoid = true;
                    }
                    if (!avoid && confSelectionDialog.getSelectedItem() != null) {
                        EngineRegistry.getDefault().executeDelivery(host, port, user, password, deliveryName, sessionName, variables, confSelectionDialog.getSelectedItem(), repoDir, logLevel);
                    }
                }
            } else {
                EngineRegistry.getDefault().executeDelivery(host, port, user, password, deliveryName, sessionName, variables, null, repoDir, logLevel);
            }
            if (!avoid) {
                mb = new MessageBox(Display.getDefault().getActiveShell(), 16);
                mb.setText(Messages.DeliveryUtils_5);
                mb.setMessage(Messages.DeliveryUtils_6);
                mb.open();
            }
        }
        catch (RuntimeException re) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "com.indy.ui.tools", re.getMessage(), (Throwable)re));
            ErrorDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.Error, (String)(String.valueOf(Messages.DeliveryUtils_8) + deliveryName), (IStatus)new Status(4, "com.indy.ui.tools", re.getMessage(), (Throwable)re));
        }
        catch (Exception e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "com.indy.ui.tools", e.getMessage(), (Throwable)e));
            ErrorDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.Error, (String)(String.valueOf(Messages.DeliveryUtils_8) + deliveryName), (IStatus)new Status(4, "com.indy.ui.tools", e.getMessage(), (Throwable)e));
        }
    }
}

