/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.ui.tools;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolItem;

public abstract class DropdownSelectionListener
extends SelectionAdapter {
    int mouseX = 0;
    int mouseY = 0;
    private ToolItem dropdown;
    private Menu menu;
    private Map<String, MenuItem> menuItems;

    public DropdownSelectionListener(ToolItem _dropdown) {
        this.dropdown = _dropdown;
        this.menu = new Menu((Control)this.dropdown.getParent().getShell());
        this.menuItems = new HashMap<String, MenuItem>();
    }

    public void clear() {
        for (MenuItem menuItem : this.menuItems.values()) {
            menuItem.dispose();
        }
    }

    public void add(String item, Image image, final Object obj) {
        MenuItem menuItem = new MenuItem(this.menu, 0);
        menuItem.setText(item);
        menuItem.setImage(image);
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DropdownSelectionListener.this.onMenuItemSelection(obj);
            }
        });
        this.menuItems.put(item, menuItem);
    }

    public void widgetSelected(SelectionEvent event) {
        ToolItem item = (ToolItem)event.widget;
        Rectangle rect = item.getBounds();
        Point pt = item.getParent().toDisplay(new Point(rect.x, rect.y));
        this.menu.setLocation(pt.x, pt.y + rect.height);
        this.menu.setVisible(true);
    }

    public abstract void onMenuItemSelection(Object var1);
}

