/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.ui.tools;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import javax.xml.datatype.XMLGregorianCalendar;
import org.eclipse.emf.ecore.xml.type.internal.XMLCalendar;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class Utils {
    public static Section createSection(FormToolkit toolkit, Composite parent, String text) {
        return Utils.createSection(toolkit, parent, text, 2048);
    }

    public static Section createSection(FormToolkit toolkit, Composite parent, String text, int sectionStyle) {
        Section section = toolkit.createSection(parent, sectionStyle);
        section.setText(text);
        section.setTitleBarForeground(new Color((Device)Display.getDefault(), 107, 107, 107));
        section.setBackground(new Color((Device)Display.getDefault(), 247, 247, 247));
        return section;
    }

    public static boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            int i = 0;
            while (i < children.length) {
                boolean success = Utils.deleteDir(new File(dir, children[i]));
                if (!success) {
                    return false;
                }
                ++i;
            }
        }
        return dir.delete();
    }

    public static int compareToWithNull(Comparable o1, Object o2) {
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o2 == null) {
            return 1;
        }
        if (o1 == null) {
            return -1;
        }
        if (o1.getClass().getName().equals(o2.getClass().getName())) {
            return o1.compareTo(o2);
        }
        return 0;
    }

    public static String getElapsedTime(Long startDate, Long endDate) {
        long delta = endDate - startDate;
        return Utils.longToDateString(delta);
    }

    public static String longToDateString(Long date) {
        long hours = TimeUnit.MILLISECONDS.toHours(date);
        date = date - TimeUnit.HOURS.toMillis(hours);
        long minutes = TimeUnit.MILLISECONDS.toMinutes(date);
        date = date - TimeUnit.MINUTES.toMillis(minutes);
        long seconds = TimeUnit.MILLISECONDS.toSeconds(date);
        date = date - TimeUnit.SECONDS.toMillis(seconds);
        long milliSeconds = TimeUnit.MILLISECONDS.toMillis(date);
        return String.valueOf(String.format("%02d", hours)) + ":" + String.format("%02d", minutes) + ":" + String.format("%02d", seconds) + "." + String.format("%03d", milliSeconds);
    }

    public static String removeExtension(String s) {
        String separator = System.getProperty("file.separator");
        int lastSeparatorIndex = s.lastIndexOf(separator);
        String filename = lastSeparatorIndex == -1 ? s : s.substring(lastSeparatorIndex + 1);
        int extensionIndex = filename.lastIndexOf(".");
        if (extensionIndex == -1) {
            return filename;
        }
        return filename.substring(0, extensionIndex);
    }

    public static int convertWidthInCharsToPixels(Control control, int charCount) {
        GC gc = new GC((Drawable)control);
        gc.setFont(control.getFont());
        FontMetrics fontMetrics = gc.getFontMetrics();
        gc.dispose();
        return Dialog.convertWidthInCharsToPixels((FontMetrics)fontMetrics, (int)charCount);
    }

    public static MOVE_STATUS moveFile(File source, File target) {
        if (source.renameTo(target)) {
            return MOVE_STATUS.STANDARD_MOVE_DONE;
        }
        if (!source.exists()) {
            return MOVE_STATUS.SOURCE_UNEXISTS;
        }
        try {
            Utils.copyfile(source, target);
        }
        catch (IOException e) {
            e.printStackTrace();
            return MOVE_STATUS.COPY_ERROR;
        }
        if (!source.delete()) {
            return MOVE_STATUS.COPY_AND_NOT_DELETE;
        }
        return MOVE_STATUS.COPY_AND_DELETE_DONE;
    }

    public static void copyfile(File srFile, File dtFile) throws IOException {
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            int len;
            in = new FileInputStream(srFile);
            out = new FileOutputStream(dtFile);
            byte[] buf = new byte[1024];
            while ((len = ((InputStream)in).read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
        }
        finally {
            IOException e1 = null;
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException e) {
                    e1 = e;
                }
            }
            IOException e2 = null;
            if (out != null) {
                try {
                    ((OutputStream)out).close();
                }
                catch (IOException e) {
                    e2 = e;
                }
            }
            if (e1 != null) {
                throw e1;
            }
            if (e2 != null) {
                throw e2;
            }
        }
    }

    public static XMLGregorianCalendar dateToXmlDate(Date date) {
        if (date == null) {
            return null;
        }
        return new XMLCalendar(date, 0);
    }

    public static String replaceWildCharsWithGroups(String wild) {
        StringBuffer buffer = new StringBuffer();
        char[] chars = wild.toCharArray();
        int i = 0;
        while (i < chars.length) {
            if (chars[i] == '*') {
                buffer.append("(.*)");
            } else if (chars[i] == '?') {
                buffer.append("(.)");
            } else if ("+()^$.{}[]|\\".indexOf(chars[i]) != -1) {
                buffer.append('\\').append(chars[i]);
            } else {
                buffer.append(chars[i]);
            }
            ++i;
        }
        return buffer.toString();
    }

    public static void printExecutionTime(long startTime, String log) {
        long endTime = System.nanoTime();
        long time_ns = endTime - startTime;
        long time_ms = TimeUnit.NANOSECONDS.toMillis(time_ns);
        long time_sec = TimeUnit.NANOSECONDS.toSeconds(time_ns);
        long time_min = TimeUnit.NANOSECONDS.toMinutes(time_ns);
        long time_hour = TimeUnit.NANOSECONDS.toHours(time_ns);
        System.out.print(String.valueOf(log) + " ");
        if (time_hour > 0L) {
            System.out.print(String.valueOf(time_hour) + " Hours, ");
        }
        if (time_min > 0L) {
            System.out.print(String.valueOf(time_min % 60L) + " Minutes, ");
        }
        if (time_sec > 0L) {
            System.out.print(String.valueOf(time_sec % 60L) + " Seconds, ");
        }
        if (time_ms > 0L) {
            System.out.print(String.valueOf((double)time_ms % 1000.0) + " MicroSeconds, ");
        }
        if (time_ns > 0L) {
            System.out.print(String.valueOf((double)time_ns % 1000000.0) + " NanoSeconds");
        }
        System.out.print("\n");
    }

    public static enum MOVE_STATUS {
        SOURCE_UNEXISTS(false),
        STANDARD_MOVE_DONE(true),
        COPY_ERROR(false),
        COPY_AND_DELETE_DONE(true),
        COPY_AND_NOT_DELETE(true);

        boolean success = false;

        public boolean isSuccess() {
            return this.success;
        }

        private MOVE_STATUS(boolean success) {
            this.success = success;
        }
    }
}

