/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.ui.tools.binding;

import java.util.HashSet;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateListStrategy;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.ListDiff;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.emf.databinding.edit.EMFEditProperties;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class BindingEnumeration {
    private HashSet<Button> buttonList;
    private FormToolkit toolkit;
    private Binding binding;
    private DataBindingContext ctx;
    private EStructuralFeature feature;
    private EditingDomain domain;
    private UpdateListStrategy updateStrategyTarget;
    private UpdateListStrategy updateStrategyModel;
    private Composite parent;
    private IObservableList observableList;

    public BindingEnumeration(Composite parent, FormToolkit toolkit, EStructuralFeature feature, EditingDomain domain) {
        this.toolkit = toolkit;
        this.feature = feature;
        this.domain = domain;
        this.parent = parent;
        this.buttonList = new HashSet();
        this.ctx = new DataBindingContext();
        this.observableList = new WritableList(){

            protected void fireListChange(ListDiff diff) {
                super.fireListChange(diff);
                if (BindingEnumeration.this.observableList != null) {
                    BindingEnumeration.this.refreshButtonState();
                }
            }
        };
    }

    public void addBindedCheckButton(String text, Object data) {
        Button btn = this.toolkit.createButton(this.parent, text, 32);
        btn.setData(data);
        btn.addSelectionListener((SelectionListener)new SelectionAdapter(){
            private static final long serialVersionUID = 1L;

            public void widgetSelected(SelectionEvent e) {
                Button selected = (Button)e.widget;
                if (selected.getSelection()) {
                    BindingEnumeration.this.observableList.add(selected.getData());
                } else if (BindingEnumeration.this.observableList.contains(selected.getData())) {
                    BindingEnumeration.this.observableList.remove(selected.getData());
                }
            }
        });
        this.buttonList.add(btn);
    }

    private void refreshButtonState() {
        for (Button button : this.buttonList) {
            if (this.observableList.contains(button.getData())) {
                button.setSelection(true);
                continue;
            }
            button.setSelection(false);
        }
    }

    public IObservableList getTargetObservableList() {
        return this.observableList;
    }

    public void setEObject(EObject eObject) {
        if (eObject != null) {
            if (this.binding != null) {
                this.binding.dispose();
            }
            this.binding = this.ctx.bindList(this.observableList, EMFEditProperties.list((EditingDomain)this.domain, (EStructuralFeature)this.feature).observe((Object)eObject), this.updateStrategyTarget, this.updateStrategyModel);
        }
    }
}

