/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.ui.tools.pages;

import java.util.UUID;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.forms.DetailsPart;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.MasterDetailsBlock;
import org.eclipse.ui.forms.SectionPart;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public abstract class TablePage
extends FormPage {
    private ScrolledForm form;
    private FormToolkit toolkit;
    private Table objectsTable;
    private TableViewer tableViewer;
    protected Button addBtn;
    protected Button removeBtn;
    protected Button editBtn;
    private Object selectedItem;
    private String masterPartSectionName;

    public TablePage(FormEditor editor, String masterPartSectionName) {
        super(editor, UUID.randomUUID().toString(), "");
        this.masterPartSectionName = masterPartSectionName;
    }

    protected void createFormContent(IManagedForm managedForm) {
        OwnMasterDetailBlock block = new OwnMasterDetailBlock();
        block.createContent(managedForm);
    }

    private void setNewItemSelected(Object newItem) {
    }

    protected Object getSelecteditem() {
        return this.selectedItem;
    }

    protected abstract void initTableViewer();

    protected TableViewer getTableViewer() {
        return this.tableViewer;
    }

    protected void setViewerInput(Object input) {
        this.tableViewer.setInput(input);
    }

    protected void setContentProvider(IContentProvider contentProvider) {
        this.tableViewer.setContentProvider(contentProvider);
    }

    protected void setLabelProvider(ILabelProvider labelProvider) {
        this.tableViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
    }

    protected void refresh() {
        if (this.tableViewer != null && !this.tableViewer.getTable().isDisposed()) {
            this.tableViewer.refresh();
        }
    }

    protected abstract Object addItem();

    protected abstract void removeItem(Object var1);

    protected abstract void editItem(Object var1);

    protected abstract void onTableItemDoubleClick(Object var1);

    protected abstract void registerPages(DetailsPart var1);

    class OwnMasterDetailBlock
    extends MasterDetailsBlock {
        private IManagedForm managedForm;
        private SectionPart sectionPart;

        OwnMasterDetailBlock() {
        }

        public void createContent(IManagedForm managedForm, Composite parent) {
            super.createContent(managedForm, parent);
            this.sashForm.setOrientation(256);
        }

        protected void createMasterPart(IManagedForm managedForm, Composite parent) {
            TablePage.this.toolkit = managedForm.getToolkit();
            this.managedForm = managedForm;
            TablePage.this.form = managedForm.getForm();
            this.createHeaderSection();
            this.createTableSection(parent);
        }

        public void fireSelectionChanged(ISelection selection) {
            this.managedForm.fireSelectionChanged((IFormPart)this.sectionPart, selection);
        }

        protected void registerPages(DetailsPart detailsPart) {
            TablePage.this.registerPages(detailsPart);
        }

        protected void createToolBarActions(IManagedForm managedForm) {
        }

        private void createHeaderSection() {
            TablePage.this.form.setText("Purge");
            TablePage.this.toolkit.decorateFormHeading(TablePage.this.form.getForm());
        }

        private void createTableSection(Composite parent) {
            GridLayout gridLayout = new GridLayout();
            Composite comp = TablePage.this.toolkit.createComposite(parent, 0);
            comp.setLayout((Layout)gridLayout);
            Section tableSection = TablePage.this.toolkit.createSection(comp, 256);
            tableSection.setText(TablePage.this.masterPartSectionName);
            tableSection.setLayout((Layout)new GridLayout());
            tableSection.setLayoutData((Object)new GridData(4, 4, true, true));
            Composite client = TablePage.this.toolkit.createComposite((Composite)tableSection);
            client.setLayout((Layout)new GridLayout(2, false));
            client.setLayoutData((Object)new GridData(4, 4, true, true));
            tableSection.setClient((Control)client);
            Composite hostTableComp = TablePage.this.toolkit.createComposite(client);
            hostTableComp.setLayout((Layout)new GridLayout());
            hostTableComp.setLayoutData((Object)new GridData(4, 4, true, true));
            TablePage.this.tableViewer = new TableViewer(hostTableComp, 68096);
            TablePage.this.objectsTable = TablePage.this.tableViewer.getTable();
            TablePage.this.objectsTable.setLayoutData((Object)new GridData(4, 4, true, true));
            this.sectionPart = new SectionPart(tableSection);
            TablePage.this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    OwnMasterDetailBlock.this.managedForm.fireSelectionChanged((IFormPart)OwnMasterDetailBlock.this.sectionPart, event.getSelection());
                    IStructuredSelection selection = (IStructuredSelection)TablePage.this.tableViewer.getSelection();
                    TablePage.this.selectedItem = selection.getFirstElement();
                }
            });
            TablePage.this.tableViewer.addDoubleClickListener(new IDoubleClickListener(){

                public void doubleClick(DoubleClickEvent event) {
                    if (event.getSelection() instanceof IStructuredSelection) {
                        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                        TablePage.this.selectedItem = selection.getFirstElement();
                        TablePage.this.onTableItemDoubleClick(TablePage.this.selectedItem);
                    }
                }
            });
            TablePage.this.initTableViewer();
            Composite btnComp = TablePage.this.toolkit.createComposite(client);
            btnComp.setLayout((Layout)new GridLayout());
            btnComp.setLayoutData((Object)new GridData(4, 4, false, false));
            TablePage.this.addBtn = TablePage.this.toolkit.createButton(btnComp, "Add", 0);
            TablePage.this.addBtn.setLayoutData((Object)new GridData(4, 4, true, false));
            TablePage.this.addBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Object newItem = TablePage.this.addItem();
                    TablePage.this.setNewItemSelected(newItem);
                }
            });
            TablePage.this.removeBtn = TablePage.this.toolkit.createButton(btnComp, "Remove", 0);
            TablePage.this.removeBtn.setLayoutData((Object)new GridData(4, 4, true, false));
            TablePage.this.removeBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TablePage.this.removeItem(TablePage.this.selectedItem);
                }
            });
            TablePage.this.editBtn = TablePage.this.toolkit.createButton(btnComp, "Edit", 0);
            TablePage.this.editBtn.setLayoutData((Object)new GridData(4, 4, true, false));
            TablePage.this.editBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TablePage.this.editItem(TablePage.this.selectedItem);
                }
            });
        }
    }
}

