/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.ui.tools.table;

import com.stambia.ui.tools.table.ColumnInfo;
import com.stambia.ui.tools.table.StbTreeTable;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public abstract class ColumnChooserMenu {
    private ToolItem item;
    private ToolItem dropdown;
    private Menu menu;
    private StbTreeTable table;

    public ColumnChooserMenu(Composite parent, StbTreeTable table) {
        this.table = table;
        ToolBar toolBar = new ToolBar(parent, 256);
        this.item = new ToolItem(toolBar, 4);
        this.item.setText("Column");
        DropdownSelectionListener listener = new DropdownSelectionListener(this, this.item){};
        for (ColumnInfo column : table.getColumnsInfo()) {
            listener.add(column.label);
        }
        this.item.addSelectionListener((SelectionListener)listener);
        this.refreshMenu();
    }

    private void refreshMenu() {
        for (ColumnInfo column : this.table.getColumnsInfo()) {
            MenuItem[] menuItemArray = this.menu.getItems();
            int n = menuItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                MenuItem currentItem = menuItemArray[n2];
                if (currentItem.getText().equals(column.label)) {
                    if (column.isHide()) {
                        currentItem.setSelection(false);
                    } else {
                        currentItem.setSelection(true);
                    }
                }
                ++n2;
            }
        }
    }

    public abstract void handleRefresh();

    class DropdownSelectionListener
    extends SelectionAdapter {
        public DropdownSelectionListener(ToolItem _dropdown) {
            ColumnChooserMenu.this.dropdown = _dropdown;
            ColumnChooserMenu.this.menu = new Menu((Control)ColumnChooserMenu.this.dropdown.getParent().getShell());
            MenuItem menuItem = new MenuItem(ColumnChooserMenu.this.menu, 2);
            menuItem = new MenuItem(ColumnChooserMenu.this.menu, 0);
            menuItem.setText("Reset");
        }

        public void add(String item) {
            MenuItem menuItem = new MenuItem(ColumnChooserMenu.this.menu, 32);
            menuItem.setText(item);
            menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    MenuItem selected = (MenuItem)event.widget;
                    if (selected.getSelection()) {
                        ((ColumnChooserMenu)((DropdownSelectionListener)DropdownSelectionListener.this).ColumnChooserMenu.this).table.columns.get(selected.getText()).setHide(false);
                    } else {
                        ((ColumnChooserMenu)((DropdownSelectionListener)DropdownSelectionListener.this).ColumnChooserMenu.this).table.columns.get(selected.getText()).setHide(true);
                    }
                    ColumnChooserMenu.this.table.refreshColumns();
                    ColumnChooserMenu.this.handleRefresh();
                }
            });
        }

        public void widgetSelected(SelectionEvent event) {
            ToolItem item = (ToolItem)event.widget;
            Rectangle rect = item.getBounds();
            Point pt = item.getParent().toDisplay(new Point(rect.x, rect.y));
            ColumnChooserMenu.this.menu.setLocation(pt.x, pt.y + rect.height);
            ColumnChooserMenu.this.menu.setVisible(true);
        }
    }
}

