/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.ui.tools.table;

import com.stambia.ui.tools.table.ColumnInfo;
import com.stambia.ui.tools.table.GroupInfo;
import com.stambia.ui.tools.table.StbTableLabelProvider;
import com.stambia.ui.widget.StambiaWidget;
import com.stambia.ui.widget.StambiaWidgetUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;

public abstract class StbFilteredTreeTable
extends FilteredTree
implements StambiaWidget {
    private ISerializer serializer;
    private Menu headerMenu;
    private Menu treeItemMenu;
    private boolean headerMenuItemHasBeenSelected;
    private Listener addRemoveColumnListener;
    private boolean autoExpand = false;
    Map<String, ColumnInfo> columns = new HashMap<String, ColumnInfo>();
    Map<TreeColumn, ColumnInfo> visibleColumns = new HashMap<TreeColumn, ColumnInfo>();
    private boolean initMenu;
    private TreeViewer viewer;
    private Map<String, GroupInfo> toGroup = new LinkedHashMap<String, GroupInfo>();
    private Collection<WrappedContentProvider.Group> groups;
    SelectionListener sortListener;

    protected void checkSubclass() {
    }

    public void setSerializer(ISerializer serializer) {
        this.serializer = serializer;
    }

    public Collection<ColumnInfo> getColumnsInfo() {
        return this.columns.values();
    }

    public void setHideColumn(String id, boolean hide) {
        ColumnInfo col = this.columns.get(id);
        if (col != null) {
            col.hide = hide;
            this.savePreference();
        }
    }

    protected void updateToolbar(boolean visible) {
        super.updateToolbar(visible);
        if (this.autoExpand) {
            this.treeViewer.expandAll();
        }
    }

    public StbFilteredTreeTable(final Composite parent, int style, SelectionListener sortListener, PatternFilter patternFilter, boolean autoExpend) {
        super(parent, style, patternFilter, true);
        StambiaWidgetUtils.addDisposeListener(this);
        this.sortListener = sortListener;
        this.viewer = this.getViewer();
        this.autoExpand = autoExpend;
        this.viewer.setUseHashlookup(true);
        this.initMenu = true;
        this.headerMenu = new Menu((Decorations)parent.getShell(), 8);
        this.headerMenu.addMenuListener(new MenuListener(){

            public void menuShown(MenuEvent e) {
            }

            public void menuHidden(MenuEvent event) {
                if (StbFilteredTreeTable.this.headerMenuItemHasBeenSelected) {
                    StbFilteredTreeTable.this.headerMenu.setVisible(true);
                    StbFilteredTreeTable.this.headerMenuItemHasBeenSelected = false;
                }
            }
        });
        this.addRemoveColumnListener = new Listener(){

            public void handleEvent(Event event) {
                StbFilteredTreeTable.this.viewer.getTree().setMenu(null);
                Point pt = parent.getDisplay().map(null, (Control)StbFilteredTreeTable.this.viewer.getTree(), new Point(event.x, event.y));
                if (pt.y < StbFilteredTreeTable.this.viewer.getTree().getHeaderHeight()) {
                    StbFilteredTreeTable.this.refreshMenu();
                    StbFilteredTreeTable.this.headerMenu.setLocation(event.x, event.y);
                    if (StbFilteredTreeTable.this.treeItemMenu != null) {
                        StbFilteredTreeTable.this.treeItemMenu.setVisible(false);
                    }
                    StbFilteredTreeTable.this.headerMenu.setVisible(true);
                } else if (StbFilteredTreeTable.this.treeItemMenu != null) {
                    StbFilteredTreeTable.this.treeItemMenu.setLocation(event.x, event.y);
                    StbFilteredTreeTable.this.headerMenu.setVisible(false);
                    StbFilteredTreeTable.this.treeItemMenu.setVisible(true);
                }
            }
        };
        this.viewer.getTree().addListener(35, this.addRemoveColumnListener);
        this.initColumns();
    }

    public StbFilteredTreeTable(Composite parent, int style, SelectionListener sortListener, PatternFilter patternFilter) {
        this(parent, style, sortListener, patternFilter, false);
    }

    public MenuManager createContextMenu(IWorkbenchPartSite site) {
        if (this.viewer != null) {
            MenuManager menuManager = new MenuManager("#PopUp");
            this.treeItemMenu = menuManager.createContextMenu(this.viewer.getControl());
            this.viewer.getTree().setMenu(this.treeItemMenu);
            site.registerContextMenu(menuManager, (ISelectionProvider)this.viewer);
            return menuManager;
        }
        return null;
    }

    public int getColumnIndex(TreeColumn treeColumn) {
        int i = 0;
        while (i < this.getViewer().getTree().getColumnCount()) {
            if (this.getViewer().getTree().getColumn(i) == treeColumn) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int getColumnIndex(ColumnInfo col) {
        if (col.treeColumn != null) {
            return this.getColumnIndex(col.treeColumn);
        }
        return -1;
    }

    public ColumnInfo getColumnInfo(String id) {
        return this.columns.get(id);
    }

    public abstract void initColumns();

    private void reset() {
        this.columns.clear();
        this.initColumns();
    }

    public void add(ColumnInfo column) {
        column.position = this.columns.size();
        this.columns.put(column.getId(), column);
    }

    public ColumnInfo getColumnInfo(int index) {
        return this.getColumnInfo(this.getViewer().getTree().getColumn(index));
    }

    public ColumnInfo getColumnInfo(TreeColumn tc) {
        return this.visibleColumns.get(tc);
    }

    public void setGroups(List<GroupInfo> groups) {
        this.clearGroups();
        for (GroupInfo gi : groups) {
            this.toGroup.put(gi.columnId, gi);
        }
        this.refreshColumns();
    }

    public int getColumnIndex(String id) {
        ColumnInfo col = this.columns.get(id);
        if (col != null) {
            return this.getColumnIndex(col);
        }
        return -1;
    }

    private void clearGroups() {
        if (this.groups != null) {
            for (WrappedContentProvider.Group grp : this.groups) {
                grp.clear();
            }
        }
        this.toGroup.clear();
        for (ColumnInfo ci : this.getColumnsInfo()) {
            ci.isHideGroupColumn = false;
        }
    }

    public void setContentProvider(ITreeContentProvider tcp) {
        this.viewer.setContentProvider((IContentProvider)new WrappedContentProvider(tcp));
    }

    private void savePreference() {
        if (this.serializer != null) {
            this.serializer.saveColumnPreference(this.columns.values());
        }
    }

    public void loadTablePreference() {
        if (this.serializer != null) {
            String[] colPrefs;
            String[] stringArray = colPrefs = this.serializer.getColumnPreference();
            int n = colPrefs.length;
            int n2 = 0;
            while (n2 < n) {
                ColumnInfo col;
                String[] prefs;
                String pref = stringArray[n2];
                if (!pref.isEmpty() && (prefs = pref.split(";")).length == 4 && (col = this.getColumnInfo(prefs[0])) != null) {
                    col.setHide(Boolean.valueOf(prefs[1]));
                    col.setWidth(Integer.parseInt(prefs[2]));
                    col.setPosition(Integer.parseInt(prefs[3]));
                }
                ++n2;
            }
        }
    }

    private void synchronizeColumnInfoWithTreeColumn() {
        int k = 0;
        int[] orders = this.getViewer().getTree().getColumnOrder();
        while (this.getViewer().getTree().getColumnCount() > k) {
            TreeColumn tc = this.getViewer().getTree().getColumns()[k++];
            int i = this.getColumnIndex(tc);
            ColumnInfo col = this.visibleColumns.get(tc);
            col.width = tc.getWidth();
            col.setPosition(orders[i]);
        }
    }

    public void refreshColumns() {
        this.synchronizeColumnInfoWithTreeColumn();
        this.setRedraw(false);
        while (this.getViewer().getTree().getColumnCount() > 0) {
            TreeColumn tc = this.getViewer().getTree().getColumns()[0];
            if (this.sortListener != null) {
                tc.removeSelectionListener(this.sortListener);
            }
            tc.dispose();
        }
        this.visibleColumns.clear();
        ArrayList<ColumnInfo> cols = new ArrayList<ColumnInfo>(this.columns.values());
        Collections.sort(cols);
        for (final ColumnInfo col : cols) {
            GroupInfo gi = this.toGroup.get(col.getId());
            if (!(col.hide || gi != null && gi.hide)) {
                TreeColumn tableColumn = new TreeColumn(this.getViewer().getTree(), 0);
                TreeViewerColumn columnViewer = new TreeViewerColumn(this.viewer, tableColumn);
                columnViewer.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

                    public String getToolTipText(Object element) {
                        return col.getToolTipText(element);
                    }

                    public Image getImage(Object element) {
                        if (StbFilteredTreeTable.this.viewer.getLabelProvider() instanceof StbTableLabelProvider) {
                            return ((StbTableLabelProvider)StbFilteredTreeTable.this.viewer.getLabelProvider()).getColumnImage(element, StbFilteredTreeTable.this.getColumnIndex(col));
                        }
                        return null;
                    }

                    public String getText(Object element) {
                        if (StbFilteredTreeTable.this.viewer.getLabelProvider() instanceof StbTableLabelProvider) {
                            return ((StbTableLabelProvider)StbFilteredTreeTable.this.viewer.getLabelProvider()).getColumnText(element, StbFilteredTreeTable.this.getColumnIndex(col));
                        }
                        return null;
                    }
                });
                tableColumn.setWidth(col.width);
                tableColumn.setText(col.label);
                tableColumn.setMoveable(true);
                if (this.sortListener != null) {
                    tableColumn.addSelectionListener(this.sortListener);
                }
                this.visibleColumns.put(tableColumn, col);
                col.treeColumn = tableColumn;
                continue;
            }
            col.treeColumn = null;
        }
        this.setRedraw(true);
        this.initMenu();
    }

    private void refreshMenu() {
        for (ColumnInfo column : this.getColumnsInfo()) {
            MenuItem[] menuItemArray = this.headerMenu.getItems();
            int n = menuItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                MenuItem currentItem = menuItemArray[n2];
                if (currentItem.getText().equals(column.label)) {
                    if (column.isHide()) {
                        currentItem.setSelection(false);
                    } else {
                        currentItem.setSelection(true);
                    }
                }
                ++n2;
            }
        }
    }

    public void initMenu() {
        if (this.initMenu) {
            ArrayList<ColumnInfo> sortedcolumns = new ArrayList<ColumnInfo>();
            sortedcolumns.addAll(this.getColumnsInfo());
            Collections.sort(sortedcolumns);
            for (ColumnInfo column : sortedcolumns) {
                MenuItem menuItem = new MenuItem(this.headerMenu, 32);
                menuItem.setText(column.label);
                menuItem.setData((Object)column.getId());
                menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent event) {
                        StbFilteredTreeTable.this.headerMenuItemHasBeenSelected = true;
                        MenuItem selected = (MenuItem)event.widget;
                        if (selected.getSelection()) {
                            StbFilteredTreeTable.this.columns.get(selected.getData()).setHide(false);
                        } else {
                            StbFilteredTreeTable.this.columns.get(selected.getData()).setHide(true);
                        }
                        StbFilteredTreeTable.this.refreshColumns();
                        if (StbFilteredTreeTable.this.viewer != null) {
                            StbFilteredTreeTable.this.viewer.refresh();
                        }
                    }
                });
            }
            MenuItem menuItem = new MenuItem(this.headerMenu, 2);
            menuItem = new MenuItem(this.headerMenu, 0);
            menuItem.setText("Reset");
            menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    StbFilteredTreeTable.this.reset();
                    StbFilteredTreeTable.this.refreshColumns();
                    if (StbFilteredTreeTable.this.viewer != null) {
                        StbFilteredTreeTable.this.viewer.refresh();
                    }
                }
            });
            this.initMenu = false;
        }
    }

    @Override
    public void _dispose() {
        this.synchronizeColumnInfoWithTreeColumn();
        this.savePreference();
        this.headerMenu.dispose();
        this.removeListener(35, this.addRemoveColumnListener);
        this.addRemoveColumnListener = null;
        this.clearGroups();
        this.viewer = null;
    }

    public void setCustomEnable(boolean enable) {
        Color color = enable ? Display.getDefault().getSystemColor(2) : Display.getDefault().getSystemColor(33);
        this.treeViewer.getTree().setForeground(color);
    }

    public static interface ISerializer {
        public void saveColumnPreference(Collection<ColumnInfo> var1);

        public String[] getColumnPreference();
    }

    class WrappedContentProvider
    implements ITreeContentProvider {
        ITreeContentProvider wrapped;
        List<Object> roots = new ArrayList<Object>();

        private WrappedContentProvider(ITreeContentProvider wrapped) {
            this.wrapped = wrapped;
        }

        public void dispose() {
            this.wrapped.dispose();
            this.wrapped = null;
            this.roots.clear();
            this.roots = null;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.wrapped.inputChanged(viewer, oldInput, newInput);
        }

        private Collection<Group> buildGroup(List<Object> existing, Object[] children, List<GroupInfo> allGroup) {
            GroupInfo gi = allGroup.get(0);
            allGroup.remove(0);
            HashMap<String, Group> groups = new HashMap<String, Group>();
            ArrayList<Object> existOk = new ArrayList<Object>();
            Object[] objectArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                ColumnInfo ci = StbFilteredTreeTable.this.columns.get(gi.columnId);
                if (ci != null) {
                    String t;
                    String string = t = ci.getGroupText(o) != null ? ci.getGroupText(o) : ci.getText(o);
                    if (t == null) {
                        t = "unknown";
                    }
                    Group grp = (Group)groups.get(t);
                    ci.setIsHideGroupColumn(gi.hide);
                    if (grp == null) {
                        if (existing != null) {
                            for (Object o2 : existing) {
                                if (!(o2 instanceof Group)) continue;
                                existOk.add(o2);
                                Group exist = (Group)o2;
                                if (!exist.type.equals(gi.columnId) || exist.label == null || !exist.label.equals(t)) continue;
                                grp = exist;
                                if (grp.hasChildrenGroup) {
                                    grp.previous = new ArrayList<Object>(grp.children);
                                }
                                grp.children.clear();
                            }
                        }
                        if (grp == null) {
                            grp = new Group();
                            grp.label = t;
                            grp.type = gi.columnId;
                            grp.image = ci.getGroupImage(o);
                        }
                        groups.put(t, grp);
                    }
                    grp.children.add(o);
                }
                ++n2;
            }
            if (existing != null) {
                for (Object o2 : existing) {
                    if (existOk.contains(o2) || !(o2 instanceof Group)) continue;
                    ((Group)o2).clear();
                }
            }
            for (Group newGroup : groups.values()) {
                if (allGroup.size() <= 0) continue;
                Collection<Group> newChildren = this.buildGroup(newGroup.previous, newGroup.children.toArray(), new ArrayList<GroupInfo>(allGroup));
                if (newChildren.size() > 0) {
                    newGroup.hasChildrenGroup = true;
                    newGroup.children = new ArrayList<Group>(newChildren);
                    continue;
                }
                newGroup.hasChildrenGroup = false;
            }
            return groups.values();
        }

        public Object[] getElements(Object inputElement) {
            Object[] children = this.wrapped.getElements(inputElement);
            if (StbFilteredTreeTable.this.toGroup.size() > 0) {
                StbFilteredTreeTable.this.groups = this.buildGroup(this.roots, children, new ArrayList<GroupInfo>(StbFilteredTreeTable.this.toGroup.values()));
                this.roots = new ArrayList<Object>(StbFilteredTreeTable.this.groups);
                return this.roots.toArray();
            }
            return children;
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof Group) {
                return ((Group)parentElement).children.toArray();
            }
            return this.wrapped.getChildren(parentElement);
        }

        public Object getParent(Object element) {
            return this.wrapped.getParent(element);
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }

        class Group {
            List<Object> children = new ArrayList<Object>();
            List<Object> previous;
            boolean hasChildrenGroup = false;
            String label;
            Image image;
            String type;

            Group() {
            }

            public int getChildren() {
                int childs = this.children.size();
                for (Object o : this.children) {
                    if (!(o instanceof Group)) continue;
                    childs += ((Group)o).getChildren() - 1;
                }
                return childs;
            }

            public void clear() {
                for (Object o : this.children) {
                    if (!(o instanceof Group)) continue;
                    ((Group)o).clear();
                }
                this.children.clear();
            }
        }
    }
}

