/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.mongodb.test;

import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Filters;
import java.util.Arrays;
import org.bson.Document;
import org.bson.conversions.Bson;

public class AggregationOperation {
    private static String database = "test";
    private static String mongoDBUrl = "mongodb://127.0.0.1:27017";
    private static String collection = "restaurants";
    private static MongoClientURI uri;
    private static MongoClient mongoClient;
    private static MongoDatabase mongoDatabase;

    public static void main(String[] args) throws Exception {
        uri = new MongoClientURI(mongoDBUrl);
        mongoClient = new MongoClient(uri);
        mongoDatabase = mongoClient.getDatabase(database);
        AggregationOperation.aggregation();
        AggregationOperation.count();
        mongoClient.close();
    }

    private static void aggregation() {
        for (Document doc : mongoDatabase.getCollection(collection).aggregate(Arrays.asList(Document.parse((String)"{$group:{_id:\"$borough\",count:{$sum:1}}}")))) {
            System.out.println("grp by borough, count(sum(1)): " + doc.toJson());
        }
        for (Document doc : mongoDatabase.getCollection(collection).aggregate(Arrays.asList(Document.parse((String)"{$group:{_id:\"$borough,$cuisine\",count:{$sum:1}}}")))) {
            System.out.println("grp by $borough,$cuisine  count(sum(1)): " + doc.toJson());
        }
        for (Document doc : mongoDatabase.getCollection(collection).aggregate(Arrays.asList(Document.parse((String)"{$group:{_id:\"$borough\",count:{$sum:\"$grades.score\"}}}")))) {
            System.out.println("count:{$sum:$grades.$score}: " + doc.toJson());
        }
    }

    private static void count() {
        System.out.println("count of objects: " + mongoDatabase.getCollection(collection).countDocuments(Filters.or((Bson[])new Bson[]{Filters.eq((String)"cuisine", (Object)"Bakery"), Filters.eq((String)"borough", (Object)"Bronx"), Filters.eq((String)"address.building", (Object)107)})));
    }
}

