/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.mongodb.test;

import com.mongodb.Block;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Filters;
import java.util.List;
import java.util.Vector;
import org.bson.Document;
import org.bson.conversions.Bson;

public class FindOperations {
    private static String database = "test";
    private static String mongoDBUrl = "mongodb://127.0.0.1:27017";
    private static String collection = "findTest";
    private static MongoClientURI uri;
    private static MongoClient mongoClient;
    private static MongoDatabase mongoDatabase;
    private static List<Document> allDocumentsToInsert;

    static {
        allDocumentsToInsert = new Vector<Document>();
    }

    public static void main(String[] args) throws Exception {
        uri = new MongoClientURI(mongoDBUrl);
        mongoClient = new MongoClient(uri);
        mongoDatabase = mongoClient.getDatabase(database);
        FindOperations.loadJsonInList();
        FindOperations.delete();
        FindOperations.count();
        FindOperations.insertMany();
        FindOperations.findUsingWholeDcument();
        FindOperations.findUsingNestedField();
        FindOperations.findUsingStaticFunction();
        FindOperations.findUsingMAtchingCriteria();
        mongoClient.close();
    }

    private static void findUsingWholeDcument() {
        System.out.println("Start find");
        Document doc = Document.parse((String)"{ \"_id\":1, \"web-app\": {\"servlet\": [{\"servlet-name\": \"cofaxCDS\",\"servlet-class\": \"org.cofax.cds.CDSServlet\",\"init-param\": {\"configGlossary:installationAt\": \"Philadelphia, PA\",\"configGlossary:adminEmail\": \"ksm@pobox.com\",\"configGlossary:poweredBy\": \"Cofax\",\"configGlossary:poweredByIcon\": \"/images/cofax.gif\",\"configGlossary:staticPath\": \"/content/static\",\"templateProcessorClass\": \"org.cofax.WysiwygTemplate\",\"templateLoaderClass\": \"org.cofax.FilesTemplateLoader\",\"templatePath\": \"templates\",\"templateOverridePath\": \"\",\"defaultListTemplate\": \"listTemplate.htm\",\"defaultFileTemplate\": \"articleTemplate.htm\",\"useJSP\": false,\"jspListTemplate\": \"listTemplate.jsp\",\"jspFileTemplate\": \"articleTemplate.jsp\",\"cachePackageTagsTrack\": 1,\"cachePackageTagsStore\": 200,\"cachePackageTagsRefresh\": 60,\"cacheTemplatesTrack\": 100,\"cacheTemplatesStore\": 50,\"cacheTemplatesRefresh\": 15,\"cachePagesTrack\": 200,\"cachePagesStore\": 100,\"cachePagesRefresh\": 10,\"cachePagesDirtyRead\": 10,\"searchEngineListTemplate\": \"forSearchEnginesList.htm\",\"searchEngineFileTemplate\": \"forSearchEngines.htm\",\"searchEngineRobotsDb\": \"WEB-INF/robots.db\",\"useDataStore\": true,\"dataStoreClass\": \"org.cofax.SqlDataStore\",\"redirectionClass\": \"org.cofax.SqlRedirection\",\"dataStoreName\": \"cofax\",\"dataStoreDriver\": \"com.microsoft.jdbc.sqlserver.SQLServerDriver\",\"dataStoreUrl\": \"jdbc:microsoft:sqlserver://LOCALHOST:1433;DatabaseName=goon\",\"dataStoreUser\": \"sa\",\"dataStorePassword\": \"dataStoreTestQuery\",\"dataStoreTestQuery\": \"SET NOCOUNT ON;select test='test';\",\"dataStoreLogFile\": \"/usr/local/tomcat/logs/datastore.log\",\"dataStoreInitConns\": 10,\"dataStoreMaxConns\": 100,\"dataStoreConnUsageLimit\": 100,\"dataStoreLogLevel\": \"debug\",\"maxUrlLength\": 500}},{\"servlet-name\": \"cofaxEmail\",\"servlet-class\": \"org.cofax.cds.EmailServlet\",\"init-param\": {\"mailHost\": \"mail1\",\"mailHostOverride\": \"mail2\"}},{\"servlet-name\": \"cofaxAdmin\",\"servlet-class\": \"org.cofax.cds.AdminServlet\"},{\"servlet-name\": \"fileServlet\",\"servlet-class\": \"org.cofax.cds.FileServlet\"},{\"servlet-name\": \"cofaxTools\",\"servlet-class\": \"org.cofax.cms.CofaxToolsServlet\",\"init-param\": {\"templatePath\": \"toolstemplates/\",\"log\": 1,\"logLocation\": \"/usr/local/tomcat/logs/CofaxTools.log\",\"logMaxSize\": \"\",\"dataLog\": 1,\"dataLogLocation\": \"/usr/local/tomcat/logs/dataLog.log\",\"dataLogMaxSize\": \"\",\"removePageCache\": \"/content/admin/remove?cache=pages&id=\",\"removeTemplateCache\": \"/content/admin/remove?cache=templates&id=\",\"fileTransferFolder\": \"/usr/local/tomcat/webapps/content/fileTransferFolder\",\"lookInContext\": 1,\"adminGroupID\": 4,\"betaServer\": true}}],\"servlet-mapping\": {\"cofaxCDS\": \"/\",\"cofaxEmail\": \"/cofaxutil/aemail/*\",\"cofaxAdmin\": \"/admin/*\",\"fileServlet\": \"/static/*\",\"cofaxTools\": \"/tools/*\"},\"taglib\": {\"taglib-uri\": \"cofax.tld\",\"taglib-location\": \"/WEB-INF/tlds/cofax.tld\"}}}");
        MongoCollection collectionObject = mongoDatabase.getCollection(collection);
        for (Document docFound : collectionObject.find((Bson)doc)) {
            System.out.println("found: " + docFound.toJson());
        }
        System.out.println("found count: " + collectionObject.countDocuments((Bson)doc));
    }

    private static void findUsingNestedField() {
        System.out.println("Start find nested field");
        Document doc = Document.parse((String)"{_id:1,\"web-app.servlet.init-param.configGlossary:installationAt\": \"Philadelphia, PA\"}");
        MongoCollection collectionObject = mongoDatabase.getCollection(collection);
        collectionObject.find((Bson)doc).forEach(document -> {
            Block<Document> block = new Block<Document>(){

                public void apply(Document document) {
                    System.out.println(document);
                }
            };
        });
        System.out.println("found count: " + collectionObject.countDocuments((Bson)doc));
    }

    private static void findUsingStaticFunction() {
        System.out.println("Start find static functions");
        MongoCollection collectionObject = mongoDatabase.getCollection(collection);
        for (Document docFound : collectionObject.find(Filters.and((Bson[])new Bson[]{Filters.eq((String)"_id", (Object)3), Filters.gte((String)"web-app.servlet.init-param.cachePackageTagsTrack", (Object)3), Filters.lte((String)"web-app.servlet.init-param.cachePackageTagsRefresh", (Object)60), Filters.eq((String)"web-app.servlet.init-param.searchEngineListTemplate", (Object)"forSearchEnginesList.htm")}))) {
            System.out.println("found: " + docFound.toJson());
        }
        System.out.println("found count: " + collectionObject.countDocuments(Filters.and((Bson[])new Bson[]{Filters.eq((String)"_id", (Object)3), Filters.gte((String)"web-app.servlet.init-param.cachePackageTagsTrack", (Object)3), Filters.lte((String)"web-app.servlet.init-param.cachePackageTagsRefresh", (Object)60), Filters.eq((String)"web-app.servlet.init-param.searchEngineListTemplate", (Object)"forSearchEnginesList.htm")})));
    }

    private static void findUsingMAtchingCriteria() {
        System.out.println("Start find machting criteria");
        MongoCollection collectionObject = mongoDatabase.getCollection(collection);
        for (Document docFound : collectionObject.find((Bson)Document.parse((String)"{ _id:{$eq:3},\"web-app.servlet.init-param.cachePackageTagsTrack\":{$gte:3},\"web-app.servlet.init-param.cachePackageTagsRefresh\":{$lte:60},\"web-app.servlet.init-param.searchEngineListTemplate\":{$eq:\"forSearchEnginesList.htm\"}}"))) {
            System.out.println("found: " + docFound.toJson());
        }
        System.out.println("found count: " + collectionObject.countDocuments((Bson)Document.parse((String)"{ _id:{$eq:3},\"web-app.servlet.init-param.cachePackageTagsTrack\":{$gte:3},\"web-app.servlet.init-param.cachePackageTagsRefresh\":{$lte:60},\"web-app.servlet.init-param.searchEngineListTemplate\":{$eq:\"forSearchEnginesList.htm\"}}")));
    }

    private static void delete() {
        System.out.println("Start delete");
        Document filter = Document.parse((String)"{}");
        MongoCollection collectionObject = mongoDatabase.getCollection(collection);
        collectionObject.deleteMany((Bson)filter);
        for (Document doc : collectionObject.find()) {
            System.out.println("dopo remove: " + doc.toJson());
        }
        System.out.println("Stop delete");
    }

    private static void count() {
        MongoCollection collectionObject = mongoDatabase.getCollection(collection);
        System.out.println("number of objects: " + collectionObject.countDocuments());
    }

    private static void loadJsonInList() {
        System.out.println("Start loading into list");
        allDocumentsToInsert.clear();
        int i = 1;
        while (i < 100000) {
            allDocumentsToInsert.add(Document.parse((String)("{ \"_id\":" + i + ", \"web-app\": {" + "\"servlet\": [" + "{" + "\"servlet-name\": \"cofaxCDS\"," + "\"servlet-class\": \"org.cofax.cds.CDSServlet\"," + "\"init-param\": {" + "\"configGlossary:installationAt\": \"Philadelphia, PA\"," + "\"configGlossary:adminEmail\": \"ksm@pobox.com\"," + "\"configGlossary:poweredBy\": \"Cofax\"," + "\"configGlossary:poweredByIcon\": \"/images/cofax.gif\"," + "\"configGlossary:staticPath\": \"/content/static\"," + "\"templateProcessorClass\": \"org.cofax.WysiwygTemplate\"," + "\"templateLoaderClass\": \"org.cofax.FilesTemplateLoader\"," + "\"templatePath\": \"templates\"," + "\"templateOverridePath\": \"\"," + "\"defaultListTemplate\": \"listTemplate.htm\"," + "\"defaultFileTemplate\": \"articleTemplate.htm\"," + "\"useJSP\": false," + "\"jspListTemplate\": \"listTemplate.jsp\"," + "\"jspFileTemplate\": \"articleTemplate.jsp\"," + "\"cachePackageTagsTrack\": " + i + "," + "\"cachePackageTagsStore\": 200," + "\"cachePackageTagsRefresh\": 60," + "\"cacheTemplatesTrack\": 100," + "\"cacheTemplatesStore\": 50," + "\"cacheTemplatesRefresh\": 15," + "\"cachePagesTrack\": 200," + "\"cachePagesStore\": 100," + "\"cachePagesRefresh\": 10," + "\"cachePagesDirtyRead\": 10," + "\"searchEngineListTemplate\": \"forSearchEnginesList.htm\"," + "\"searchEngineFileTemplate\": \"forSearchEngines.htm\"," + "\"searchEngineRobotsDb\": \"WEB-INF/robots.db\"," + "\"useDataStore\": true," + "\"dataStoreClass\": \"org.cofax.SqlDataStore\"," + "\"redirectionClass\": \"org.cofax.SqlRedirection\"," + "\"dataStoreName\": \"cofax\"," + "\"dataStoreDriver\": \"com.microsoft.jdbc.sqlserver.SQLServerDriver\"," + "\"dataStoreUrl\": \"jdbc:microsoft:sqlserver://LOCALHOST:1433;DatabaseName=goon\"," + "\"dataStoreUser\": \"sa\"," + "\"dataStorePassword\": \"dataStoreTestQuery\"," + "\"dataStoreTestQuery\": \"SET NOCOUNT ON;select test='test';\"," + "\"dataStoreLogFile\": \"/usr/local/tomcat/logs/datastore.log\"," + "\"dataStoreInitConns\": 10," + "\"dataStoreMaxConns\": 100," + "\"dataStoreConnUsageLimit\": 100," + "\"dataStoreLogLevel\": \"debug\"," + "\"maxUrlLength\": 500}}," + "{" + "\"servlet-name\": \"cofaxEmail\"," + "\"servlet-class\": \"org.cofax.cds.EmailServlet\"," + "\"init-param\": {" + "\"mailHost\": \"mail1\"," + "\"mailHostOverride\": \"mail2\"}}," + "{" + "\"servlet-name\": \"cofaxAdmin\"," + "\"servlet-class\": \"org.cofax.cds.AdminServlet\"}," + "{" + "\"servlet-name\": \"fileServlet\"," + "\"servlet-class\": \"org.cofax.cds.FileServlet\"}," + "{" + "\"servlet-name\": \"cofaxTools\"," + "\"servlet-class\": \"org.cofax.cms.CofaxToolsServlet\"," + "\"init-param\": {" + "\"templatePath\": \"toolstemplates/\"," + "\"log\": 1," + "\"logLocation\": \"/usr/local/tomcat/logs/CofaxTools.log\"," + "\"logMaxSize\": \"\"," + "\"dataLog\": 1," + "\"dataLogLocation\": \"/usr/local/tomcat/logs/dataLog.log\"," + "\"dataLogMaxSize\": \"\"," + "\"removePageCache\": \"/content/admin/remove?cache=pages&id=\"," + "\"removeTemplateCache\": \"/content/admin/remove?cache=templates&id=\"," + "\"fileTransferFolder\": \"/usr/local/tomcat/webapps/content/fileTransferFolder\"," + "\"lookInContext\": 1," + "\"adminGroupID\": 4," + "\"betaServer\": true}}]," + "\"servlet-mapping\": {" + "\"cofaxCDS\": \"/\"," + "\"cofaxEmail\": \"/cofaxutil/aemail/*\"," + "\"cofaxAdmin\": \"/admin/*\"," + "\"fileServlet\": \"/static/*\"," + "\"cofaxTools\": \"/tools/*\"}," + "\"taglib\": {" + "\"taglib-uri\": \"cofax.tld\"," + "\"taglib-location\": \"/WEB-INF/tlds/cofax.tld\"}}}")));
            ++i;
        }
        System.out.println("Finished loading into list");
    }

    private static void insertMany() {
        System.out.println("Start insert many approach");
        long l = System.currentTimeMillis();
        MongoCollection collectionObject = mongoDatabase.getCollection(collection);
        collectionObject.insertMany(allDocumentsToInsert);
        long duration = (System.currentTimeMillis() - l) / 1000L;
        System.out.println(String.valueOf(duration) + " sec");
    }
}

