/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.mongodb.test;

import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.MongoIterable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.BSONTimestamp;
import org.bson.types.Binary;
import org.bson.types.Code;
import org.bson.types.CodeWScope;
import org.bson.types.CodeWithScope;
import org.bson.types.MaxKey;
import org.bson.types.MinKey;
import org.bson.types.ObjectId;
import org.bson.types.Symbol;

public class GetMetadata {
    private static MongoClientURI uri;
    private static MongoClient mongoClient;
    private static MongoDatabase mongoDatabase;

    private static void listAllMetadata() {
        MongoIterable databases = mongoClient.listDatabaseNames();
        for (String databaseName : databases) {
            MongoDatabase mongoDatabase = mongoClient.getDatabase(databaseName);
            for (String collectionName : mongoDatabase.listCollectionNames()) {
                MongoCollection collection = mongoDatabase.getCollection(collectionName);
                for (Document doc : collection.find((Bson)Document.parse((String)"{_id:1}"))) {
                    System.out.print("database name: " + databaseName + " collection name: " + collectionName + " indexes: ");
                    for (Document index : collection.listIndexes()) {
                        GetMetadata.getIndexKeys(index);
                    }
                    System.out.println("");
                    GetMetadata.getFieldNameAndType(doc);
                    System.out.println("");
                    System.out.println("");
                }
            }
        }
    }

    private static void getIndexKeys(Document doc) {
        for (String key : doc.keySet()) {
            if (!key.equals("key")) continue;
            GetMetadata.getKeysElements((Document)doc.get((Object)key));
        }
    }

    private static void getKeysElements(Document doc) {
        for (String key : doc.keySet()) {
            Object val = doc.get((Object)key);
            if (val instanceof Document) {
                GetMetadata.getIndexKeys((Document)val);
                continue;
            }
            System.out.print("," + key);
        }
    }

    private static void getFieldNameAndType(Document doc) {
        for (String key : doc.keySet()) {
            Object val = doc.get((Object)key);
            GetMetadata.getDatatype(val);
            System.out.print(" \"" + key + "\"" + ":" + val + ", ");
        }
    }

    private static void getDatatype(Object val) {
        if (val instanceof Document) {
            System.out.print(" Document ");
            GetMetadata.getFieldNameAndType((Document)val);
        } else if (val instanceof String) {
            System.out.print("string");
        } else if (val instanceof Date) {
            System.out.print("date");
        } else if (val instanceof Double) {
            System.out.print("Double");
        } else if (val instanceof ArrayList) {
            System.out.print("Array");
            for (Object el : (ArrayList)val) {
                if (el instanceof Document) {
                    GetMetadata.getFieldNameAndType((Document)el);
                    continue;
                }
                GetMetadata.getDatatype(el);
            }
        } else if (val instanceof Binary) {
            System.out.print("Binary");
        } else if (val instanceof BSONTimestamp) {
            System.out.print("BSONTimestamp");
        } else if (val instanceof MaxKey) {
            System.out.print("MaxKey");
        } else if (val instanceof MinKey) {
            System.out.print("MinKey");
        } else if (val instanceof Code) {
            System.out.print("Code");
        } else if (val instanceof CodeWithScope) {
            System.out.print("CodeWithScope");
        } else if (val instanceof CodeWScope) {
            System.out.print("CodeWScope");
        } else if (val instanceof ObjectId) {
            System.out.print("ObjectId");
        } else if (val instanceof Symbol) {
            System.out.print("Symbol");
        } else if (val instanceof Boolean) {
            System.out.print("Boolean");
        } else if (val instanceof Integer) {
            System.out.print("Integer");
        } else if (val instanceof Long) {
            System.out.print("Long");
        }
    }

    private static void createDcument(MongoClient mongoClient) throws ParseException {
        mongoDatabase = mongoClient.getDatabase("test");
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.ENGLISH);
        MongoCollection collection = mongoDatabase.getCollection("restaurants");
        collection.deleteOne((Bson)Document.parse((String)"{_id:1}"));
        collection.insertOne((Object)new Document("address", (Object)new Document().append("street", (Object)"2 Avenue").append("zipcode", (Object)"10075").append("building", (Object)"1480").append("address", (Object)new Document().append("address", (Object)"addr1")).append("coord", Arrays.asList(-73.9557413, 40.7720266))).append("_id", (Object)1).append("borough", (Object)"Manhattan").append("cuisine", (Object)"Italian").append("grades", Arrays.asList(new Document().append("date", (Object)format.parse("2014-10-01T00:00:00Z")).append("grade", (Object)"A").append("score", (Object)11), new Document().append("date", (Object)format.parse("2014-01-16T00:00:00Z")).append("grade", (Object)"B").append("score", (Object)17))).append("name", (Object)"Vella").append("restaurant_id", (Object)"41704620").append("date", (Object)new Date()).append("BSONTimestamp", (Object)new BSONTimestamp()).append("MaxKey", (Object)new MaxKey()).append("MinKey", (Object)new MinKey()).append("Code", (Object)new Code("var=\"Hello World\"")).append("ObjectId", (Object)new ObjectId()).append("Symbol", (Object)new Symbol("")).append("date", (Object)new Boolean(true)));
        collection.createIndex((Bson)new Document("name", (Object)1).append("restaurant_id", (Object)2));
    }
}

