/*
 * Decompiled with CFR 0.152.
 */
package com.indy.cross.md;

import com.indy.cross.ContainerLevel;
import com.indy.cross.CrossFactory;
import com.indy.cross.CrossItem;
import com.indy.cross.CrossObjectType;
import com.semarchy.xdi.designer.core.services.cache.CacheHelper;
import com.stambia.md.Configuration;
import com.stambia.md.DocumentRoot;
import com.stambia.md.MdLink;
import com.stambia.md.MdNode;
import java.util.Collection;
import java.util.HashMap;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;

public class LineageHelper {
    private HashMap<String, CrossItem> lineageByID = new HashMap();

    private CrossItem createLineageObject(EObject mdRef) {
        if (mdRef != null) {
            String dsRefFileID = CacheHelper.extractFileID((EObject)mdRef);
            String dsRefEltID = CacheHelper.extractEltID((EObject)mdRef);
            String dsRefID = String.valueOf(dsRefEltID) + "/" + dsRefFileID;
            CrossItem res = this.lineageByID.get(dsRefID);
            if (res == null) {
                res = CrossFactory.eINSTANCE.createCrossItem(dsRefFileID, dsRefEltID);
                res.setType(CrossObjectType.METADATA);
                this.lineageByID.put(dsRefID, res);
                if (mdRef instanceof MdNode && !mdRef.eIsProxy()) {
                    String name = ((MdNode)mdRef).getName();
                    if (name != null) {
                        res.getProperty().put((Object)"name", (Object)name);
                    }
                    try {
                        res.getProperty().put((Object)"level", (Object)((MdNode)mdRef).getLevel().getCode());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    res.getProperty().put((Object)"fullPath", (Object)((MdNode)mdRef).getFullPath(false));
                    CrossItem lastContainer = res;
                    int i = 0;
                    while (i < ContainerLevel.values().length) {
                        try {
                            Configuration c = ((MdNode)mdRef).evaluateXpathExpressionMdNode("INTERNAL_MD_CONTAINER_NODE_" + ContainerLevel.values()[i].name());
                            if (c instanceof MdNode) {
                                CrossItem container = this.createLineageObject((EObject)c);
                                lastContainer.setContainer(container);
                                lastContainer = container;
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        ++i;
                    }
                    try {
                        res.getProperty().put((Object)"productCode", (Object)((MdNode)mdRef).evaluateXpathExpressionCached("INTERN_PRODUCT_CODE_GUI", null));
                    }
                    catch (Exception exception) {}
                } else {
                    String name = CacheHelper.extractEltName((String)((InternalEObject)mdRef).eProxyURI().fragment());
                    if (name != null) {
                        res.getProperty().put((Object)"name", (Object)name);
                    }
                }
            }
            return res;
        }
        return null;
    }

    public Collection<CrossItem> extractLineage(MdNode rootNode) {
        this.extractMdLinks(rootNode);
        return this.lineageByID.values();
    }

    private void extractMdLinks(MdNode node) {
        for (MdLink mdl : node.getMetaDataLink()) {
            EObject obj = mdl.getTarget();
            if (!(obj instanceof MdNode)) continue;
            CrossItem mdlItem = this.createLineageObject(mdl, (MdNode)obj);
            CrossItem item = this.createLineageObject(obj);
            if (item == null) continue;
            item.getTarget().add((Object)mdlItem);
        }
        for (MdNode n : node.getNode()) {
            this.extractMdLinks(n);
        }
    }

    private CrossItem createLineageObject(MdLink mdl, MdNode mdRef) {
        String mdlEltID = CacheHelper.extractEltID((EObject)mdl.eContainer());
        String mdlFileID = null;
        mdlFileID = CacheHelper.extractEltID((EObject)((DocumentRoot)mdl.eResource().getContents().get(0)).getNode());
        CrossItem res = CrossFactory.eINSTANCE.createCrossItem(mdlFileID, mdlEltID);
        this.lineageByID.put(String.valueOf(mdlFileID) + "/" + mdlEltID, res);
        res.setType(CrossObjectType.METADATALINK);
        try {
            res.getProperty().put((Object)"name", (Object)mdl.getName().toString());
        }
        catch (NullPointerException ex) {
            res.getProperty().put((Object)"name", (Object)"?");
        }
        try {
            res.getProperty().put((Object)"level", (Object)mdRef.getLevel().getCode());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return res;
    }
}

