<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:proc="http://www.example.org/proc" xmlns:deliv="http://www.stambia.com/deliv" xmlns:common="http://exslt.org/common" xmlns:rdbms="http://www.example.org/rdbms" xmlns:fn="http://www.w3.org/2005/02/xpath-functions" xmlns:UUID="java.util.UUID">
	<xsl:preserve-space elements="*"/>
	<xsl:param name="mode">normal</xsl:param>
	<xsl:output method="text" encoding="UTF-8"/>
	<xsl:template match="/">
		<xsl:apply-templates select="deliv:delivery/connection">
			<xsl:sort select="@name"/>
		</xsl:apply-templates>
		<xsl:if test="deliv:delivery/parameter">##########GLOBAL PARAMETERS##########<xsl:apply-templates select="deliv:delivery/parameter">
				<xsl:sort select="@name"/>
			</xsl:apply-templates>
		</xsl:if>
		<xsl:apply-templates select="deliv:delivery/process">
			<xsl:sort select="@actionName"/>
		</xsl:apply-templates>
	</xsl:template>
	<xsl:template name="ancestorName">
		<xsl:for-each select="ancestor-or-self::*[name()!='deliv:delivery']">/<xsl:value-of select="name()"/>
			<xsl:if test="name()='connection'">/<xsl:value-of select="@name"/>
			</xsl:if>
		</xsl:for-each>
	</xsl:template>
	<xsl:template match="*">
		<xsl:apply-templates select="@*|*|text()"/>
	</xsl:template>
	<xsl:template match="deliv:delivery/connection">##########CONNECTION <xsl:value-of select="@name"/>##########
<xsl:apply-templates select="*">
			<xsl:sort select="@name"/>
		</xsl:apply-templates>
	</xsl:template>
	<xsl:template match="deliv:delivery/process">##########PROCESS <xsl:value-of select="@actionName"/>##########
<xsl:apply-templates select="parameter"/>
		<xsl:apply-templates select="step">
			<xsl:sort select="@actionName"/>
		</xsl:apply-templates>
	</xsl:template>
	<xsl:template match="deliv:delivery/process/step">
		<xsl:apply-templates select="*|@*|text()">
			<xsl:sort select="concat(@actionName,@name)"/>
		</xsl:apply-templates>
	</xsl:template>
	<xsl:template match="connection/parameter">
		<xsl:call-template name="ancestorName"/>/<xsl:value-of select="@name"/>/type=<xsl:value-of select="@type"/>
		<xsl:text>
</xsl:text>
		<xsl:call-template name="ancestorName"/>/<xsl:value-of select="@name"/>/value=<xsl:value-of select="@value"/>
		<xsl:text>
</xsl:text>
	</xsl:template>
	<xsl:template match="step/parameter | deliv:delivery/paremter">
		<xsl:if test="not(../@type='Process' and @vName='SQL_CONNECTION')">/<xsl:value-of select="@name"/>/type=<xsl:value-of select="@type"/>
			<xsl:text>
</xsl:text>/<xsl:value-of select="@name"/>/value=<xsl:value-of select="@value"/>
			<xsl:text>
</xsl:text>
		</xsl:if>
	</xsl:template>
	<xsl:template match="connection/* | connection" mode="name">
		<xsl:call-template name="ancestorName"/>
	</xsl:template>
	<xsl:template match="altId" mode="name">/<xsl:value-of select="concat(../@actionName,'/',name())"/>
	</xsl:template>
	<xsl:template match="*" mode="name">
		<xsl:if test="@actionName">/<xsl:value-of select="@actionName"/>
		</xsl:if>
	</xsl:template>
	<xsl:template match="text()">
		<xsl:apply-templates select=".." mode="name"/>
		<xsl:text>
</xsl:text>
		<xsl:value-of select="."/>
		<xsl:text>
</xsl:text>
	</xsl:template>
	<xsl:template match="@*">
		<xsl:choose>
			<xsl:when test="../@technology='com.indy.engine.actionCodes.EmptyActionCodeI'">
				<xsl:apply-templates select="../.." mode="name"/>/EmptyAction</xsl:when>
			<xsl:otherwise>
				<xsl:apply-templates select=".." mode="name"/>
			</xsl:otherwise>
		</xsl:choose>/<xsl:value-of select="name()"/>=<xsl:value-of select="."/>
		<xsl:text>
</xsl:text>
	</xsl:template>
	<xsl:template match="altId"/>
	<xsl:template match="@id"/>
	<xsl:template match="@actionName"/>
</xsl:stylesheet>
