<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:proc="http://www.example.org/proc" xmlns:fn="http://www.w3.org/2005/02/xpath-functions" xmlns:md="http://www.stambia.com/md" xmlns:xslo="http://www.example.org/xslo" xmlns:indyParse="http://www.stambia.com/indyParse" xmlns:mds="java:com.indy.xsl.global.Strings" xmlns:mdj="java:com.indy.xsl.global.Functions" xmlns:mdv="java:com.indy.xsl.global.Variables" xmlns:tech="http://www.stambia.com/tech" xmlns:saxon="http://saxon.sf.net/" xmlns:parse="http://www.stambia.com/parseFn" xmlns:saxono="http://www.example.org/saxono"  xmlns:user="http://www.stambia.com/user" xmlns:udf="http://www.stambia.com/udf" exclude-result-prefixes="saxon xsl proc fn md xslo indyParse mds mdj mdv tech saxono user udf">
	<xsl:template match="text()" mode="parse">
		<xsl:param name="keepSpace" tunnel="yes" select="true()"/>
		<xsl:choose>
			<xsl:when test="$keepSpace and not(./../name()='xsl:choose')">
				<xslo:text>
					<xsl:value-of select="mds:restoreSpecialCharacter(.,1)"/>
				</xslo:text>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="mds:restoreSpecialCharacter(.,1)"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="@*" mode="parse">
		<xsl:copy/>
	</xsl:template>
	<xsl:template match="*" mode="parse">
		<xsl:element name="{name()}">
			<xsl:apply-templates mode="parse" select="@*|node()"/>
		</xsl:element>
	</xsl:template>
	<xsl:template match="indyParse:root" mode="parse">
		<xsl:apply-templates mode="parse" select="*|text()"/>
	</xsl:template>
	<xsl:template match="indyParse:*" mode="parse">%<xsl:value-of select="substring-after(name(),':')"/>
		<xsl:if test="@language!=''">(<xsl:value-of select="@language"/>)</xsl:if>{<xsl:apply-templates mode="parse" select="*|text()"/>}<xsl:value-of select="substring-after(name(),':')"/>
		<xsl:if test="@language!=''">(<xsl:value-of select="@language"/>)</xsl:if>%</xsl:template>
	<xsl:template name="indyParse:xslBak">
		<xsl:param tunnel="yes" name="keepSpace"/>
		<xsl:for-each select="*|text()">
			<xsl:choose>
				<xsl:when test="indyParse:node-type(.)='text'">
					<!--Ajouter une méthode qui récupère tous les namespace et initialise le truc-->
					<xsl:variable name="temp" select="mds:prepareToParse2(.,1)"/>
					<xsl:variable name="xsl" select="saxon:parse($temp)"/>
					<xsl:apply-templates select="$xsl/tmp/(*|text())" mode="parse"/>
				</xsl:when>
				<xsl:when test="indyParse:node-type(.)='element'">
					<xsl:apply-templates mode="parse" select="."/>
				</xsl:when>
			</xsl:choose>
		</xsl:for-each>
	</xsl:template>
	<xsl:template match="indyParse:text" mode="parse">
		<xslo:text>
			<xsl:value-of select="mds:restoreSpecialCharacter(.,1)"/>
		</xslo:text>
	</xsl:template>
	<xsl:template match="saxono:*" mode="parse">
		<xsl:element name="saxon:{local-name()}">
			<xsl:apply-templates mode="parse" select="@*|node()"/>
		</xsl:element>
	</xsl:template>
	<xsl:template match="xslo:*" mode="parse">
		<xsl:element name="xsl:{local-name()}">
			<xsl:apply-templates mode="parse" select="@*|node()"/>
		</xsl:element>
	</xsl:template>
	<xsl:template name="indyParse:with">
		<xsl:apply-templates mode="parse"/>
		<xslo:for-each select="{@context}[1]"/>
	</xsl:template>
	<xsl:template name="indyParse:xsl">
		<xsl:param tunnel="yes" name="keepSpace"/>
		<xsl:apply-templates mode="parse"/>
	</xsl:template>
	<xsl:template match="indyParse:targetConnection" mode="parse">
		<xslo:variable name="connRef" select="{.}/ref:targetConnection()"/>
		<xslo:variable name="connName">
			<xslo:apply-templates select="$connRef" mode="connection"/>
		</xslo:variable>
		<xslo:value-of select="$connName"/>
	</xsl:template>
	<xsl:template match="indyParse:sourceConnection" mode="parse">
		<xslo:variable name="connRef" select="{.}/ref:sourceConnection()"/>
		<xslo:variable name="connName">
			<xslo:apply-templates select="$connRef" mode="connection"/>
		</xslo:variable>
		<xslo:value-of select="$connName"/>
	</xsl:template>
	<xsl:template match="indyParse:connection" mode="parse">
		<xslo:variable name="connRef" select="{.}/ref:connection()"/>
		<xslo:variable name="connName">
			<xslo:apply-templates select="$connRef" mode="connection"/>
		</xslo:variable>
		<xslo:value-of select="$connName"/>
	</xsl:template>
	<xsl:template match="indyParse:xmlToText" mode="parse">
		<xslo:apply-templates select="{.}" mode="xmlToText">
			<xslo:with-param select="if (@indent='true') then ' ' else ''" name="indent"/>
			<xslo:with-param name="filters" select="@filters" tunnel="yes"/>
		</xslo:apply-templates>
	</xsl:template>
	<xsl:template match="indyParse:message" mode="parse">
		<xslo:message select="{.}"/>
	</xsl:template>
	<xsl:template match="indyParse:var" mode="parse">
		<xsl:param name="__mdLinkNamesSet" tunnel="yes" />
		<xsl:choose>
			<xsl:when test="ends-with(base-uri(),'configuration.xsl')">
				<!--Attention de ne pas découper cette expression en plusieurs variables (très lent à la compilation, lors du parsing de la feuille de style générée) : 
				<xslo:variable select="mdj:getMdRef(..,'{.}')" name="var"/>
				<xslo:variable select="if ($var) then $var else ../variable[@name='{.}']" name="var"/>-->
				<xsl:choose>
					<xsl:when test="mdv:getProperty('md.variable.evaluate.default.value')='true'">
						<xslo:value-of select="if (mdj:getMdRef(.,'{.}')) then mdj:getMdRef(.,'{.}')/tech:defaultValue() else ../variable[@name='{.}']/tech:defaultValue()"/>
					</xsl:when>
					<xsl:otherwise>
						<xslo:value-of select="if (mdj:getMdRef(.,'{.}')) then mdj:getMdRef(.,'{.}')/tech:columnName() else ../variable[@name='{.}']/tech:columnName()"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<xsl:choose>
					<xsl:when test="mdv:getProperty('md.variable.evaluate.default.value')='true'">
						<xsl:choose>
							<xsl:when test="../name()='indyParse:x'">
								<!-- bug 2790 -->
								$<xsl:value-of select="."/>/tech:defaultValue()
							</xsl:when>
							<xsl:otherwise>
								<xslo:value-of select="${.}/tech:defaultValue()">
								<!--columnName au lieu de call pour que ça fonctionne aussi sur les colonnes-->
								</xslo:value-of>
							</xsl:otherwise>
						</xsl:choose>
						
					</xsl:when>
					<xsl:otherwise>
					<xsl:choose>
							<xsl:when test="../name()='indyParse:x'">
								<!-- bug 2790 -->
								$<xsl:value-of select="."/>/tech:columnName()
							</xsl:when>
							<xsl:otherwise>
								<xsl:choose>
									<!-- bug  2390 -->
									<xsl:when test="parse:contains($__mdLinkNamesSet, .)">
										<xslo:value-of select="${.}/tech:columnName()">
											<!--columnName au lieu de call pour que ça fonctionne aussi sur les colonnes-->
										</xslo:value-of>
									</xsl:when>
									<xsl:otherwise>
										<!-- DI-2623 : %{X}% no more supported on xslVariable -->
										<xsl:value-of select="error(QName('http://www.example.org/foo', 'variable'), concat('%{',.,'}% ', ' usage is only allowed with a MetaDataLink and not with an XslVariable.'))" />
										<xslo:value-of select="${.}"/>
									</xsl:otherwise>
								</xsl:choose>
								
							</xsl:otherwise>
						</xsl:choose>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<!-- check if nodeSet contains a value -->
	<xsl:function name="parse:contains">
		<xsl:param name="nodeSet"/>
		<xsl:param name="value"/>
		
		<xsl:for-each select="$nodeSet">
			<xsl:if test=".=$value">
				<xsl:value-of select="true()"/>
			</xsl:if>
		</xsl:for-each>
		
	</xsl:function>
	
	<xsl:template match="indyParse:x" mode="parse">
		<xsl:variable name="eval">
		<!-- bug 2790 -->
			<xsl:for-each select="node()">
				<xsl:choose>
					<xsl:when test="starts-with(name(),'indyParse')">
						<xsl:apply-templates select="." mode="parse"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="."/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:for-each>
		</xsl:variable>
		<xsl:choose>
			<xsl:when test="@variables">
				<xsl:if test="not(@resetBefore='false')">
					<xslo:value-of select="mdv:resetVariableSet()"/>
				</xsl:if>
				<xsl:for-each select="tokenize(@variables,',')">
					<xslo:value-of select="mdv:addVariable('{.}',${.})"/>
				</xsl:for-each>
				<xslo:value-of select="{mds:restoreSpecialCharacter($eval,1)}"/>
				<xsl:if test="not(@resetAfter='false')">
					<xslo:value-of select="mdv:resetVariableSet()"/>
				</xsl:if>
			</xsl:when>
			<xsl:otherwise>
				<xslo:value-of select="{mds:restoreSpecialCharacter($eval,1)}"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="indyParse:xsl" mode="parse">
		<xsl:variable name="keepSpace" select="if (@preserveSpace='yes' or @preserveSpace='true') then true() else false()"/>
		<xsl:call-template name="indyParse:xsl">
			<xsl:with-param name="keepSpace" tunnel="yes" select="if (@preserveSpace='yes' or @preserveSpace='true') then true() else false()"/>
		</xsl:call-template>
	</xsl:template>
	<xsl:template match="indyParse:patternBak" mode="parse">
		<xslo:value-of select="mdj:pattern('{.}')"/>
	</xsl:template>
	<xsl:template match="indyParse:comment" mode="parse"/>
	<xsl:template mode="nodetype" match="*">element</xsl:template>
	<xsl:template mode="nodetype" match="@*">attribute</xsl:template>
	<xsl:template mode="nodetype" match="text()">text</xsl:template>
	<xsl:function name="indyParse:node-type">
		<xsl:param name="node"/>
		<xsl:apply-templates mode="nodetype" select="$node"/>
	</xsl:function>
</xsl:stylesheet>
