#
# You have to replace XDI_RUNTIME_SCHEDULER occurrences with the
# org.quartz.scheduler.instanceName parameter value contained into
# engineScheduler.properties file.
#

##
# drop tables that are no longer used
#
drop table STB_JOB_LISTENERS;
drop table STB_TRIGGER_LISTENERS;

#
# drop columns that are no longer used
#
alter table STB_JOB_DETAILS drop column is_volatile;
alter table STB_TRIGGERS drop column is_volatile;
alter table STB_FIRED_TRIGGERS drop column is_volatile;

#
# add new columns that replace the 'is_stateful' column
#
alter table STB_JOB_DETAILS add column is_nonconcurrent VARCHAR(1);
alter table STB_JOB_DETAILS add column is_update_data VARCHAR(1);
update STB_JOB_DETAILS set is_nonconcurrent = is_stateful;
update STB_JOB_DETAILS set is_update_data = is_stateful;
alter table STB_JOB_DETAILS drop column is_stateful;
alter table STB_FIRED_TRIGGERS add column is_nonconcurrent VARCHAR(1);
update STB_FIRED_TRIGGERS set is_nonconcurrent = is_stateful;
alter table STB_FIRED_TRIGGERS drop column is_stateful;

#
# add new 'sched_name' column to all tables --- replace "XDI_RUNTIME_SCHEDULER" with your scheduler's configured name
#
alter table STB_BLOB_TRIGGERS add column sched_name VARCHAR(120) NOT NULL DEFAULT 'XDI_RUNTIME_SCHEDULER';
alter table STB_CALENDARS add column sched_name VARCHAR(120) NOT NULL DEFAULT 'XDI_RUNTIME_SCHEDULER';
alter table STB_CRON_TRIGGERS add column sched_name VARCHAR(120) NOT NULL DEFAULT 'XDI_RUNTIME_SCHEDULER';
alter table STB_FIRED_TRIGGERS add column sched_name VARCHAR(120) NOT NULL DEFAULT 'XDI_RUNTIME_SCHEDULER';
alter table STB_JOB_DETAILS add column sched_name VARCHAR(120) NOT NULL DEFAULT 'XDI_RUNTIME_SCHEDULER';
alter table STB_LOCKS add column sched_name VARCHAR(120) NOT NULL DEFAULT 'XDI_RUNTIME_SCHEDULER';
alter table STB_PAUSED_TRIGGER_GRPS add column sched_name VARCHAR(120) NOT NULL DEFAULT 'XDI_RUNTIME_SCHEDULER';
alter table STB_SCHEDULER_STATE add column sched_name VARCHAR(120) NOT NULL DEFAULT 'XDI_RUNTIME_SCHEDULER';
alter table STB_SIMPLE_TRIGGERS add column sched_name VARCHAR(120) NOT NULL DEFAULT 'XDI_RUNTIME_SCHEDULER';
alter table STB_TRIGGERS add column sched_name VARCHAR(120) NOT NULL DEFAULT 'XDI_RUNTIME_SCHEDULER';

#
# add new 'sched_time' column to stb_fired_triggers
#
alter table STB_FIRED_TRIGGERS add column sched_time BIGINT(13) NULL;
update STB_FIRED_TRIGGERS set sched_time = fired_time;
alter table STB_FIRED_TRIGGERS MODIFY sched_time BIGINT(13) NOT NULL;

#
# drop all primary and foreign key constraints, so that we can define new ones
#
alter table STB_TRIGGERS drop constraint STB_TRIGGERS_ibfk_1;
alter table STB_BLOB_TRIGGERS drop constraint `PRIMARY`;
alter table STB_BLOB_TRIGGERS drop constraint STB_BLOB_TRIGGERS_ibfk_1;
alter table STB_SIMPLE_TRIGGERS drop constraint `PRIMARY`;
alter table STB_SIMPLE_TRIGGERS drop constraint STB_SIMPLE_TRIGGERS_ibfk_1;
alter table STB_CRON_TRIGGERS drop constraint `PRIMARY`;
alter table STB_CRON_TRIGGERS drop constraint STB_CRON_TRIGGERS_ibfk_1;
alter table STB_JOB_DETAILS drop constraint `PRIMARY`;
alter table STB_JOB_DETAILS add primary key (sched_name, job_name, job_group);
alter table STB_TRIGGERS drop constraint `PRIMARY`;

#
# add all primary and foreign key constraints, based on new columns
#
alter table STB_TRIGGERS add primary key (sched_name, trigger_name, trigger_group);
alter table STB_TRIGGERS add foreign key (sched_name, job_name, job_group) references STB_JOB_DETAILS(sched_name, job_name, job_group);
alter table STB_BLOB_TRIGGERS add primary key (sched_name, trigger_name, trigger_group);
alter table STB_BLOB_TRIGGERS add foreign key (sched_name, trigger_name, trigger_group) references STB_TRIGGERS(sched_name, trigger_name, trigger_group);
alter table STB_CRON_TRIGGERS add primary key (sched_name, trigger_name, trigger_group);
alter table STB_CRON_TRIGGERS add foreign key (sched_name, trigger_name, trigger_group) references STB_TRIGGERS(sched_name, trigger_name, trigger_group);
alter table STB_SIMPLE_TRIGGERS add primary key (sched_name, trigger_name, trigger_group);
alter table STB_FIRED_TRIGGERS add foreign key (sched_name, trigger_name, trigger_group) references STB_TRIGGERS(sched_name, trigger_name, trigger_group);
alter table STB_FIRED_TRIGGERS drop constraint `PRIMARY`;
alter table STB_FIRED_TRIGGERS add primary key (sched_name, entry_id);
alter table STB_CALENDARS drop constraint `PRIMARY`;
alter table STB_CALENDARS add primary key (sched_name, calendar_name);
alter table STB_LOCKS drop constraint `PRIMARY`;
alter table STB_LOCKS add primary key (sched_name, lock_name);
alter table STB_PAUSED_TRIGGER_GRPS drop constraint `PRIMARY`;
alter table STB_PAUSED_TRIGGER_GRPS add primary key (sched_name, trigger_group);
alter table STB_SCHEDULER_STATE drop constraint `PRIMARY`;
alter table STB_SCHEDULER_STATE add primary key (sched_name, instance_name);

#
# add new simprop_triggers table
#
CREATE TABLE STB_SIMPROP_TRIGGERS
  (
    SCHED_NAME VARCHAR(120) NOT NULL,
    TRIGGER_NAME VARCHAR(190) NOT NULL,
    TRIGGER_GROUP VARCHAR(190) NOT NULL,
    STR_PROP_1 VARCHAR(512) NULL,
    STR_PROP_2 VARCHAR(512) NULL,
    STR_PROP_3 VARCHAR(512) NULL,
    INT_PROP_1 INT NULL,
    INT_PROP_2 INT NULL,
    LONG_PROP_1 BIGINT NULL,
    LONG_PROP_2 BIGINT NULL,
    DEC_PROP_1 NUMERIC(13,4) NULL,
    DEC_PROP_2 NUMERIC(13,4) NULL,
    BOOL_PROP_1 VARCHAR(1) NULL,
    BOOL_PROP_2 VARCHAR(1) NULL,
    PRIMARY KEY (SCHED_NAME,TRIGGER_NAME,TRIGGER_GROUP),
    FOREIGN KEY (SCHED_NAME,TRIGGER_NAME,TRIGGER_GROUP)
    REFERENCES STB_TRIGGERS(SCHED_NAME,TRIGGER_NAME,TRIGGER_GROUP))
;

#
# create indexes for faster queries
#
CREATE INDEX IDX_STB_J_REQ_RECOVERY ON STB_JOB_DETAILS(SCHED_NAME,REQUESTS_RECOVERY);
CREATE INDEX IDX_STB_J_GRP ON STB_JOB_DETAILS(SCHED_NAME,JOB_GROUP);

CREATE INDEX IDX_STB_T_J ON STB_TRIGGERS(SCHED_NAME,JOB_NAME,JOB_GROUP);
CREATE INDEX IDX_STB_T_JG ON STB_TRIGGERS(SCHED_NAME,JOB_GROUP);
CREATE INDEX IDX_STB_T_C ON STB_TRIGGERS(SCHED_NAME,CALENDAR_NAME);
CREATE INDEX IDX_STB_T_G ON STB_TRIGGERS(SCHED_NAME,TRIGGER_GROUP);
CREATE INDEX IDX_STB_T_STATE ON STB_TRIGGERS(SCHED_NAME,TRIGGER_STATE);
CREATE INDEX IDX_STB_T_N_STATE ON STB_TRIGGERS(SCHED_NAME,TRIGGER_NAME,TRIGGER_GROUP,TRIGGER_STATE);
CREATE INDEX IDX_STB_T_N_G_STATE ON STB_TRIGGERS(SCHED_NAME,TRIGGER_GROUP,TRIGGER_STATE);
CREATE INDEX IDX_STB_T_NEXT_FIRE_TIME ON STB_TRIGGERS(SCHED_NAME,NEXT_FIRE_TIME);
CREATE INDEX IDX_STB_T_NFT_ST ON STB_TRIGGERS(SCHED_NAME,TRIGGER_STATE,NEXT_FIRE_TIME);
CREATE INDEX IDX_STB_T_NFT_MISFIRE ON STB_TRIGGERS(SCHED_NAME,MISFIRE_INSTR,NEXT_FIRE_TIME);
CREATE INDEX IDX_STB_T_NFT_ST_MISFIRE ON STB_TRIGGERS(SCHED_NAME,MISFIRE_INSTR,NEXT_FIRE_TIME,TRIGGER_STATE);
CREATE INDEX IDX_STB_T_NFT_ST_MISFIRE_GRP ON STB_TRIGGERS(SCHED_NAME,MISFIRE_INSTR,NEXT_FIRE_TIME,TRIGGER_GROUP,TRIGGER_STATE);

CREATE INDEX IDX_STB_FT_TRIG_INST_NAME ON STB_FIRED_TRIGGERS(SCHED_NAME,INSTANCE_NAME);
CREATE INDEX IDX_STB_FT_INST_JOB_REQ_RCVRY ON STB_FIRED_TRIGGERS(SCHED_NAME,INSTANCE_NAME,REQUESTS_RECOVERY);
CREATE INDEX IDX_STB_FT_J_G ON STB_FIRED_TRIGGERS(SCHED_NAME,JOB_NAME,JOB_GROUP);
CREATE INDEX IDX_STB_FT_JG ON STB_FIRED_TRIGGERS(SCHED_NAME,JOB_GROUP);
CREATE INDEX IDX_STB_FT_T_G ON STB_FIRED_TRIGGERS(SCHED_NAME,TRIGGER_NAME,TRIGGER_GROUP);
CREATE INDEX IDX_STB_FT_TG ON STB_FIRED_TRIGGERS(SCHED_NAME,TRIGGER_GROUP);

commit;