#!/bin/bash
#
# Copyright (c) Semarchy.  All rights reserved.
#
# PRODUCT Semarchy xDI Runtime
#   
#	This script allows to start a Runtime.
#
#	The Runtime will be started using the default configuration files and VM properties if no parameters are specified.
#	You can have a look at the initvariables.sh script to find these default properties if required.
#
#	Note:
#	To have an overview of the possible parameters, use the -usage parameter
#	
#	Examples:
#	startengine.sh -usage
#	startengine.sh -port 42200
#


sp0=$( cd "$(dirname "${BASH_SOURCE[0]}")" ; pwd -P )

. "$sp0/initvariables.sh"


if [ "$STAMBIA_JAVA_HOME" = "" ]; then
        if [ "$JAVA_HOME" = "" ]; then
	        java -debug "${XDI_RUNTIME_VM_PROPERTIES[@]}" "$XDI_RUNTIME_STARTENGINE_VM_PROPERTIES" $XDI_RUNTIME_OPTS "$XDI_RUNTIME_SYSTEM_CLASSLOADER" "$XDI_RUNTIME_INIT_CLASSPATH_OPTION" "$XDI_RUNTIME_CORE_CLASSPATH_OPTION" "$XDI_RUNTIME_MODULES_PATH_OPTION" -classpath "$XDI_RUNTIME_CLASSPATH" "$SCHEDULE_PROPS" "$SECURITY_PROPS" com.indy.engine.launcher.MainLauncher -mainclass com.indy.engine.EngineStartI -conf "$XDI_RUNTIME_CONF_FILE_LOCATION" "$@"
        else
                "$JAVA_HOME/bin/java" "${XDI_RUNTIME_VM_PROPERTIES[@]}" "$XDI_RUNTIME_STARTENGINE_VM_PROPERTIES" $XDI_RUNTIME_OPTS "$XDI_RUNTIME_SYSTEM_CLASSLOADER" "$XDI_RUNTIME_INIT_CLASSPATH_OPTION" "$XDI_RUNTIME_CORE_CLASSPATH_OPTION" "$XDI_RUNTIME_MODULES_PATH_OPTION" -classpath "$XDI_RUNTIME_CLASSPATH" "$SCHEDULE_PROPS" "$SECURITY_PROPS" com.indy.engine.launcher.MainLauncher -mainclass com.indy.engine.EngineStartI -conf "$XDI_RUNTIME_CONF_FILE_LOCATION" "$@"
        fi
else
	"$STAMBIA_JAVA_HOME/bin/java" "${XDI_RUNTIME_VM_PROPERTIES[@]}" "$XDI_RUNTIME_STARTENGINE_VM_PROPERTIES" $XDI_RUNTIME_OPTS "$XDI_RUNTIME_SYSTEM_CLASSLOADER" "$XDI_RUNTIME_INIT_CLASSPATH_OPTION" "$XDI_RUNTIME_CORE_CLASSPATH_OPTION" "$XDI_RUNTIME_MODULES_PATH_OPTION" -classpath "$XDI_RUNTIME_CLASSPATH" "$SCHEDULE_PROPS" "$SECURITY_PROPS" com.indy.engine.launcher.MainLauncher -mainclass com.indy.engine.EngineStartI -conf "$XDI_RUNTIME_CONF_FILE_LOCATION" "$@"
fi
