<?xml version='1.0' encoding='UTF-8'?><xsl:stylesheet xmlns:mdj="java:com.indy.xsl.global.Functions" xmlns:mdv="java:com.indy.xsl.global.Variables" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:ref="http://www.stambia.com/ref" xmlns:saxon="http://saxon.sf.net/" xmlns:tech="http://www.stambia.com/tech" xmlns:indyParse="http://www.stambia.com/indyParse" xmlns:ecore="http://www.eclipse.org/emf/2002/Ecore" xmlns:proc="http://www.example.org/proc" xmlns:func="http://www.stambia.com/func" xmlns:rdbms="http://www.stambia.com/rdbms" xmlns:md="http://www.stambia.com/md" xmlns:user="http://www.stambia.com/user" xmlns:UUID="java.util.UUID" xmlns:mds="java:com.indy.xsl.global.Strings" xmlns:map="http://www.stambia.com/map" xmlns:saxono="http://www.example.org/saxono" xmlns:xslo="http://www.example.org/xslo" xmlns:foo="http://www.example.org/foo" xmlns:gen="java:com.indy.xsl.gene.GenerationMap" xmlns:stack="java:com.indy.xsl.gene.StackedVariableManager" xmlns:jstack="java:com.indy.xsl.gene.StackWrapper" xmlns:procGen="http://www.stambia.com/procGen/com.indy.xsl.gene.GenerationExtensionElementFactory" xmlns:graph="java:com.indy.xsl.gene.process.Graph" version="2.0" extension-element-prefixes="saxon ref indyParse tech procGen"><xsl:output method="xml" encoding="UTF-8" cdata-section-elements="generationCondition executionCondition code step resultCode metaData"/><xsl:preserve-space elements="code CData resultCode"/><xsl:namespace-alias stylesheet-prefix="xslo" result-prefix="xsl"/><xsl:namespace-alias stylesheet-prefix="saxono" result-prefix="saxon"/><xsl:include href="global.xsl"/><xsl:include href="udf.xsl"/><xsl:param name="graph"/><xsl:param name="__jStack"/><xsl:variable name="__oneProc" select="document('file:/D:/semarchy-xdi-designer/runtime/build/tmp/wrk1/ea-demo-project/00-ADHAN/MainProcess/MAIN-ADHAN.oneProc.proc')"/><xsl:variable name="REF" select="error(QName('http://www.example.org/foo', 'variable'), concat('variable REF not available in the Variable stack in ', jstack:getPath($__jStack)))" saxon:assignable="yes"/><xsl:variable name="fileName" select="error(QName('http://www.example.org/foo', 'variable'), concat('variable fileName not available in the Variable stack in ', jstack:getPath($__jStack)))" saxon:assignable="yes"/><xsl:variable name="CDC" select="error(QName('http://www.example.org/foo', 'variable'), concat('variable CDC not available in the Variable stack in ', jstack:getPath($__jStack)))" saxon:assignable="yes"/><xsl:variable name="viewName" select="error(QName('http://www.example.org/foo', 'variable'), concat('variable viewName not available in the Variable stack in ', jstack:getPath($__jStack)))" saxon:assignable="yes"/><xsl:variable name="Query" select="error(QName('http://www.example.org/foo', 'variable'), concat('variable Query not available in the Variable stack in ', jstack:getPath($__jStack)))" saxon:assignable="yes"/><xsl:variable name="datastore" select="error(QName('http://www.example.org/foo', 'variable'), concat('variable datastore not available in the Variable stack in ', jstack:getPath($__jStack)))" saxon:assignable="yes"/><xsl:variable name="context" select="error(QName('http://www.example.org/foo', 'variable'), concat('variable context not available in the Variable stack in ', jstack:getPath($__jStack)))" saxon:assignable="yes"/><xsl:variable name="useSubQuery" select="error(QName('http://www.example.org/foo', 'variable'), concat('variable useSubQuery not available in the Variable stack in ', jstack:getPath($__jStack)))" saxon:assignable="yes"/><xsl:variable name="fields" select="error(QName('http://www.example.org/foo', 'variable'), concat('variable fields not available in the Variable stack in ', jstack:getPath($__jStack)))" saxon:assignable="yes"/><xsl:variable name="stageTableName" select="error(QName('http://www.example.org/foo', 'variable'), concat('variable stageTableName not available in the Variable stack in ', jstack:getPath($__jStack)))" saxon:assignable="yes"/><xsl:variable name="this" select="$__oneProc" saxon:assignable="yes"/>

	<xsl:template name="pushTpl">
		<xsl:param name="stepNode"/>
		<xsl:for-each select="$stepNode/mdLink">
			
			<xsl:variable name="cur" select="."/>
			<procGen:pushVar variableName="string($cur/@name)" select="mdj:getRef(., string($cur/@expression))" mode="xsl" isMdLink="true"/>
		</xsl:for-each>
		<xsl:for-each select="$stepNode/xslVariable">
			<xsl:variable name="cur" select="."/>
			<xsl:choose>
				<xsl:when test="$cur/@type='xsl'">
					<xsl:variable name="__parseVar">
						<saxon:call-template name="initVar_{$cur/@srcId}"/>
					</xsl:variable>
					<procGen:pushVar variableName="string($cur/@name)" select="$__parseVar" mode="xsl"/>
				</xsl:when>
				<xsl:when test="./@type='xpath' and $cur/@needParse='true'">
					<xsl:variable name="__parseVar">
						<saxon:call-template name="initVar_{$cur/@srcId}"/>
					</xsl:variable>
					<procGen:pushVar variableName="string($cur/@name)" select="$__parseVar" mode="xpath"/>
				</xsl:when>
				<xsl:when test="./@type='xpath'">
					<procGen:pushVar variableName="string($cur/@name)" select="string($cur/@expression)" mode="xpath"/>
				</xsl:when>
			</xsl:choose>
		</xsl:for-each>
	</xsl:template>

	<xsl:template name="popTpl">
		<xsl:param name="stepNode"/>

		<xsl:for-each select="$stepNode/*[name()='xslVariable' or name()='mdLink']">
			
			<xsl:variable name="cur" select="."/>
			<procGen:popVar variableName="string($cur/@name)"/>
		</xsl:for-each>
	</xsl:template>

	<xsl:template name="eval__XXX">
		<xsl:param name="nodeId"/>
		<xsl:param name="__repetetitions"/>
		<xsl:param name="generated"/>
		<xsl:param name="hasRepetition"/>
		<xsl:choose>
			<xsl:when test="$generated=true()">
				<xsl:choose>
					<xsl:when test="$hasRepetition=false()">
						<xsl:value-of select="graph:handleGenerationEvent($nodeId, 'START','')"/>
						<xsl:value-of select="graph:handleGenerationEvent($nodeId, 'GENERATE','')"/>
						<xsl:value-of select="graph:handleGenerationEvent($nodeId, 'END','')"/>
					</xsl:when>
					<xsl:when test="$hasRepetition=true() and count($__repetetitions)>0">
						<xsl:for-each select="$__repetetitions">
							<xsl:value-of select="graph:handleGenerationEvent($nodeId, 'START','')"/>
							<xsl:variable name="__nodeInfoId">
								<xsl:value-of select="graph:handleGenerationEvent($nodeId, 'ITERATION',if (current()/@name !='') then current()/@name else concat('', position()))"/>
							</xsl:variable>
							<xsl:value-of select="stack:storeValue($__nodeInfoId, current())"/>
							<xsl:value-of select="graph:handleGenerationEvent($nodeId, 'END','')"/>
						</xsl:for-each>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="graph:handleGenerationEvent($nodeId, 'START','')"/>
						<xsl:value-of select="graph:handleGenerationEvent($nodeId, 'NO_GENERATE','')"/>
						<xsl:value-of select="graph:handleGenerationEvent($nodeId, 'END','')"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="graph:handleGenerationEvent($nodeId, 'START','')"/>
				<xsl:value-of select="graph:handleGenerationEvent($nodeId, 'NO_GENERATE','')"/>
				<xsl:value-of select="graph:handleGenerationEvent($nodeId, 'END','')"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>


	<xsl:param name="genMap"/>

	<xsl:template name="root" match="/">

		<xsl:for-each select="node[1]">
			<result>
				<xsl:call-template name="metadataTrigger">
					<xsl:with-param name="this" select="$__oneProc/*[1]"/>
				</xsl:call-template>

				<xsl:value-of select="graph:handleGenerationEvent(current()/@id, 'START', '')"/>
				<xsl:value-of select="graph:handleGenerationEvent(current()/@id, 'GENERATE', '')"/>
				<xsl:value-of select="graph:handleGenerationEvent(current()/@id, 'END', '')"/>
				<xsl:call-template name="main">
					<xsl:with-param name="oneProcNode" select="$__oneProc/*[(name()='proc:process' or name()='subProcess' or name()='actionCode') and @id=current()/@id]"/>
				</xsl:call-template>


				<xsl:copy-of select="$allConnection/*[name()='connection']"/>
			</result>
		</xsl:for-each>
	</xsl:template>

	<xsl:template name="generate">
		<xsl:param name="graphNode"/>
		<xsl:param name="nodeInfoId"/>
		<xsl:param name="processNode"/>
		
		<xsl:variable name="__nodeCtx" select="if (exists($processNode)) then $processNode else (.)"/>
		<xsl:for-each select="$graphNode/parameter[@needParse='true']">
			<xsl:variable name="__tplSuffix" select="./@srcId"/>
			<xsl:variable name="__pName" select="./@name"/>
			<xsl:for-each select="$__nodeCtx">
				<xsl:variable name="__gen">
					<saxon:call-template name="initParameter_{$__tplSuffix}"/>
				</xsl:variable>
				<xsl:value-of select="gen:store($genMap, concat($nodeInfoId, '.parameter.',$__pName), $__gen)"/>
			</xsl:for-each>
		</xsl:for-each>
		
		
		
		<xsl:if test="$__nodeCtx/name()='actionCode'">
			<xsl:choose>
				<xsl:when test="exists($graphNode/@moduleName)">
					<xsl:for-each select="$graphNode">
						<xsl:value-of select="gen:store($genMap, concat($nodeInfoId, '.module'), $graphNode/@moduleName)"/>
					</xsl:for-each>
				</xsl:when>
				<xsl:when test="exists($graphNode/@moduleNameNeedParse)">
					<xsl:for-each select="$graphNode">
						<xsl:variable name="moduleName">
							<saxon:call-template name="initActionModuleName_{$graphNode/@srcId}"/>
						</xsl:variable>
						<xsl:if test="$moduleName!=''">
							<xsl:value-of select="gen:store($genMap, concat($nodeInfoId, '.module'), $moduleName)"/>
						</xsl:if>
					</xsl:for-each>
				</xsl:when>
				<xsl:otherwise>
					
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>
 	

		<xsl:if test="$graphNode/@hasCode='true'">
			<xsl:for-each select="$__nodeCtx">
				<xsl:variable name="__gen">
				<saxon:call-template name="initAction_{$graphNode/@srcId}"/>
			</xsl:variable>
			<xsl:value-of select="gen:store($genMap, concat($nodeInfoId, '.code'), $__gen)"/>
			</xsl:for-each>
			
		</xsl:if>
		<xsl:if test="$graphNode/@executionCondition='true'">
			<xsl:for-each select="$__nodeCtx">
				<xsl:variable name="__gen">
					<saxon:call-template name="initExecutionConditionLink_{$graphNode/@srcId}"/>
				</xsl:variable>
				<xsl:value-of select="gen:store($genMap, concat($nodeInfoId, '|--', graph:getLinkInputNodeInfoId($nodeInfoId), '.executionCondition'), $__gen)"/>
			</xsl:for-each>
			
		</xsl:if>
		<xsl:if test="$graphNode/@dynamicName='true'">
			<xsl:for-each select="$__nodeCtx">
				<xsl:variable name="__gen">
				<saxon:call-template name="initStepDynamicName_{$graphNode/@id}"/>
			</xsl:variable>
			<xsl:value-of select="gen:store($genMap, concat($nodeInfoId, '.dynamicName'), $__gen)"/>
			</xsl:for-each>
		</xsl:if>
		<xsl:if test="$graphNode/@semaphoreName='true'">
			<xsl:for-each select="$__nodeCtx">
				<xsl:variable name="__gen">
					<saxon:call-template name="initStepSemaphoreName_{$graphNode/@id}"/>
				</xsl:variable>
			<xsl:value-of select="gen:store($genMap, concat($nodeInfoId, '.semaphoreName'), $__gen)"/>
			</xsl:for-each>
		</xsl:if>
	</xsl:template>

	<xsl:template name="main">
		<xsl:param name="oneProcNode"/>
		
		<xsl:variable name="currentNode" select="."/>
		<xsl:value-of select="jstack:push($__jStack, string($oneProcNode/@name))"/>		
		
		<xsl:if test="@withContext='true'">
			<procGen:pushVar variableName="'this'" select="$oneProcNode" mode="xsl"/>
			<xsl:if test="@contextHasContent='true'">
				<xsl:call-template name="pushTpl">
					<xsl:with-param name="stepNode" select="$currentNode"/>
				</xsl:call-template>

			</xsl:if>
		</xsl:if>

		<xsl:for-each select="node">
			<xsl:sort select="@generationOrder" data-type="number"/>
			<xsl:variable name="__cuNodeId" select="string(./@id)"/>
			<xsl:variable name="__cuNode" select="if (./@isLink='true') then saxon:evaluate(graph:getProcNodeXPathExpression($currentNode/@id), $__oneProc) else $oneProcNode/child::node()[@id=$__cuNodeId]"/>

			<xsl:variable name="needPush" select="@evalNeedsMdLink='true'"/>
			
			<xsl:if test="$needPush">
				<xsl:call-template name="pushTpl">
					<xsl:with-param name="stepNode" select="."/>
				</xsl:call-template>
			</xsl:if>
			
			<xsl:call-template name="eval__XXX">
				<xsl:with-param name="nodeId" select="./@id"/>
				<xsl:with-param name="generated" select="if (./@condition!='') then mdj:evaluateCondition($__cuNode, string(./@condition)) else true()"/>
				<xsl:with-param name="__repetetitions" select="if(./@repetitionQuery!='') then func:repetitionValues(./@repetitionQueryHash) else ''"/>
				<xsl:with-param name="hasRepetition" select="./@repetitionQuery!=''"/>
			</xsl:call-template>
			
			<xsl:if test="$needPush">
				<xsl:call-template name="popTpl">
					<xsl:with-param name="stepNode" select="."/>
				</xsl:call-template>
			</xsl:if>
		</xsl:for-each>

		<xsl:variable name="currentNodeInfoId">
			<xsl:value-of select="graph:handleGenerationEvent(@id, 'BUILD_CONTENT', '')"/>
		</xsl:variable>

		<xsl:if test="graph:needGeneration($currentNodeInfoId)=true()">
			<xsl:variable name="__firstNodeInfoIdWithRepetition" select="graph:getFirstNodeInfoIdWithRepetition($currentNodeInfoId)"/>
			<xsl:choose>
				<xsl:when test="exists($__firstNodeInfoIdWithRepetition)">
					<xsl:for-each select="stack:getStoredValue($__firstNodeInfoIdWithRepetition)">
						<xsl:call-template name="generate">
							<xsl:with-param name="nodeInfoId" select="$currentNodeInfoId"/>
							<xsl:with-param name="graphNode" select="$currentNode"/>
							<xsl:with-param name="processNode" select="."/>
						</xsl:call-template>
					</xsl:for-each>
				</xsl:when>
				<xsl:otherwise>
					<xsl:call-template name="generate">
						<xsl:with-param name="nodeInfoId" select="$currentNodeInfoId"/>
						<xsl:with-param name="graphNode" select="$currentNode"/>
						<xsl:with-param name="processNode" select="$oneProcNode"/>
					</xsl:call-template>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>


		<xsl:if test="$this/name()='actionCode' and $this/@technology ='com.indy.engine.actionCodes.JdbcActionCodeI'">
			<xsl:variable name="__conTrigger">
				<xsl:call-template name="connectionTrigger">
					<xsl:with-param name="this" select="$this"/>
				</xsl:call-template>
			</xsl:variable>
			<xsl:if test="exists($__conTrigger)">
				<xsl:copy-of select="$__conTrigger/connection"/>
				<xsl:for-each select="$__conTrigger/parameter">
					<xsl:if test="gen:isStored($genMap, concat($currentNodeInfoId, '.parameter.',./@name))=false()">
						<xsl:value-of select="gen:store($genMap, concat($currentNodeInfoId, '.parameter.',./@name), ./@value)"/>
					</xsl:if>
				</xsl:for-each>
			</xsl:if>
		</xsl:if>


		<xsl:if test="$this/name()='actionCode' and exists($this/metaDataLink)">
			<xsl:for-each select="$this/metaDataLink">
				<xsl:variable name="metaDataLink" select="stack:getCurrentValue(./@name, true())"/>
				<xsl:variable name="level" select="if ($metaDataLink) then mdj:getLevel($metaDataLink) else None"/>
				<xsl:variable name="metaDataLinkType" select="$level/../metaDataLinkType[level=concat('#',$level/@code)]"/>
				<xsl:for-each select="$metaDataLinkType/parameter">
					<xsl:if test="exists($this/parameter[@name=current()/@name])=false() and gen:isStored($genMap, concat($currentNodeInfoId, '.parameter.',./@name))=false() and (../(technology=$this/@technology or technology='*'))">
						<xsl:variable name="value" select="mdj:evaluate($metaDataLink,@value)"/>
						<xsl:variable name="connValue">
							<xsl:if test="exists($value)">
								<xsl:if test="mdj:isNode($value)">
									<xsl:if test="not($value/text()!='')">
										<xsl:apply-templates select="$value" mode="connection"/>
									</xsl:if>
								</xsl:if>
							</xsl:if>
						</xsl:variable>
						<xsl:variable name="value" select="if ($connValue!='') then $connValue else $value"/>
						<xsl:if test="$value!=''">
							<xsl:value-of select="gen:store($genMap, concat($currentNodeInfoId, '.parameter.',./@name), $value)"/>
						</xsl:if>
					</xsl:if>
				</xsl:for-each>
				<xsl:for-each select="$metaDataLinkType/actionCodeProperty[@name='moduleName']">
					<xsl:if test="gen:isStored($genMap, concat($currentNodeInfoId, '.module'))=false() and (../(technology=$this/@technology or technology='*'))">
						<xsl:variable name="value" select="mdj:evaluate($metaDataLink,@value)"/>
						<xsl:variable name="connValue">
							<xsl:if test="exists($value)">
								<xsl:if test="mdj:isNode($value)">
									<xsl:if test="not($value/text()!='')">
										<xsl:apply-templates select="$value" mode="connection"/>
									</xsl:if>
								</xsl:if>
							</xsl:if>
						</xsl:variable>
						<xsl:variable name="value" select="if ($connValue!='') then $connValue else $value"/>
						<xsl:if test="$value!=''">
							<xsl:value-of select="gen:store($genMap, concat($currentNodeInfoId, '.module'), $value)"/>
						</xsl:if>
					</xsl:if>
				</xsl:for-each>
			</xsl:for-each>
		</xsl:if>


		<xsl:for-each select="graph:getChildrenInstance($currentNodeInfoId)">

			<xsl:if test="graph:isEvaluated(current())=true()">
				<xsl:value-of select="graph:handleGenerationEvent(current(), 'PUSH', '')"/>
				<xsl:variable name="currentChildren" select="$currentNode/node[@id=graph:getNodeId(current())]"/>
				<xsl:variable name="__cuNodeId" select="graph:getNodeId(current())"/>
				<xsl:variable name="__cuNode" select="if ($currentChildren/@isLink='true') then saxon:evaluate(graph:getProcNodeXPathExpression($currentChildren/@id), $__oneProc) else $oneProcNode/child::node()[@id=$__cuNodeId]"/>

				<xsl:choose>
					<xsl:when test="$currentChildren/@repetitionQuery!=''">
						<xsl:choose>
							<xsl:when test="$currentChildren/@repetitionVar!=''">
								<xsl:variable name="__repetitionValue" select="stack:getStoredValue(current())"/>
								 
								<procGen:pushVar variableName="string($currentChildren/@repetitionVar)" select="$__repetitionValue" mode="xsl"/>
								<xsl:for-each select="$currentChildren">
									<xsl:call-template name="main">
										<xsl:with-param name="oneProcNode" select="$__cuNode"/>
									</xsl:call-template>
								</xsl:for-each>
								
								<procGen:popVar variableName="string($currentChildren/@repetitionVar)"/>
							</xsl:when>
							<xsl:otherwise>
								<xsl:variable name="curChildId" select="current()"/>

								<xsl:for-each select="$currentChildren">
									<xsl:call-template name="main">
										<xsl:with-param name="oneProcNode" select="$__cuNode"/>
									</xsl:call-template>
								</xsl:for-each>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					<xsl:otherwise>
						<xsl:for-each select="$currentChildren">
							<xsl:call-template name="main">
								<xsl:with-param name="oneProcNode" select="$__cuNode"/>
							</xsl:call-template>
						</xsl:for-each>
					</xsl:otherwise>
				</xsl:choose>
				<xsl:value-of select="graph:handleGenerationEvent(current(), 'POP', '')"/>
			</xsl:if>
		</xsl:for-each>

		<xsl:if test="@withContext='true'">
			<xsl:if test="@contextHasContent='true'">
				<xsl:call-template name="popTpl">
					<xsl:with-param name="stepNode" select="$currentNode"/>
				</xsl:call-template>
			</xsl:if>
			
			<procGen:popVar variableName="'this'"/>
		</xsl:if>
		
		<xsl:value-of select="jstack:pop($__jStack)"/>
	</xsl:template>
<xsl:function name="func:repetitionValues"><xsl:param name="queryHash"/><xsl:choose><xsl:when test="$queryHash='69edfe0ee21527130d50d26d6190b6eb'"><xsl:sequence select="$fields//datastore"/></xsl:when><xsl:when test="$queryHash='0de3ccf4416229a8bb1bcc6c864cfd91'"><xsl:sequence select="$REF/ref:from()[tech:isCDC() and not(tech:isLoaded())]"/></xsl:when></xsl:choose></xsl:function><xsl:template name="initAction__-rJVzYK_Ed-d_svPnbkaRw"><xsl:text>use "</xsl:text><xsl:value-of select="$REF/ref:target()/ref:workSchema()/tech:catalogName()"/><xsl:text>"
</xsl:text></xsl:template><xsl:template name="initParameter_889f5a05-5d60-43d3-bb08-e53991d05069"><xsl:variable name="connRef" select="$REF/ref:sourceConnection()"/><xsl:variable name="connName"><xsl:apply-templates select="$connRef" mode="connection"/></xsl:variable><xsl:value-of select="$connName"/></xsl:template><xsl:template name="initAction__SvxAwINnEd-IoaIVtuAGTw"><xsl:text>use "</xsl:text><xsl:value-of select="$REF/ref:target()/ref:workSchema()/tech:catalogName()"/><xsl:text>"
</xsl:text></xsl:template><xsl:template name="initParameter_39c667ef-2df6-4274-9c2f-111f86ba3f9a"><xsl:variable name="connRef" select="$REF/ref:targetConnection()"/><xsl:variable name="connName"><xsl:apply-templates select="$connRef" mode="connection"/></xsl:variable><xsl:value-of select="$connName"/></xsl:template><xsl:template name="initParameter_e163f406-7ae1-47fd-b6e6-7caa42e7c8bd"><xsl:value-of select="if (md:paramValue($this,'transactionalModeOnWorkTables')='true') then 'NOCOMMIT' else 'AUTOCOMMIT' "/></xsl:template><xsl:template name="initParameter_172df31a-2cc0-43b4-a24e-56f2c3fb364f"><xsl:value-of select="if (md:paramValue($this,'transactionalModeOnWorkTables')='true') then md:paramValue($this,'transactionName') else '' "/></xsl:template><xsl:template name="initAction__w4gOMDRMEeSQ37GXUClEnA"><xsl:value-of select="if($REF/ref:target()/tech:dropViewIfExists()) then $REF/ref:target()/tech:dropViewIfExists($stageTableName) else concat('drop view ',$stageTableName)"/></xsl:template><xsl:template name="initAction__rdD5OjRMEeSQ37GXUClEnA"><xsl:value-of select="if($REF/ref:target()/tech:dropTableIfExists()) then $REF/ref:target()/tech:dropTableIfExists($stageTableName) else concat('drop table ',$stageTableName)"/></xsl:template><xsl:template name="initParameter_b44de507-550b-49f5-a876-8af7f249f430"><xsl:variable name="connRef" select="$REF/ref:target()/ref:connection()"/><xsl:variable name="connName"><xsl:apply-templates select="$connRef" mode="connection"/></xsl:variable><xsl:value-of select="$connName"/></xsl:template><xsl:template name="initParameter_339daab0-e70a-4b8c-b02b-edad4339becf"><xsl:value-of select="$fileName"/></xsl:template><xsl:template name="initParameter_6f457a15-37f2-4f8c-a624-fd6fec1c4f17"><xsl:value-of select="if (md:paramValue($this,'extractBase64BinaryToFile')='true') &#xa;&#x9;then md:ifEmpty(md:paramValue($this/..,'base64BinariesExtractDirectory'),concat('xmlBase64Binaries/',$REF/ref:target()/@id)) &#xa;&#x9;else ''"/></xsl:template><xsl:template name="initParameter_651e299a-0bc0-4018-8bd2-a5474f6f33e0"><xsl:value-of select="md:ifEmpty(md:paramValue($this,'XML_COMMIT',3),md:paramValue($this,'XML_COMMIT',2))"/></xsl:template><xsl:template name="initExecutionConditionLink__a04e67f1-d583-48a4-a253-e67161ff275c"><xsl:text>${SqlToXml/XML_NB_ELEMENTS}$&gt;0</xsl:text></xsl:template><xsl:template name="initAction__VUNTGTgyEd-jwpjHwxWmmQ"><xsl:text>
</xsl:text>

<xsl:variable name="md">
<root>
	<xsl:copy-of select="$context"/>
	<xsl:for-each select="$fields/datastore">
		<insert datastore="{@fullPath}">insert into <xsl:value-of select="@physicalName"/> 
		(<xsl:value-of select="md:list(field/workName,',')"/>) values(<xsl:value-of select="md:list(field/concat(':{',@fullPath,'}:'),',')"/>)</insert>
	</xsl:for-each>
</root>
</xsl:variable>

<xsl:apply-templates select="$md" mode="xmlToText"><xsl:with-param select="if (@indent='true') then ' ' else ''" name="indent"/><xsl:with-param name="filters" select="@filters" tunnel="yes"/></xsl:apply-templates>



<xsl:text> 
</xsl:text><xsl:if test="$useSubQuery" use-when="system-property('xpath.function.setStagingpoint.supported')='true'">
<xsl:variable name="name" select="$REF/@name"/>
<xsl:for-each select="$REF/../step/source[@name=$REF/@name]">
<xsl:variable name="current" select="."/>
<xsl:value-of select="md:setStagingPoint(@id,$Query/query[@name=$current/../@name],'query')"/>
</xsl:for-each>
</xsl:if>
<xsl:text>
</xsl:text></xsl:template><xsl:template name="initAction__rdD5NTRMEeSQ37GXUClEnA">Create table <xsl:value-of select="$stageTableName"/>
AS
<xsl:variable name="sets">
<xsl:for-each select="if (count($REF/tech:sourceSets())=0) then '' else $REF/tech:sourceSets() ">
<set name="{.}">
<xsl:variable name="sourceSetName" select="."/>
<xsl:variable name="columns" select="$REF/ref:columns($sourceSetName)"/>
select		<xsl:value-of select="if (md:paramValue($this,'useDistinct')='true') then 'DISTINCT ' else ''"/>
	<xsl:value-of select="md:patternList($columns,'[expression] AS [workName]', ',\n\t')"/>

from	<xsl:value-of select="$REF/tech:fromPart($sourceSetName)"/>
where	(1=1)
<xsl:value-of select="$REF/tech:joinPart($sourceSetName)"/>
<xsl:value-of select="$REF/tech:filterPart($sourceSetName)"/>
<xsl:value-of select="$REF/tech:cdcFilterPart($sourceSetName)"/>
<xsl:value-of select="if ($REF/tech:hasCdc() and md:paramValue($this,'appendMode')='true') then '&#xa;And CDC_CHANGE_TYPE in (''I'',''D'')' else '' "/>	
<xsl:value-of select="$REF/tech:groupByPart($sourceSetName)"/>
<xsl:value-of select="$REF/tech:havingPart($sourceSetName)"/></set>
</xsl:for-each>
</xsl:variable>
<xsl:value-of select="md:resolveSetExpression($sets/set,$REF/@setExpression)"/>
<xsl:text>

</xsl:text><xsl:value-of select="if(md:paramValue($this,'useStageNameForTemporaryObjectName') = 'true')&#xa;&#x9;then md:setStagingPoint($REF/@id,concat('select * from ', $stageTableName),'query')&#xa;&#x9;else '' &#xa;"/><xsl:text>
</xsl:text></xsl:template><xsl:template name="initExecutionConditionLink__06b28e4f-bb20-41ac-93e5-049058863fd0"><xsl:text>${SqlToXml/XML_NB_ELEMENTS}$==0</xsl:text></xsl:template><xsl:template name="initVar_df2b174e-8ef2-4f86-80c6-f3d7e468f47d">
<xsl:apply-templates select="$REF/source/ref:target()/ancestor::wsdl" mode="analyzeDatastore">
<xsl:with-param name="filters" select="$REF/ref:fields()/ref:sources()/@id" tunnel="yes"/>
<xsl:with-param name="activeFilters" select="true()" tunnel="yes"/>
<xsl:with-param name="datastorePrefix" select="$REF/tech:workName()" tunnel="yes"/>
<xsl:with-param name="resetPosition" select="true()"/>
</xsl:apply-templates>
<xsl:text>

</xsl:text></xsl:template><xsl:template name="initVar_7f17ab02-3446-4a69-8f47-ab3d14b4985a">
<xsl:variable name="targetNullWOrd" select="$REF/ref:target()/tech:nullWord()"/>
<xsl:for-each select="$context//datastore">
<datastore name="{@name}" fullPath="{@fullPath}" physicalName="{md:objectPath($REF/ref:parent(),@name,'workName')}">
	<xsl:if test="position()>1">
		<field id="{@id}">
			<targetWritableType><xsl:value-of select="$REF/ref:target()/tech:numericDDL(10)"/></targetWritableType>
			<targetNullWord><xsl:value-of select="$targetNullWOrd"/></targetNullWord>
			<workName>stb_parentKey</workName>
		</field>
	</xsl:if>
	<field id="{@id}">
		<targetWritableType><xsl:value-of select="$REF/ref:target()/tech:numericDDL(10)"/></targetWritableType>
		<targetNullWord><xsl:value-of select="$targetNullWOrd"/></targetNullWord>
		<workName>stb_key</workName>
	</field>

	<xsl:variable name="position" select="position()"/>
	<xsl:for-each select="field">
			<xsl:variable name="current" select="."/>
			<xsl:variable name="id" select="@id"/>
				<xsl:for-each select="$REF/ref:fields()[ref:sources()/@id=current()/@id]">
					<field id="{$id}" fullPath="{$current/@fullPath}">
						<targetWritableType><xsl:value-of select="tech:targetWritableType()"/></targetWritableType>
						<targetNullWord><xsl:value-of select="$targetNullWOrd"/></targetNullWord>
						<workName><xsl:value-of select="tech:workName()"/></workName>
					</field>
				</xsl:for-each>
		</xsl:for-each>

</datastore>
</xsl:for-each>
</xsl:template><xsl:template name="initVar_9d4e71d3-0b2b-41aa-83e4-220f534b14a0">
<xsl:variable name="direction" select="$REF/ref:target()/ref:product()/tech:leftJoin()"/>
<xsl:variable name="useBracket" select="$REF/ref:target()/ref:product()/tech:hasExplicitJoinInBracket()"/>

<xsl:variable name="name" select="$REF/@name"/>
<xsl:variable name="fields" select="$REF/ref:fields()"/>
<xsl:variable name="targetSteps" select="$REF/ref:targetStep()"/>

<xsl:variable name="targetSteps" select="if ($useSubQuery) then $targetSteps else $REF"/>
<xsl:for-each select="$targetSteps">

	<xsl:variable name="current" select="."/>
	<xsl:variable name="useFields" select="if ($useSubQuery) then $REF/ref:fields('',$current) else $REF/ref:fields()"/>
	<xsl:variable name="useFieldsId" select="$useFields/ref:sources()/@id"/>
	<xsl:variable name="allDatastore" select="$context/descendant-or-self::datastore"/>
	<xsl:variable name="usedDatastore" select="if ($useSubQuery) then $allDatastore[./*/@id=$useFieldsId] else $allDatastore"/>
	<xsl:variable name="datastore" select="if ($useSubQuery) then $allDatastore[@id=$useFieldsId or .//@id=$useFieldsId] else $allDatastore"/>

<xsl:variable name="joins">
	<xsl:for-each select="$datastore">
	<xsl:sort select="position()" order="ascending"/>
		<xsl:if test="position()>1">
			<join id="{position()}">
				<expr><xsl:value-of select="$direction"/></expr>
				<right><xsl:value-of select="concat(md:objectPath($REF/ref:parent(),@name,'workName'),' ',$REF/ref:target()/tech:tableAliasWord(),' ',@name)"/></right>
				<left><xsl:value-of select="concat(md:objectPath($REF/ref:parent(),../@name,'workName'),' ',$REF/ref:target()/tech:tableAliasWord(),' ',../@name)"/></left>
				<on><xsl:value-of select="../@name"/>.stb_key=<xsl:value-of select="@name"/>.stb_parentKey</on>
			</join>
		</xsl:if>
	</xsl:for-each>
</xsl:variable>

<xsl:variable name="joins">
	<xsl:call-template name="rdbms:join">
		<xsl:with-param name="joins" select="$joins"/>
		<xsl:with-param name="bracket" select="$useBracket" tunnel="yes"/>
	</xsl:call-template>
</xsl:variable>
<xsl:variable name="from">
	<xsl:choose>
	<xsl:when test="count($datastore)>1">
		<xsl:copy-of select="$joins"/>
		
	</xsl:when>
	<xsl:otherwise>
	<xsl:value-of select="concat(md:objectPath($REF/ref:parent(),$datastore/@name,'workName'),' ',$REF/ref:target()/tech:tableAliasWord(),' ',$datastore/@name)"/>
	</xsl:otherwise>
	</xsl:choose>
</xsl:variable>

<query name="{@name}">
select <xsl:value-of select="if (md:paramValue($this,'useDistinct')='true') then 'DISTINCT ' else ''"/>
<xsl:value-of select="md:patternList($useFields,'[workName]', ',\n\t')"/>
from <xsl:value-of select="$from"/>
where (1=1)
<xsl:value-of select="if (md:paramValue($this,'disableFilterPart')='true') then '' else $REF/tech:filterPart()"/>
<xsl:value-of select="if(md:paramValue($this,'filterEmptyRecords')='true') then md:list($usedDatastore/concat(@name,'.stb_key is null'), ' and\n\t', 'and not(\n\t', ')') else ''"/>
<xsl:value-of select="$REF/tech:joinPart()"/>

</query>

</xsl:for-each>

</xsl:template><xsl:template name="initParameter_1a0ac6db-231f-402b-8b51-f300fca8a8aa"><xsl:value-of select="md:paramValue($this,'urlEncodedCharset')"/></xsl:template><xsl:template name="initParameter_9dfcc403-e8e8-48f6-b812-4917fee3f7ea"><xsl:value-of select="$REF/ref:target()/tech:proxyHost()"/></xsl:template><xsl:template name="initParameter_2aa6854a-d950-4ce4-bae8-6d38a7b5283d"><xsl:value-of select="$REF/ref:target()/tech:proxyPort()"/></xsl:template><xsl:template name="initParameter_d48d8733-0462-444c-a3eb-85e0786a2159"><xsl:value-of select="$REF/ref:target()/tech:proxyUser()"/></xsl:template><xsl:template name="initParameter_4646cd96-bf85-478b-a5ea-6493113dafbc"><xsl:value-of select="$REF/ref:target()/tech:proxyPassword()"/></xsl:template><xsl:template name="initParameter_e3d1d6a7-a310-46b0-9a70-db0e217f7ffb"><xsl:text>



operation.connection = javax.xml.soap.SOAPConnectionFactory.newInstance().createConnection()
	// Next, create the actual message
operation.message = javax.xml.soap.MessageFactory.newInstance().createMessage()

// Create objects for the message parts
operation.envelope=operation.message.getSOAPPart().getEnvelope()</xsl:text></xsl:template><xsl:template name="initParameter_66dfbcfa-729e-4921-9f91-1591b6ed9011"><xsl:value-of select="$REF/ref:target()/tech:keyStore()"/></xsl:template><xsl:template name="initParameter_6bdb4d4a-ae40-462d-9ce8-1330260f0d86"><xsl:value-of select="$REF/ref:target()/tech:keyStoreType()"/></xsl:template><xsl:template name="initParameter_97d5fb92-1c2b-42e1-a5b8-c1f1f9aa5084"><xsl:value-of select="$REF/ref:target()/tech:keyStorePassword()"/></xsl:template><xsl:template name="initParameter_40ab6a25-1cbe-4cae-9cb0-0ebbe25f32ed"><xsl:value-of select="$REF/ref:target()/tech:trustStore()"/></xsl:template><xsl:template name="initParameter_d400c2f8-cd21-4ad1-b29b-3248104ddc5a"><xsl:value-of select="$REF/ref:target()/tech:trustStoreType()"/></xsl:template><xsl:template name="initParameter_458233ff-cc53-44e2-8d9a-e108db0ba475"><xsl:value-of select="$REF/ref:target()/tech:trustStorePassword()"/></xsl:template><xsl:template name="initParameter_7a4bd38d-3bb6-4f8c-8836-ddcf591b4974"><xsl:value-of select="$REF/ref:target()/tech:user()"/></xsl:template><xsl:template name="initParameter_c87384c5-289e-4dc5-99b1-1ba6f62775b7"><xsl:value-of select="$REF/ref:target()/tech:password()"/></xsl:template><xsl:template name="initParameter_4a783796-3fec-42dc-9337-738c6c3e6337"><xsl:value-of select="md:ifEmpty(md:paramValue($this/..,'HTTP_HEADER_PARAMETERS'),$REF/ref:target()/tech:httpHeaderProperties())"/></xsl:template><xsl:template name="initParameter_f2bd0fa6-bddf-48f6-8585-93196c25345e"><xsl:value-of select="$REF/ref:target()/ref:wsse()/tech:username()"/></xsl:template><xsl:template name="initParameter_0f4b6586-3bfc-43ab-b2aa-48248c765808"><xsl:value-of select="$REF/ref:target()/ref:wsse()/tech:timeToLive()"/></xsl:template><xsl:template name="initParameter_f9731602-c584-4c6e-8b39-d232d8e845c8"><xsl:value-of select="$REF/ref:target()/ref:wsse()/tech:addsNonce()"/></xsl:template><xsl:template name="initParameter_324416f6-9111-49eb-baf3-cd4d260a84f6"><xsl:value-of select="$REF/ref:target()/ref:wsse()/tech:addsCreated()"/></xsl:template><xsl:template name="initParameter_6a84ea05-d258-434d-a0a4-c13a4c78f633"><xsl:value-of select="$REF/ref:target()/ref:wsse()/tech:password()"/></xsl:template><xsl:template name="initParameter_cc8a7b60-d18a-4d75-ac9e-42ccfa992f1b"><xsl:value-of select="$REF/ref:target()/ref:wsse()/tech:passwordType()"/></xsl:template><xsl:template name="initParameter_9b81aab8-f444-4467-9b6d-76974a2b8c97"><xsl:value-of select="$REF/ref:target()/ref:oauth2()/tech:accessToken()"/></xsl:template><xsl:template name="initParameter_cdf12329-de81-49b6-892f-32f2eabc4c20"><xsl:value-of select="$REF/ref:target()/ref:oauth2()/tech:refreshToken()"/></xsl:template><xsl:template name="initParameter_4b025021-b7ff-4c8f-994c-fd00bbce98c8"><xsl:value-of select="$REF/ref:target()/ref:oauth2()/tech:expiresIn()"/></xsl:template><xsl:template name="initParameter_74700f60-0210-42a5-8f8b-d673f4e84e6c"><xsl:value-of select="$REF/ref:target()/ref:oauth2()/tech:tokenEndpoint()"/></xsl:template><xsl:template name="initParameter_05556a5a-0868-48df-9303-833d929186d8"><xsl:value-of select="$REF/ref:target()/ref:oauth2()/tech:clientId()"/></xsl:template><xsl:template name="initParameter_0edcc080-1f95-4556-8cc9-31e8b859cec8"><xsl:value-of select="$REF/ref:target()/ref:oauth2()/tech:clientSecret()"/></xsl:template><xsl:template name="initParameter_ad02fd94-4f62-4de2-8428-48db48e5b98e"><xsl:value-of select="$REF/ref:target()/ref:oauth2()/tech:connectionTimeout()"/></xsl:template><xsl:template name="initParameter_c545a483-9945-4c54-9451-1808e54ed1d4"><xsl:value-of select="$REF/ref:target()/ref:oauth2()/tech:numberOfAttempts()"/></xsl:template><xsl:template name="initParameter_21f8d028-25a1-4b14-8de1-f7e1fd6a0f36"><xsl:value-of select="$REF/ref:target()/ref:oauth()/tech:consumerKey()"/></xsl:template><xsl:template name="initParameter_c5e85042-eb42-447e-893e-52b6e9ee9b89"><xsl:value-of select="$REF/ref:target()/ref:oauth()/tech:consumerSecret()"/></xsl:template><xsl:template name="initParameter_7a3bb45c-cff2-4638-9782-48e7cc4fba14"><xsl:value-of select="$REF/ref:target()/ref:oauth()/tech:signatureMethod()"/></xsl:template><xsl:template name="initParameter_d1e292e3-cb77-49af-af11-3fea5b4c74e5"><xsl:value-of select="$REF/ref:target()/ref:oauth()/tech:tokenSecret()"/></xsl:template><xsl:template name="initParameter_77f533dd-7d7c-4451-9054-82b5c07a9bf4"><xsl:value-of select="$REF/ref:target()/ref:oauth()/tech:token()"/></xsl:template><xsl:template name="initAction__RYi7v515EeSuxsIumQHgUQ"><xsl:text>use "</xsl:text><xsl:value-of select="$REF/ref:target()/ref:workSchema()/tech:catalogName()"/><xsl:text>"
</xsl:text></xsl:template><xsl:template name="initAction__RYi7tp15EeSuxsIumQHgUQ"><xsl:text>drop table </xsl:text><xsl:value-of select="@physicalName"/></xsl:template><xsl:template name="initParameter_8db0aea7-1d18-4d39-b977-a288ec680a8c"><xsl:value-of select="$fileName"/></xsl:template><xsl:template name="initExecutionConditionLink__e57be7ea-3492-42da-a053-6ec39fb41c38"><xsl:text>${TestFile/NB_FILES}$==0</xsl:text></xsl:template><xsl:template name="initAction__RYi7up15EeSuxsIumQHgUQ"><xsl:text>drop view </xsl:text><xsl:value-of select="$viewName"/></xsl:template><xsl:template name="initAction__VUNTDTgyEd-jwpjHwxWmmQ"><xsl:text>drop table </xsl:text><xsl:value-of select="@physicalName"/></xsl:template><xsl:template name="initAction__x2CFI0NJEeCcsKFd3RQ7Tg"><xsl:text>Delete 	from 	</xsl:text><xsl:value-of select="md:physicalPath($CDC,'cdcTableName')"/><xsl:text>
Where	CDC_CONSUMMATION = '1'
</xsl:text><xsl:value-of select="$CDC/tech:cdcFilterPart()"/></xsl:template><xsl:template name="initAction__VUNTHjgyEd-jwpjHwxWmmQ"><xsl:text>drop table  </xsl:text><xsl:value-of select="md:physicalPath($REF,'workName')"/></xsl:template><xsl:template name="initAction__w4b8wDRMEeSQ37GXUClEnA"><xsl:value-of select="if($REF/ref:target()/tech:dropTableIfExists()) then $REF/ref:target()/tech:dropTableIfExists($stageTableName) else concat('drop table ',$stageTableName)"/></xsl:template><xsl:template name="initAction__VUNTCDgyEd-jwpjHwxWmmQ">
create table <xsl:value-of select="@physicalName"/>
(
	<xsl:value-of select="md:patternList(field,'{workName}\t{targetWritableType} {targetNullWord}',',\n\t')"/>
)
<xsl:text>


</xsl:text></xsl:template><xsl:template name="initAction__VUNTEjgyEd-jwpjHwxWmmQ"><xsl:text>create view  </xsl:text><xsl:value-of select="$viewName"/><xsl:text>
as
</xsl:text><xsl:value-of select="$Query/query[1]"/></xsl:template><xsl:template name="initAction__oO96vgXbEd-3ZKnpc_AwVw"><xsl:text>&lt;sqlToXml:descriptor xmlns:sqlToXml="http://www.stambia.com/sqlToXml"&gt;
</xsl:text>

<xsl:variable name="sourceSets">
	<xsl:for-each select="($REF/tech:sourceSets())">
		<sourceSet name="{.}" distinct="{md:paramValue($this,'DISTINCT')}">
		<xsl:for-each select="$REF/ref:fields()[tech:sourceSet()=current() or (not(tech:sourceSet()!='')) and tech:onSrc()]">
			<field isKey="{tech:isUk()}" id="{ref:target()/@id}" alias="{replace(replace(tech:workName(),'-','_'),':','_')}" aliasWord="{tech:columnAliasWord()}" isAggregate="{tech:isAggregate()}" location="{tech:location()}" forceIsNillable="{if (tech:tag()='IS_NILLABLE') then 'true' else if (tech:tag()='IS_NOT_NILLABLE') then 'false' else ''}" sortOrder="{if (tech:tag()='SORT_ASC') then 'ASC' else if (tech:tag()='SORT_DESC' ) then 'DESC' else ''}"><xsl:value-of select="tech:expression()"/>
			<xsl:copy-of select="tag"/>
			<xsl:for-each select="./ref:froms()">
				<from><xsl:value-of select="tech:from()"/></from>
			</xsl:for-each>
			</field>
		</xsl:for-each>
		<xsl:if test=".!=''">
		<query>
			<xsl:choose>
			
				<xsl:when test="md:paramValue($this,'sourceSetOptimization')='manual'">
					<xsl:variable name="joins">
						<explicitJoins bracket="{$REF/ref:srcProduct()/tech:hasExplicitJoinInBracket()}">
						<xsl:call-template name="rdbms:fromPart">
							<xsl:with-param select="$REF" name="context"/>
							<xsl:with-param name="sourceSet" select="current()"/>
							<xsl:with-param name="mode" select="'NODE'"/>
						</xsl:call-template>
						</explicitJoins>
						<implicitJoins>
						<xsl:for-each select="$REF/ref:implicitJoin(current())">
							<join>
								<expr><xsl:value-of select="tech:implicitExpression()"/></expr>
								<xsl:for-each select="./ref:froms()">
										<from><xsl:value-of select="tech:from()"/></from>
								</xsl:for-each>
							</join>
						</xsl:for-each>
						</implicitJoins>
					</xsl:variable>
					<xsl:copy-of select="$joins"/>
					<xsl:for-each select="$REF/ref:froms()/tech:from()">
						<xsl:if test=".!=$joins//from">
							<from><xsl:value-of select="."/></from>
						</xsl:if>
					</xsl:for-each>
				</xsl:when>
				<xsl:otherwise>
					<from>
						<xsl:value-of select="$REF/tech:fromPart(current())"/>
					</from>
				</xsl:otherwise>
			</xsl:choose>	
		<where>
		<xsl:value-of select="$REF/tech:joinPart(current())"/>
		<xsl:value-of select="$REF/tech:filterPart(current())"/>
		<xsl:value-of select="$REF/tech:havingPart(current())"/>


		</where>
		</query>
		</xsl:if>
		</sourceSet>
	</xsl:for-each>
</xsl:variable>
	<xsl:apply-templates select="$sourceSets" mode="xmlToText"/>
	&lt;data&gt;
	<xsl:apply-templates select="$REF/ref:target()/ref:wsdl()" mode="xmlToText">
			<xsl:with-param name="filters" tunnel="yes">name()='md:ref' or (name()='httpHeaderProperties' and ../name()='operation')</xsl:with-param>
			<xsl:with-param name="indent" tunnel="yes"> </xsl:with-param>
			<xsl:with-param name="id" select="$REF/ref:target()/@id"/>
			<xsl:with-param name="useXmlForm" select="true()" tunnel="yes"/>
			
	</xsl:apply-templates>
	<xsl:apply-templates select="$REF/ref:target()/ref:namespace()" mode="xmlToText"/>
	&lt;/data&gt;

<xsl:text>
&lt;/sqlToXml:descriptor&gt;</xsl:text></xsl:template><xsl:template name="initExecutionConditionLink__fc328b3e-18cc-4756-8960-d10170b50fc2"><xsl:text>${TestFile/NB_FILES}$==1</xsl:text></xsl:template><xsl:template name="initAction__VUNTFTgyEd-jwpjHwxWmmQ"><xsl:text>drop view  </xsl:text><xsl:value-of select="$viewName"/></xsl:template><xsl:template name="initAction__RYi7sJ15EeSuxsIumQHgUQ"><xsl:text>drop view </xsl:text><xsl:value-of select="$viewName"/></xsl:template><xsl:template name="initAction__v9vt0ENJEeCcsKFd3RQ7Tg"><xsl:text>update 	</xsl:text><xsl:value-of select="md:physicalPath($CDC,'cdcTableName')"/><xsl:text>
set 	CDC_CONSUMMATION = '1'
where	(1=1)
</xsl:text><xsl:value-of select="$CDC/tech:cdcFilterPart()"/></xsl:template></xsl:stylesheet>