<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:mdj="java:com.indy.xsl.global.Functions" xmlns:fn="http://www.w3.org/2005/02/xpath-functions" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:mdv="java:com.indy.xsl.global.Variables" xmlns:md="http://www.stambia.org/md" xmlns:saxon="http://saxon.sf.net/" xmlns:proc="http://www.example.org/proc" xmlns:func="http://www.stambia.org/func" version="2.0" xmlns:UUID="java.util.UUID" exclude-result-prefixes="fn mdj mdv UUID md xsl " extension-element-prefixes="saxon">
	<xsl:output method="xml" encoding="UTF-8" cdata-section-elements="generationCondition executionCondition code step"/>
	<xsl:preserve-space elements="code CData"/>
	<xsl:param name="modeRepetitionLink">normal</xsl:param>
	<!--#### REPETITION_LINK ###"-->
	<xsl:template match="parameter/@id | metaDataLink/@id | altId/@id |  link/@originalTargetId  |  bindLink/@originalTargetId | bindLink/@targetIdTargetId | xslVariable/@id" mode="repetitionLink"/>
	<xsl:template match="*" mode="repetitionLink">
		<xsl:element name="{name()}">
			<xsl:apply-templates select="@*|node()" mode="repetitionLink"/>
		</xsl:element>
	</xsl:template>
	<xsl:template match="link | bindLink" mode="repetitionLink">
		<xsl:variable name="targetId" select="@originalTargetId"/>
		<xsl:variable name="this" select="."/>
		<xsl:variable name="repetitionTarget" select="../../*[altId[@value=$targetId and @origin='repetition']]"/>
		<xsl:choose>
			<xsl:when test="$repetitionTarget[@repetitionMode='Parallelize']">
				<!--Il faut répliquer le link autant de fois qu'il y a de cible //-->
				<!--l'action cible a été mise en altId il faut don cpointer sur le nouvel Id-->
				<xsl:for-each select="$repetitionTarget[@repetitionMode='Parallelize']">
					<xsl:element name="{$this/name()}">
						<xsl:apply-templates select="$this/@*[not(name()='id')]" mode="repetitionLink"/>
						<xsl:attribute name="id" select="concat('_',UUID:randomUUID())"/>
						<xsl:attribute name="targetId" select="@id"/>
						<xsl:apply-templates select="$this/node()" mode="repetitionLink"/>
					</xsl:element>
				</xsl:for-each>
			</xsl:when>
			<xsl:when test="$repetitionTarget[@repetitionMode='Sequential']">
				<!--Le link doit pointer sur le premier elt de la séquence-->
				<xsl:element name="{name()}">
					<xsl:apply-templates select="@*|node()" mode="repetitionLink"/>
					<xsl:attribute name="id" select="concat('_',UUID:randomUUID())"/>
					<xsl:attribute name="targetId" select="concat(@targetId,'_1')"/>
				</xsl:element>
			</xsl:when>
			<xsl:otherwise>
				<xsl:element name="{name()}">
					<xsl:apply-templates select="@*|node()" mode="repetitionLink"/>
					<xsl:attribute name="id" select="concat('_',UUID:randomUUID())"/>
				</xsl:element>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="@*" mode="repetitionLink">
		<xsl:copy/>
	</xsl:template>
	<xsl:template match="proc:process | subProcess" mode="repetitionLink">
		<!--sert à mettre les actions codes devant les subProcess car si deux étepr // par repetitionQuery à la suite alors il faut mettre une empty action entre elles-->
		<xsl:element name="{name()}">
			<xsl:apply-templates select="@*| link | bindLink | metaDataLink | parameter | altId " mode="repetitionLink"/>
			<xsl:apply-templates select="actionCode" mode="repetitionLink"/>
			<xsl:apply-templates select="actionCodeRef | actionProcessRef | subProcess | templateType | xslVariable | connection" mode="repetitionLink"/>
		</xsl:element>
	</xsl:template>
</xsl:stylesheet>
