REM echo off
REM #
REM # Copyright (c) Semarchy.  All rights reserved.
REM #
REM # PRODUCT Semarchy xDI Runtime
REM #   
REM #	This script initializes some of the variables that will be used in the startup scripts of the Runtime.
REM #	It will be executed at the beginning of the following scripts:
REM #		-	startcommand.bat
REM #		-	startdelivery.bat
REM #		-	startengine.bat / stopengine.bat
REM #

IF "%XDI_RUNTIME_HOME%" == "" (
   IF NOT "%XDI_RUNTIME%" == "" (
    SET "XDI_RUNTIME_HOME=%XDI_RUNTIME%"
  ) ELSE (
    IF NOT "%STAMBIA_HOME%" == "" (
      SET "XDI_RUNTIME_HOME=%STAMBIA_HOME%"
    )
  )
)
IF "%XDI_RUNTIME_HOME%" == "" (
  SET "XDI_RUNTIME_HOME=%~dp0"
)

IF %XDI_RUNTIME_HOME:~-1%==\ SET XDI_RUNTIME_HOME=%XDI_RUNTIME_HOME:~0,-1%

REM # Folder containing the Runtime configuration file (defaults the 'properties' folder that is inside the Runtime directory)
if "%XDI_RUNTIME_PROPERTIES_LOCATION%" == "" if not "%STAMBIA_PROPERTIES_LOCATION%" == "" (set "XDI_RUNTIME_PROPERTIES_LOCATION=%STAMBIA_PROPERTIES_LOCATION%") else set "XDI_RUNTIME_PROPERTIES_LOCATION=%XDI_RUNTIME_HOME%\properties"

REM # Path to the Runtime Configuration file (engineParameters.xml)
set "XDI_RUNTIME_CONF_FILE_LOCATION=%XDI_RUNTIME_PROPERTIES_LOCATION%\engineParameters.xml"
set XDI_RUNTIME_CONF_OPTION=-conf "%XDI_RUNTIME_CONF_FILE_LOCATION%"

set "XDI_RUNTIME_LIB_HOME=%XDI_RUNTIME_HOME%\lib"
set XDI_RUNTIME_CLASSPATH=.;"%XDI_RUNTIME_PROPERTIES_LOCATION%\."

set XDI_RUNTIME_BUILD_HOME=%XDI_RUNTIME_HOME%\build\lib
set XDI_RUNTIME_BUILD_CLASSPATH=%XDI_RUNTIME_CLASSPATH%;"%XDI_RUNTIME_BUILD_HOME%\ant-1.10.12.jar";"%XDI_RUNTIME_BUILD_HOME%\ant-launcher-1.10.12.jar";"%XDI_RUNTIME_BUILD_HOME%\saxon9b-9.1.0.8-extended.jar";"%XDI_RUNTIME_BUILD_HOME%\saxon-s9api-9.1.0.8b.jar";"%XDI_RUNTIME_BUILD_HOME%\ant-contrib-1.0b3.jar";"%XDI_RUNTIME_BUILD_HOME%\saxon-xpath-9.1.0.8.jar";"%XDI_RUNTIME_BUILD_HOME%\stax2-api-4.2.1.jar";"%XDI_RUNTIME_BUILD_HOME%\woodstox-core-6.4.0.jar";"%XDI_RUNTIME_BUILD_HOME%\saxon-jdom-9.1.0.8b.jar";"%XDI_RUNTIME_BUILD_HOME%\jsqlparser-4.5.jar";"%XDI_RUNTIME_BUILD_HOME%\com.indy.ant.jar";"%XDI_RUNTIME_BUILD_HOME%\com.indy.xsl.jar";"%XDI_RUNTIME_LIB_HOME%\indyEngineCoreModule.jar";"%XDI_RUNTIME_LIB_HOME%\core\indyEngineCore.jar";"%XDI_RUNTIME_LIB_HOME%\core\indyEngineShared.jar";"%XDI_RUNTIME_LIB_HOME%\internal\indyEngineCommon.jar";"%XDI_RUNTIME_LIB_HOME%\internal\indyEngine.jar";"%XDI_RUNTIME_LIB_HOME%\core\j11\jakarta.xml.bind-api-2.3.3.jar";"%XDI_RUNTIME_LIB_HOME%\internal\HikariCP-4.0.3.jar";"%XDI_RUNTIME_LIB_HOME%\internal\guava-32.0.1-jre.jar";"%XDI_RUNTIME_LIB_HOME%\core\log4j-api-2.17.2.jar";"%XDI_RUNTIME_LIB_HOME%\core\log4j-core-2.17.2.jar";"%XDI_RUNTIME_LIB_HOME%\core\log4j-jul-2.17.2.jar";"%XDI_RUNTIME_LIB_HOME%\internal\failureaccess-1.0.1.jar";"%XDI_RUNTIME_BUILD_HOME%\org.eclipse.osgi.jar";"%XDI_RUNTIME_BUILD_HOME%\com.semarchy.xdi.designer.core.jar"


REM ###
REM # Additional Java Virtual Machine properties (usually set with -Dmyoption=myvalue)
REM # You can add multiple properties by separating them with a space character
REM ###

REM # Java Properties to be added in the Runtime startup and stop script (startengine.bat / stopengine.bat)
set XDI_RUNTIME_STARTENGINE_VM_PROPERTIES=-Dxdi.runtime.client.configuration.file.path="%XDI_RUNTIME_PROPERTIES_LOCATION%\xdi-runtime-client-configuration.xml"

REM # Java Properties to be added in the startdelivery script (startdelivery.bat)
set XDI_RUNTIME_STARTDELIVERY_VM_PROPERTIES=

REM # Java Properties to be added in the startcommand script (startcommand.bat)
set XDI_RUNTIME_STARTCOMMAND_VM_PROPERTIES=-Dxdi.runtime.client.configuration.file.path="%XDI_RUNTIME_PROPERTIES_LOCATION%\xdi-runtime-client-configuration.xml"

REM # Java Properties to be added in all the Runtime scripts (startengine.bat / stopengine.bat, startdelivery.bat and startcommand.bat)
set XDI_RUNTIME_VM_PROPERTIES=-XX:+DisableAttachMechanism -Djava.net.preferIPv4Stack=true -Djava.util.logging.manager=org.apache.logging.log4j.jul.LogManager -Dcom.indy.engine.installation.folder="%XDI_RUNTIME_HOME%"

set xdiRuntimeClassLoader=1
if "%xdiRuntimeClassLoader%" == "0" GOTO JAVACLASSPATH

set XDI_RUNTIME_CLASSPATH=%XDI_RUNTIME_CLASSPATH%;"%XDI_RUNTIME_LIB_HOME%\indyEngineLauncher.jar";"%XDI_RUNTIME_LIB_HOME%\indyEngineCoreModule.jar"
set "XDI_RUNTIME_CORE=%XDI_RUNTIME_LIB_HOME%\core\**\*.jar"
set "XDI_RUNTIME_INTERNAL=%XDI_RUNTIME_LIB_HOME%\internal\*.jar"
set "XDI_RUNTIME_MODULES_PATH=%XDI_RUNTIME_HOME%\modules"
set XDI_RUNTIME_SYSTEM_CLASSLOADER=-Djava.system.class.loader.disable=com.indy.engine.StambiaSystemClassLoader -Dstambia.default.classpath.name=common -Dstambia.classpath.v1.core="%XDI_RUNTIME_CORE%";"%XDI_RUNTIME_MODULES_PATH%\core\*.jar" -Dstambia.classpath.v1.internal="%XDI_RUNTIME_INTERNAL%" -Dxdi.designer.module.path.v1="%XDI_RUNTIME_MODULES_PATH%"
GOTO ENDCLASSPATH

:JAVACLASSPATH


set SETPATH_BAT=%XDI_RUNTIME_HOME%\setpath.bat


for /R "%~dp0\lib" %%i in (*.zip *.jar *.dll) do call "%SETPATH_BAT%" "%%~si"

:ENDCLASSPATH

set SECURITY_PROPS=-Djava.security.policy="%XDI_RUNTIME_PROPERTIES_LOCATION%\security.policy"
set SCHEDULE_PROPS=-Dorg.quartz.properties="%XDI_RUNTIME_PROPERTIES_LOCATION%\engineScheduler.properties"

set DEPRECATED_VARIABLE=WARNING : you are using a deprecated variable :
set VARIABLE_TO_USE=You should use XDI_RUNTIME_OPTS or XDI_COMMAND_OPTS instead.

IF NOT defined XDI_RUNTIME_OPTS (
    set "XDI_RUNTIME_OPTS="
)
IF NOT defined XDI_COMMAND_OPTS (
  set "XDI_COMMAND_OPTS="
)

  IF "%XDI_RUNTIME_INIT_MEMORY%" == "" (
    IF NOT "%STAMBIA_INIT_MEMORY%" == "" (
        SET XDI_RUNTIME_OPTS=%XDI_RUNTIME_OPTS% -Xms%STAMBIA_INIT_MEMORY%
        SET XDI_COMMAND_OPTS=%XDI_COMMAND_OPTS% -Xms%STAMBIA_INIT_MEMORY%
        echo %DEPRECATED_VARIABLE% STAMBIA_INIT_MEMORY. %VARIABLE_TO_USE%
    )
  ) ELSE (
    SET XDI_RUNTIME_OPTS=%XDI_RUNTIME_OPTS% -Xms%XDI_RUNTIME_INIT_MEMORY%
    SET XDI_COMMAND_OPTS=%XDI_COMMAND_OPTS% -Xms%XDI_RUNTIME_INIT_MEMORY%
    echo %DEPRECATED_VARIABLE% XDI_RUNTIME_INIT_MEMORY. %VARIABLE_TO_USE%
  )
  IF "%XDI_RUNTIME_MAX_MEMORY%" == "" (
    IF NOT "%STAMBIA_MAX_MEMORY%" == "" (
        SET XDI_RUNTIME_OPTS=%XDI_RUNTIME_OPTS% -Xmx%STAMBIA_MAX_MEMORY%
        SET XDI_COMMAND_OPTS=%XDI_COMMAND_OPTS% -Xmx%STAMBIA_MAX_MEMORY%
        echo %DEPRECATED_VARIABLE% STAMBIA_MAX_MEMORY. %VARIABLE_TO_USE%
    )
  ) ELSE (
    SET XDI_RUNTIME_OPTS=%XDI_RUNTIME_OPTS% -Xmx%XDI_RUNTIME_MAX_MEMORY%
    SET XDI_COMMAND_OPTS=%XDI_COMMAND_OPTS% -Xmx%XDI_RUNTIME_MAX_MEMORY%
    echo %DEPRECATED_VARIABLE% XDI_RUNTIME_MAX_MEMORY. %VARIABLE_TO_USE%
  )
  IF "%XDI_RUNTIME_STACK_SIZE%" == "" (
    IF NOT "%STAMBIA_STACK_SIZE%" == "" (
        SET XDI_RUNTIME_OPTS=%XDI_RUNTIME_OPTS% -Xss%STAMBIA_STACK_SIZE%
        SET XDI_COMMAND_OPTS=%XDI_COMMAND_OPTS% -Xss%STAMBIA_STACK_SIZE%
        echo %DEPRECATED_VARIABLE% STAMBIA_STACK_SIZE. %VARIABLE_TO_USE%
    )
  ) ELSE (
    SET XDI_RUNTIME_OPTS=%XDI_RUNTIME_OPTS% -Xss%XDI_RUNTIME_STACK_SIZE%
    SET XDI_COMMAND_OPTS=%XDI_COMMAND_OPTS% -Xss%XDI_RUNTIME_STACK_SIZE%
    echo %DEPRECATED_VARIABLE% XDI_RUNTIME_STACK_SIZE. %VARIABLE_TO_USE%
  )

if NOT "%STAMBIA_JAVA_HOME%" == "" GOTO LEGACY
if "%JAVA_HOME%" == "" GOTO DEFAULT

:NORMAL
set XDI_RUNTIME_JAVA_EXE="%JAVA_HOME%\bin\java.exe"
set XDI_RUNTIME_JAVA_EXE_WITHOUT_QUOTE=%JAVA_HOME%\bin\java.exe
GOTO END

:DEFAULT
set XDI_RUNTIME_JAVA_EXE="java.exe"
set XDI_RUNTIME_JAVA_EXE_WITHOUT_QUOTE=java.exe
GOTO END

:LEGACY
set XDI_RUNTIME_JAVA_EXE="%STAMBIA_JAVA_HOME%\bin\java.exe"
set XDI_RUNTIME_JAVA_EXE_WITHOUT_QUOTE=%STAMBIA_JAVA_HOME%\bin\java.exe

:END

REM # Update XDI_RUNTIME_VM_PROPERTIES according to java major version

set "JDK_JAVA_OPTIONS=%JDK_JAVA_OPTIONS% --add-opens=java.base/java.net=ALL-UNNAMED"
set "JDK_JAVA_OPTIONS=%JDK_JAVA_OPTIONS% --add-opens=java.base/java.lang=ALL-UNNAMED"
set "JDK_JAVA_OPTIONS=%JDK_JAVA_OPTIONS% --add-opens=java.base/java.io=ALL-UNNAMED"
set "JDK_JAVA_OPTIONS=%JDK_JAVA_OPTIONS% --add-opens=java.base/java.util=ALL-UNNAMED"
set "JDK_JAVA_OPTIONS=%JDK_JAVA_OPTIONS% --add-opens=java.base/java.util.concurrent=ALL-UNNAMED"

