#!/bin/bash
#
# Copyright (c) Semarchy.  All rights reserved.
#
# PRODUCT Semarchy xDI Runtime
#   
#	This script initializes some of the variables that will be used in the startup scripts of the Runtime.
#	It will be executed at the beginning of the following scripts:
#		-	startcommand.sh
#		-	startdelivery.sh
#		-	startengine.sh / stopengine.sh
#

if [ "$XDI_RUNTIME_HOME" = "" ]; then
	if [ "$XDI_RUNTIME" != "" ]; then 
		XDI_RUNTIME_HOME=$XDI_RUNTIME
		export XDI_RUNTIME_HOME
	elif [ "$STAMBIA_HOME" != "" ]; then
	  	XDI_RUNTIME_HOME=$STAMBIA_HOME
	  	export XDI_RUNTIME_HOME
	fi
fi

if [ "$XDI_RUNTIME_HOME" = "" ]; then
        sp0=$(CDPATH= cd -- "$(dirname -- "$0")" && pwd)
        XDI_RUNTIME_HOME=$sp0
        export XDI_RUNTIME_HOME
fi

# Folder containing the Runtime configuration file (defaults the 'properties' folder that is inside the Runtime directory)
if [ "$XDI_RUNTIME_PROPERTIES_LOCATION" = "" ]; then
        if [ "$STAMBIA_PROPERTIES_LOCATION" = "" ]; then
                XDI_RUNTIME_PROPERTIES_LOCATION=$XDI_RUNTIME_HOME/properties
        else
                XDI_RUNTIME_PROPERTIES_LOCATION=$STAMBIA_PROPERTIES_LOCATION
        fi
        export XDI_RUNTIME_PROPERTIES_LOCATION
fi

# Path to the Runtime Configuration file (engineParameters.xml)
XDI_RUNTIME_CONF_FILE_LOCATION=$XDI_RUNTIME_PROPERTIES_LOCATION/engineParameters.xml
export XDI_RUNTIME_CONF_FILE_LOCATION

XDI_RUNTIME_LIB_HOME=$XDI_RUNTIME_HOME/lib
XDI_RUNTIME_CLASSPATH=".:$XDI_RUNTIME_PROPERTIES_LOCATION/."

XDI_RUNTIME_BUILD_HOME=$XDI_RUNTIME_HOME/build/lib
XDI_RUNTIME_BUILD_CLASSPATH="$XDI_RUNTIME_CLASSPATH:$XDI_RUNTIME_BUILD_HOME/ant-1.10.12.jar:$XDI_RUNTIME_BUILD_HOME/ant-launcher-1.10.12.jar:$XDI_RUNTIME_BUILD_HOME/saxon9b-9.1.0.8-extended.jar:$XDI_RUNTIME_BUILD_HOME/saxon-s9api-9.1.0.8b.jar:$XDI_RUNTIME_BUILD_HOME/ant-contrib-1.0b3.jar:$XDI_RUNTIME_BUILD_HOME/saxon-xpath-9.1.0.8.jar:$XDI_RUNTIME_BUILD_HOME/stax2-api-4.2.1.jar:$XDI_RUNTIME_BUILD_HOME/woodstox-core-6.4.0.jar:$XDI_RUNTIME_BUILD_HOME/saxon-jdom-9.1.0.8b.jar:$XDI_RUNTIME_BUILD_HOME/jsqlparser-4.5.jar:$XDI_RUNTIME_BUILD_HOME/com.indy.ant.jar:$XDI_RUNTIME_BUILD_HOME/com.indy.xsl.jar:$XDI_RUNTIME_LIB_HOME/core/indyEngineCore.jar:$XDI_RUNTIME_LIB_HOME/core/indyEngineShared.jar:$XDI_RUNTIME_LIB_HOME/internal/indyEngineCommon.jar:$XDI_RUNTIME_LIB_HOME/internal/indyEngine.jar:$XDI_RUNTIME_LIB_HOME/indyEngineCoreModule.jar:$XDI_RUNTIME_LIB_HOME/core/j11/jakarta.xml.bind-api-2.3.3.jar:$XDI_RUNTIME_LIB_HOME/internal/guava-32.0.1-jre.jar:$XDI_RUNTIME_LIB_HOME/internal/failureaccess-1.0.1.jar:$XDI_RUNTIME_LIB_HOME/internal/HikariCP-4.0.3.jar:$XDI_RUNTIME_LIB_HOME/core/log4j-api-2.17.2.jar:$XDI_RUNTIME_LIB_HOME/core/log4j-core-2.17.2.jar:$XDI_RUNTIME_LIB_HOME/core/log4j-jul-2.17.2.jar:$XDI_RUNTIME_BUILD_HOME/org.eclipse.osgi.jar:$XDI_RUNTIME_BUILD_HOME/com.semarchy.xdi.designer.core.jar"

###
# Additional Java Virtual Machine properties (usually set with -Dmyoption=myvalue)
# You can add multiple properties by separating them with a space character
###

# Java Properties to be added in the Runtime startup and stop scripts (startengine.sh / stopengine.sh)
XDI_RUNTIME_STARTENGINE_VM_PROPERTIES="-Dxdi.runtime.client.configuration.file.path=$XDI_RUNTIME_PROPERTIES_LOCATION/xdi-runtime-client-configuration.xml"

# Java Properties to be added in the startcommand script (startcommand.sh)
XDI_RUNTIME_STARTCOMMAND_VM_PROPERTIES="-Dxdi.runtime.client.configuration.file.path=$XDI_RUNTIME_PROPERTIES_LOCATION/xdi-runtime-client-configuration.xml"

# Java Properties to be added in all the Runtime scripts (startengine.sh / stopengine.sh, startdelivery.sh and startcommand.sh)
XDI_RUNTIME_VM_PROPERTIES=(
	-XX:+DisableAttachMechanism
	-Djava.net.preferIPv4Stack=true
	-Djava.util.logging.manager=org.apache.logging.log4j.jul.LogManager
	"-Dcom.indy.engine.installation.folder=$XDI_RUNTIME_HOME"
)


# set this variable to 1 for enabling STAMBIA CLASS LOADING
xdiRuntimeClassLoader=1
if [ $xdiRuntimeClassLoader -eq 1 ]; then

XDI_RUNTIME_CLASSPATH="$XDI_RUNTIME_CLASSPATH:$XDI_RUNTIME_LIB_HOME/indyEngineLauncher.jar:$XDI_RUNTIME_LIB_HOME/indyEngineCoreModule.jar"
XDI_RUNTIME_CORE=$XDI_RUNTIME_LIB_HOME/core/**/*.jar
XDI_RUNTIME_INTERNAL=$XDI_RUNTIME_LIB_HOME/internal/*.jar
XDI_RUNTIME_MODULES_PATH=$XDI_RUNTIME_HOME/modules
XDI_RUNTIME_SYSTEM_CLASSLOADER="-Djava.system.class.loader.disable=com.indy.engine.StambiaSystemClassLoader -Dstambia.default.classpath.name=common"
XDI_RUNTIME_INIT_CLASSPATH_OPTION="-Dstambia.classpath.v1.internal=$XDI_RUNTIME_INTERNAL"
XDI_RUNTIME_CORE_CLASSPATH_OPTION="-Dstambia.classpath.v1.core=$XDI_RUNTIME_CORE;$XDI_RUNTIME_MODULES_PATH/core/*.jar"
XDI_RUNTIME_MODULES_PATH_OPTION="-Dxdi.designer.module.path.v1=$XDI_RUNTIME_MODULES_PATH"

else 

#
# Dynamic construction of the JDBC classpath
# To use a driver, you simply have to copy it to the drivers directory and
# it is automatically added to the classpath
#
XDI_RUNTIME_CLASSPATH=$XDI_RUNTIME_CLASSPATH:$XDI_RUNTIME_HOME/drivers/.
#XDI_RUNTIME_LIB_EXCLUDE_FOLDER=$XDI_RUNTIME_HOME/lib/dynamic
# add option -path $XDI_RUNTIME_LIB_EXCLUDE_FOLDER to avoid a folder
for i in `find $XDI_RUNTIME_HOME/lib/ \( -name \*.jar -o -name \*.zip \)`;
	do
		XDI_RUNTIME_CLASSPATH=$XDI_RUNTIME_CLASSPATH:$i
	done

#for i in $XDI_RUNTIME_HOME/lib/scripting/groovy/*.jar; do
#  XDI_RUNTIME_CLASSPATH=$XDI_RUNTIME_CLASSPATH:$i
#done
#for i in $XDI_RUNTIME_HOME/lib/scripting/*.zip; do
#  XDI_RUNTIME_CLASSPATH=$XDI_RUNTIME_CLASSPATH:$i
#done
#for i in $XDI_RUNTIME_HOME/lib/scripting/*.jar; do
#  XDI_RUNTIME_CLASSPATH=$XDI_RUNTIME_CLASSPATH:$i
#done
#for i in $XDI_RUNTIME_HOME/lib/jdbc/*.zip; do
#  XDI_RUNTIME_CLASSPATH=$XDI_RUNTIME_CLASSPATH:$i
#done
#for i in $XDI_RUNTIME_HOME/lib/jdbc/*.jar; do
#  XDI_RUNTIME_CLASSPATH=$XDI_RUNTIME_CLASSPATH:$i
#done
#for i in $XDI_RUNTIME_HOME/lib/comdcom/*.zip; do
#  XDI_RUNTIME_CLASSPATH=$XDI_RUNTIME_CLASSPATH:$i
#done
#for i in $XDI_RUNTIME_HOME/lib/comdcom/*.jar; do
#  XDI_RUNTIME_CLASSPATH=$XDI_RUNTIME_CLASSPATH:$i
#done
#for i in $XDI_RUNTIME_HOME/lib/special/*.zip; do
#  XDI_RUNTIME_CLASSPATH=$XDI_RUNTIME_CLASSPATH:$i
#done
#for i in $XDI_RUNTIME_HOME/lib/special/*.jar; do
#  XDI_RUNTIME_CLASSPATH=$XDI_RUNTIME_CLASSPATH:$i
#done
#for i in $XDI_RUNTIME_HOME/lib/communication/*.zip; do
#  XDI_RUNTIME_CLASSPATH=$XDI_RUNTIME_CLASSPATH:$i
#done
#for i in $XDI_RUNTIME_HOME/lib/communication/*.jar; do
#  XDI_RUNTIME_CLASSPATH=$XDI_RUNTIME_CLASSPATH:$i
#done
#for i in $XDI_RUNTIME_HOME/lib/global/*.zip; do
#  XDI_RUNTIME_CLASSPATH=$XDI_RUNTIME_CLASSPATH:$i
#done
#for i in $XDI_RUNTIME_HOME/lib/global/*.jar; do
#  XDI_RUNTIME_CLASSPATH=$XDI_RUNTIME_CLASSPATH:$i
#done
#for i in $XDI_RUNTIME_HOME/lib/*.zip; do
#  XDI_RUNTIME_CLASSPATH=$XDI_RUNTIME_CLASSPATH:$i
#done
#for i in $XDI_RUNTIME_HOME/lib/*.jar; do
#  XDI_RUNTIME_CLASSPATH=$XDI_RUNTIME_CLASSPATH:$i
#done

fi

DEPRECATED_VARIABLE="WARNING : you are using a deprecated variable :"
VARIABLE_TO_USE="You should use XDI_RUNTIME_OPTS or XDI_COMMAND_OPTS instead."

XDI_RUNTIME_CLASSPATH=$XDI_RUNTIME_CLASSPATH:.

SECURITY_PROPS="-Djava.security.policy=$XDI_RUNTIME_PROPERTIES_LOCATION/security.policy"
SCHEDULE_PROPS="-Dorg.quartz.properties=$XDI_RUNTIME_PROPERTIES_LOCATION/engineScheduler.properties"

if [ "$XDI_RUNTIME_INIT_MEMORY" = "" ]; then
        if [ "$STAMBIA_INIT_MEMORY"  != "" ]; then
                XDI_RUNTIME_OPTS="${XDI_RUNTIME_OPTS} -Xms$STAMBIA_INIT_MEMORY"
                XDI_COMMAND_OPTS="${XDI_COMMAND_OPTS} -Xms$STAMBIA_INIT_MEMORY"
                echo "$DEPRECATED_VARIABLE STAMBIA_INIT_MEMORY. $VARIABLE_TO_USE"
        fi
else
        XDI_RUNTIME_OPTS="${XDI_RUNTIME_OPTS} -Xms$XDI_RUNTIME_INIT_MEMORY"
        XDI_COMMAND_OPTS="${XDI_COMMAND_OPTS} -Xms$XDI_RUNTIME_INIT_MEMORY"
        echo "$DEPRECATED_VARIABLE XDI_RUNTIME_INIT_MEMORY. $VARIABLE_TO_USE"
fi

if [ "$XDI_RUNTIME_MAX_MEMORY" = "" ]; then
        if [ "$STAMBIA_MAX_MEMORY"  != "" ]; then
                XDI_RUNTIME_OPTS="${XDI_RUNTIME_OPTS} -Xmx$STAMBIA_MAX_MEMORY"
                XDI_COMMAND_OPTS="${XDI_COMMAND_OPTS} -Xmx$STAMBIA_MAX_MEMORY"
                echo "$DEPRECATED_VARIABLE STAMBIA_MAX_MEMORY. $VARIABLE_TO_USE"
        fi
else
        XDI_RUNTIME_OPTS="${XDI_RUNTIME_OPTS} -Xmx$XDI_RUNTIME_MAX_MEMORY"
        XDI_COMMAND_OPTS="${XDI_COMMAND_OPTS} -Xmx$XDI_RUNTIME_MAX_MEMORY"
        echo "$DEPRECATED_VARIABLE XDI_RUNTIME_MAX_MEMORY. $VARIABLE_TO_USE"
fi

if [ "$XDI_RUNTIME_STACK_SIZE" = "" ]; then
        if [ "$STAMBIA_STACK_SIZE"  != "" ]; then
        XDI_RUNTIME_OPTS="${XDI_RUNTIME_OPTS} -Xss$STAMBIA_STACK_SIZE"
        XDI_COMMAND_OPTS="${XDI_COMMAND_OPTS} -Xss$STAMBIA_STACK_SIZE"
        echo "$DEPRECATED_VARIABLE STAMBIA_STACK_SIZE. $VARIABLE_TO_USE"
        fi
else
        XDI_RUNTIME_OPTS="${XDI_RUNTIME_OPTS} -Xss$XDI_RUNTIME_STACK_SIZE"
        XDI_COMMAND_OPTS="${XDI_COMMAND_OPTS} -Xss$XDI_RUNTIME_STACK_SIZE"
        echo "$DEPRECATED_VARIABLE XDI_RUNTIME_STACK_SIZE. $VARIABLE_TO_USE"

fi

# Add the JAVA 9 specific start-up parameters
JDK_JAVA_OPTIONS="$JDK_JAVA_OPTIONS --add-opens=java.base/java.net=ALL-UNNAMED"
JDK_JAVA_OPTIONS="$JDK_JAVA_OPTIONS --add-opens=java.base/java.lang=ALL-UNNAMED"
JDK_JAVA_OPTIONS="$JDK_JAVA_OPTIONS --add-opens=java.base/java.io=ALL-UNNAMED"
JDK_JAVA_OPTIONS="$JDK_JAVA_OPTIONS --add-opens=java.base/java.util=ALL-UNNAMED"
JDK_JAVA_OPTIONS="$JDK_JAVA_OPTIONS --add-opens=java.base/java.util.concurrent=ALL-UNNAMED"
export JDK_JAVA_OPTIONS

export SCHEDULE_PROPS
export SECURITY_PROPS 
export XDI_RUNTIME_CLASSPATH
export XDI_RUNTIME_BUILD_CLASSPATH
export XDI_RUNTIME_OPTS
export XDI_COMMAND_OPTS
export XDI_RUNTIME_STARTENGINE_VM_PROPERTIES
export XDI_RUNTIME_STARTDELIVERY_VM_PROPERTIES
export XDI_RUNTIME_STARTCOMMAND_VM_PROPERTIES
export XDI_RUNTIME_VM_PROPERTIES
