echo off
REM #
REM # Copyright (c) Semarchy.  All rights reserved.
REM #
REM # PRODUCT
REM #   Semarchy xDI Runtime - Installing as a service
REM #

REM # use installEngineAsService -i to install the service
REM # use installEngineAsService -r to remove the service
REM # you can modify parameters in the xdi-runtime-service.conf file in the 'external\windows-service\conf' folder.

call initvariables.bat

IF "%~1"=="" GOTO USAGE
IF "%~1"=="usage" GOTO USAGE
IF "%~1"=="-iold" GOTO IOLD
IF "%~1"=="-rold" GOTO ROLD
IF "%~1"=="-r" set MODE=-r
IF "%~1"=="-i" set MODE=-i
IF "%MODE%"=="" GOTO USAGE

REM set XDI_RUNTIME_WRAPPER_CONF_FILE=stambiaEngineOld.conf
set XDI_RUNTIME_WRAPPER_CONF_FILE=xdi-runtime-service.conf
set XDI_RUNTIME_WRAPPER_HOME=%~dp0\external\windows-service
set XDI_RUNTIME_WRAPPER_CONF="%XDI_RUNTIME_WRAPPER_HOME%\conf\%XDI_RUNTIME_WRAPPER_CONF_FILE%"
set XDI_RUNTIME_WRAPPER_BAT=%XDI_RUNTIME_WRAPPER_HOME%\bat\setenv.bat
set XDI_RUNTIME_ENGINE_NAME=%~2
IF "%XDI_RUNTIME_ENGINE_NAME%" == ""   set XDI_RUNTIME_ENGINE_NAME=Semarchy xDI Runtime
IF NOT "%~3" == "" set XDI_RUNTIME_CONF_FILE_LOCATION=%~3
set DESCRIPTION=%XDI_RUNTIME_ENGINE_NAME%
IF NOT "%~4" == "" set DESCRIPTION=%~4

REM ================================
REM ==== Additional properties =====
REM ================================

set WRAPPER_ADDITIONAL_INCREMENT=wrapper.java.additional.10

REM define additional properties for XDI_RUNTIME_STARTENGINE_VM_PROPERTIES if not empty
set WRAPPER_XDI_RUNTIME_STARTENGINE_VM_PROPERTIES=
IF NOT "%XDI_RUNTIME_STARTENGINE_VM_PROPERTIES%" == "" (
	set WRAPPER_XDI_RUNTIME_STARTENGINE_VM_PROPERTIES=-D%WRAPPER_ADDITIONAL_INCREMENT%="%XDI_RUNTIME_STARTENGINE_VM_PROPERTIES%"
)

REM define additional properties for XDI_RUNTIME_VM_PROPERTIES if not empty
set WRAPPER_XDI_RUNTIME_VM_PROPERTIES=
set WRAPPER_ADDITIONAL=wrapper.java.additional.

REM define additional properties for XDI_RUNTIME_OPTS if not empty
set WRAPPER_XDI_RUNTIME_OPTS=


set /a increment=11

IF NOT "%XDI_RUNTIME_VM_PROPERTIES%" == "" (
	set temporaryVariable=%XDI_RUNTIME_VM_PROPERTIES%
	
	:RUNTIME_VM_PROPERTIES_LOOP
	FOR /f "tokens=1*" %%a IN ("%temporaryVariable%") DO (
		set WRAPPER_XDI_RUNTIME_VM_PROPERTIES=%WRAPPER_XDI_RUNTIME_VM_PROPERTIES% -D%WRAPPER_ADDITIONAL%%increment%="%%a"
		set temporaryVariable=%%b
		set /a increment+=1
	)
	IF defined temporaryVariable GOTO :RUNTIME_VM_PROPERTIES_LOOP
)

IF NOT "%XDI_RUNTIME_OPTS%" == "" (
	set temporaryVariable=%XDI_RUNTIME_OPTS%
	
	:RUNTIME_OPTS_LOOP
	FOR /f "tokens=1*" %%a IN ("%temporaryVariable%") DO (
		set WRAPPER_XDI_RUNTIME_OPTS=%WRAPPER_XDI_RUNTIME_OPTS% -D%WRAPPER_ADDITIONAL%%increment%="%%a"
		set temporaryVariable=%%b
		set /a increment+=1
	)
	IF defined temporaryVariable GOTO :RUNTIME_OPTS_LOOP
)


REM ================================

echo %XDI_RUNTIME_ENGINE_NAME%
echo %XDI_RUNTIME_CONF_FILE_LOCATION%
echo %XDI_RUNTIME_WRAPPER_CONF_FILE%
echo %XDI_RUNTIME_WRAPPER_CONF%
echo %XDI_RUNTIME_WRAPPER_ENV%

call "%XDI_RUNTIME_WRAPPER_BAT%"

echo %java_exe% %wrapper_java_options% -jar %wrapper_jar% %1 %2 %3 %4 %5 %6
%java_exe% %wrapper_java_options% -Dwrapper.working.dir="%~dp0." -Dwrapper.java.command="%XDI_RUNTIME_JAVA_EXE_WITHOUT_QUOTE%" -Dwrapper.java.additional.1="%SCHEDULE_PROPS%" -Dwrapper.java.additional.2="%SECURITY_PROPS%" -Dwrapper.java.additional.3="-Dstambia.default.classpath.name=common" -Dwrapper.java.additional.4="-Dstambia.classpath.v1.core=%XDI_RUNTIME_CORE%;%XDI_RUNTIME_MODULES_PATH%\core\*.jar" -Dwrapper.java.additional.5="-Dstambia.classpath.v1.internal=%XDI_RUNTIME_INTERNAL%" -Dwrapper.java.additional.6="-Dxdi.designer.module.path.v1=%XDI_RUNTIME_MODULES_PATH%" -Dwrapper.ntservice.name="%XDI_RUNTIME_ENGINE_NAME%" -Dwrapper.ntservice.displayname="%XDI_RUNTIME_ENGINE_NAME%" -Dwrapper.ntservice.description="%DESCRIPTION%" -Dwrapper.java.classpath.4="%XDI_RUNTIME_PROPERTIES_LOCATION%/" -Dwrapper.app.parameter.1="-mainclass" -Dwrapper.app.parameter.2="com.indy.engine.EngineStartI" -Dwrapper.app.parameter.3="-conf" -Dwrapper.app.parameter.4="%XDI_RUNTIME_CONF_FILE_LOCATION%" %WRAPPER_XDI_RUNTIME_STARTENGINE_VM_PROPERTIES% %WRAPPER_XDI_RUNTIME_VM_PROPERTIES% %WRAPPER_XDI_RUNTIME_OPTS% -jar %wrapper_jar% %MODE% %XDI_RUNTIME_WRAPPER_CONF%

pause
GOTO END

:IOLD
set MODE=-i
GOTO OLD
:ROLD
set MODE=-r
:OLD
echo OLD MODE
set XDI_RUNTIME_WRAPPER_CONF_FILE=xdi-runtime-service.conf
set XDI_RUNTIME_WRAPPER_HOME=external\windows-serviceOld
set XDI_RUNTIME_WRAPPER_CONF="..\conf\%XDI_RUNTIME_WRAPPER_CONF_FILE%"
set XDI_RUNTIME_WRAPPER_EXE=%XDI_RUNTIME_WRAPPER_HOME%\bin\wrapper-windows-x86-32.exe

echo %XDI_RUNTIME_WRAPPER_CONF_FILE%
echo %XDI_RUNTIME_WRAPPER_CONF%
echo %XDI_RUNTIME_WRAPPER_EXE%

"%XDI_RUNTIME_WRAPPER_EXE%" %MODE% %XDI_RUNTIME_WRAPPER_CONF% "wrapper.java.command=%XDI_RUNTIME_JAVA_EXE_WITHOUT_QUOTE%" "wrapper.ntservice.name=Semarchy xDI Runtime" "wrapper.ntservice.displayname=Semarchy xDI Runtime" "wrapper.ntservice.description=Semarchy xDI Runtime" "wrapper.java.additional.2=%SCHEDULE_PROPS%" "wrapper.java.classpath.12=%XDI_RUNTIME_PROPERTIES_LOCATION%/" "wrapper.app.parameter.2=-conf" "wrapper.app.parameter.3=%XDI_RUNTIME_CONF_FILE_LOCATION%"
GOTO END

:USAGE
echo Usage:
echo installEngineAsService mode [name] [proprertieFilePath] [description]
echo mode: -i (install or reinstall), -r (remove), -iold (install with old mode), -riold (remove with old mode)
echo [name]: name of the service (default Semarchy xDI Runtime)
echo [propertieFilePath]: path of the propertie file use by install mode (default properties\engineParameters.xml)
echo [description]: description of the runtime
:END
