<xsl:stylesheet
	version="2.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:proc="http://www.example.org/proc" xmlns:deliv="http://www.stambia.com/deliv">

	<xsl:output
		method="xml"
		encoding="UTF-8" cdata-section-elements="step metaData"/>
	

	<xsl:param name="checksumVersion"/>
	<xsl:param name="checksum"/>
	
	
	<xsl:template match="node()">
		<xsl:copy>
			<xsl:call-template name="copy_attributes"/>
			<xsl:apply-templates select="*" />
		</xsl:copy>
	</xsl:template>
	
	<xsl:template match="deliv:delivery">
		<xsl:copy>
			<xsl:attribute name="checksumVersion" select="$checksumVersion"/>
			<xsl:attribute name="checksum" select="$checksum"/>
			<xsl:call-template name="copy_attributes"/>
			<xsl:apply-templates select="externalize" >
				<xsl:sort select="@nodeId"/>
			</xsl:apply-templates>
			<xsl:apply-templates select="connection" >
				<xsl:sort select="@name"/>
			</xsl:apply-templates>
			<xsl:apply-templates select="parameter" >
				<xsl:sort select="@name"/>
			</xsl:apply-templates>
			<xsl:apply-templates select="metaData" >
				<xsl:sort select="@name"/>
			</xsl:apply-templates>			
			<xsl:apply-templates select="altId" >
				<xsl:sort select="@origin"/>
			</xsl:apply-templates>
			<xsl:apply-templates select="process" >
				<xsl:sort select="@actionName"/>
			</xsl:apply-templates>
			<xsl:apply-templates select="*[name()!='externalize' and name()!='connection' and name()!='parameter' and name()!='metaData' and name()!='altId' and name()!='process']" />
		
		</xsl:copy>
	</xsl:template>
	
	<xsl:template match="process">
		<xsl:copy>
			<xsl:call-template name="copy_attributes"/>
			<xsl:apply-templates select="step" >
				<xsl:sort select="@id"/>
			</xsl:apply-templates>
			<xsl:apply-templates select="link" >
				<xsl:sort select="@id"/>
			</xsl:apply-templates>
			<xsl:apply-templates select="*[name()!='step' and name()!='link']" />
		</xsl:copy>
	</xsl:template>
	
	<xsl:template match="step">
		<xsl:copy>
			<xsl:call-template name="copy_attributes"/>
			<xsl:value-of select="."/>
			<xsl:apply-templates select="altId" >
				<xsl:sort select="@origin"/>
			</xsl:apply-templates>
			<xsl:apply-templates select="parameter" >
				<xsl:sort select="@name"/>
			</xsl:apply-templates>
			<xsl:apply-templates select="*[name()!='parameter' and name()!='altId']" />
		</xsl:copy>
	</xsl:template>
	
	<xsl:template match="metaData">
		<xsl:copy>
			<xsl:call-template name="copy_attributes"/>
			<xsl:value-of select="."/>
		</xsl:copy>
	</xsl:template>
	
	<xsl:template match="connection">
		<xsl:copy>
			<xsl:call-template name="copy_attributes"/>
			<xsl:apply-templates select="parameter" >
				<xsl:sort select="@name"/>
			</xsl:apply-templates>
			<xsl:apply-templates select="*[name()!='parameter']" />
		</xsl:copy>
	</xsl:template>
	
	<xsl:template match="externalize">
		<xsl:copy>
			<xsl:call-template name="copy_attributes"/>
			<xsl:apply-templates select="property" >
				<xsl:sort select="@index"/>
			</xsl:apply-templates>
			<xsl:apply-templates select="*[name()!='property']" />
		</xsl:copy>
	</xsl:template>
	
	<xsl:template name="copy_attributes">
		<xsl:for-each select="@*">
			<xsl:sort select="name()" />
			<xsl:choose>
				<xsl:when test="../name()='deliv:delivery' and (name()='checksum' or name()='checksumVersion')" />
				<xsl:otherwise>
					<xsl:copy-of select="." />
				</xsl:otherwise>
			</xsl:choose>
		</xsl:for-each>
	</xsl:template>
</xsl:stylesheet>