<xsl:stylesheet xmlns:mdj="java:com.indy.xsl.global.Functions" version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:proc="http://www.example.org/proc" xmlns:fn="http://www.w3.org/2005/02/xpath-functions" xmlns:func="http://www.stambia.com/func" xmlns:md="http://www.stambia.com/md" xmlns:rdbms="http://www.stambia.com/rdbms" xmlns:deliv="http://www.stambia.com/deliv" xmlns:saxon="http://saxon.sf.net/" xmlns:tech="http://www.stambia.com/tech">
	<xsl:include href="include.xsl"/>
	<xsl:key name="ref" match="md" use="id"/>
	<xsl:function name="func:physicalName">
		<xsl:param name="pPath"/>
		<xsl:variable name="path" select="if (count($pPath)=1) then if (contains($pPath,'#')) then document(substring-before($pPath,'#'))//*[@id=substring-after($pPath,'#')] else $pPath else $pPath"/>
		<xsl:variable name="parentPath">
			<xsl:value-of select="func:physicalParentName($path)"/>
		</xsl:variable>
		<xsl:value-of select="$parentPath"/>
		<xsl:if test="$path/@TABLE_NAME">
			<xsl:if test="$parentPath!=''">.</xsl:if>
			<xsl:value-of select="$path/@TABLE_NAME"/>
		</xsl:if>
	</xsl:function>
	<xsl:function name="func:physicalParentName">
		<xsl:param name="pPath"/>
		<xsl:variable name="path" select="if (count($pPath)=1) then if (contains($pPath,'#')) then document(substring-before($pPath,'#'))//*[@id=substring-after($pPath,'#')] else $pPath else $pPath"/>
		<xsl:if test="$path/ancestor-or-self::*[@TABLE_CAT]">
			<xsl:value-of select="$path/ancestor-or-self::*/@TABLE_CAT"/>
		</xsl:if>
		<xsl:if test="$path/ancestor-or-self::*[@TABLE_SCHEM]">
			<xsl:if test="$path/ancestor-or-self::*[@TABLE_CAT]">.</xsl:if>
			<xsl:value-of select="$path/ancestor-or-self::*/@TABLE_SCHEM"/>
		</xsl:if>
	</xsl:function>
	<xsl:function name="func:apply-templates">
		<xsl:param name="pPath"/>
		<xsl:variable name="match" select="if (contains($pPath,'#')) then document(substring-before($pPath,'#'))//*[@id=substring-after($pPath,'#')] else $pPath"/>
		<xsl:apply-templates select="$match"/>
	</xsl:function>
	<xsl:function name="func:charSpe">
		<xsl:param name="string"/>
		<xsl:variable name="return" select="replace(
replace($string,
'\\n','&#xA;'),
'\\t','&#x9;')"/>
		<xsl:value-of select="$return"/>
	</xsl:function>
</xsl:stylesheet>
