<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:proc="http://www.example.org/proc" xmlns:fn="http://www.w3.org/2005/02/xpath-functions" xmlns:md="http://www.stambia.com/md" xmlns:mds="java:com.indy.xsl.global.Strings" xmlns:mdj="java:com.indy.xsl.global.Functions" xmlns:mdv="java:com.indy.xsl.global.Variables" xmlns:tech="http://www.stambia.com/tech" xmlns:saxon="http://saxon.sf.net/" xmlns:rdbms="http://www.stambia.com/rdbms" xmlns:ref="http://www.stambia.com/ref" xmlns:set="http://exslt.org/sets" extension-element-prefixes="saxon" exclude-result-prefixes="xsl proc fn md mds mdj mdv tech saxon rdbms ref set">
	<!--sql part-->
	<xsl:include href="global/rdbms.joins.xsl"/>
	<xsl:function name="rdbms:fromPart">
		<xsl:param name="context"/>
		<xsl:param name="sourceSet"/>
		<xsl:value-of select="rdbms:fromPart($context,$sourceSet,'TEXT')"/>
	</xsl:function>
	<xsl:function name="rdbms:fromPart">
		<xsl:param name="context"/>
		<xsl:param name="sourceSet"/>
		<xsl:param name="mode"/>
		<xsl:call-template name="rdbms:fromPart">
			<xsl:with-param select="$context" name="context"/>
			<xsl:with-param name="sourceSet" select="$sourceSet"/>
			<xsl:with-param name="mode" select="$mode"/>
			<xsl:with-param name="restrict" select="false()"/>
		</xsl:call-template>
	</xsl:function>
	<xsl:function name="rdbms:fromPart">
		<xsl:param name="context"/>
		<xsl:param name="sourceSet"/>
		<xsl:param name="mode"/>
		<xsl:param name="ref"/>
		<xsl:call-template name="rdbms:fromPart">
			<xsl:with-param select="$context" name="context"/>
			<xsl:with-param name="sourceSet" select="$sourceSet"/>
			<xsl:with-param name="mode" select="$mode"/>
			<xsl:with-param name="ref" select="$ref"/>
			<xsl:with-param name="restrict" select="true()"/>
		</xsl:call-template>
	</xsl:function>
	<xsl:template name="rdbms:fromPart">
		<xsl:param name="context"/>
		<xsl:param name="sourceSet"/>
		<xsl:param name="mode"/>
		<xsl:param name="ref" select="$context/None"/>
		<xsl:param name="restrict" select="false()"/>
		<xsl:variable name="ref" select="if ($restrict) then $ref else $context/(join | filter)"/>
		<xsl:variable name="ref" select="if ($sourceSet!='') then $ref[md:ifEmpty(string(@sourceSet),'')=md:ifEmpty(string($sourceSet),'')] else $ref">
			<!--Important d'utiliser md:ifEmpty car ne marche pas si empty sinon-->
		</xsl:variable>
		<xsl:variable name="fromRef" select="if ($restrict) then $context/ref:From($sourceSet,'',$ref/ref:froms()) else  $context/ref:From($sourceSet)">
			<!--Laisser bien ref:froms() car en work les filter et join source n'est pas renseigné (ce qui est dommage)-->
		</xsl:variable>
		<xsl:variable name="joinRef" select="$ref[name()='join']"/>
		<xsl:variable name="product" select="mdj:xpath($context,'SRC_PRODUCT_REF')"/>
		<xsl:variable name="explicitJoins" select="if ($restrict) then $context/ref:explicitJoin($sourceSet,$joinRef) else $context/ref:explicitJoin($sourceSet)"/>
		<xsl:variable name="froms" select="set:difference($fromRef,$explicitJoins/mdj:xpath(.,'RIGHT_REF',$sourceSet)  |  $explicitJoins/mdj:xpath(.,'LEFT_REF',$sourceSet))"/>
		<xsl:variable name="result">
			<xsl:if test="$explicitJoins">
				<xsl:variable name="bracket" select="$product/tech:hasExplicitJoinInBracket()"/>
				<xsl:variable name="all">
					<xsl:for-each select="$explicitJoins">
						<xsl:sort select="@order" order="ascending" data-type="number"/>
						<xsl:choose>
							<xsl:when test="not($bracket) and last()>1 and tech:type()='RIGHT'">
								<join id="{position()}">
									<expr>
										<xsl:value-of select="mdj:xpath($product,'LEFT_JOIN')"/>
									</expr>
									<type>LEFT</type>
									<left>
										<xsl:value-of select="ref:right($sourceSet)/tech:from()"/>
									</left>
									<right>
										<xsl:value-of select="ref:left($sourceSet)/tech:from()"/>
									</right>
									<on>
										<xsl:value-of select="mdj:xpath(.,'EXPRESSION')"/>
									</on>
								</join>
							</xsl:when>
							<xsl:otherwise>
								<join id="{position()}">
									<expr>
										<xsl:choose>
											<xsl:when test="mdj:xpath(.,'IS_CROSS')">
												<xsl:value-of select="mdj:xpath($product,'CROSS_JOIN')"/>
											</xsl:when>
											<xsl:when test="mdj:xpath(.,'IS_FULL')">
												<xsl:value-of select="mdj:xpath($product,'FULL_JOIN')"/>
											</xsl:when>
											<xsl:when test="mdj:xpath(.,'IS_LEFT')">
												<xsl:value-of select="mdj:xpath($product,'LEFT_JOIN')"/>
											</xsl:when>
											<xsl:when test="mdj:xpath(.,'IS_RIGHT')">
												<xsl:value-of select="mdj:xpath($product,'RIGHT_JOIN')"/>
											</xsl:when>
											<xsl:otherwise>
												<xsl:value-of select="mdj:xpath($product,'INNER_JOIN')"/>
											</xsl:otherwise>
										</xsl:choose>
									</expr>
									<type>
										<xsl:value-of select="mdj:xpath(.,'TYPE')"/>
									</type>
									<left>
										<xsl:value-of select="ref:left($sourceSet)/tech:from()"/>
									</left>
									<right>
										<xsl:value-of select="ref:right($sourceSet)/tech:from()"/>
									</right>
									<xsl:if test="mdj:xpath(.,'TYPE')!='CROSS'">
										<on>
											<xsl:value-of select="mdj:xpath(.,'EXPRESSION')"/>
										</on>
									</xsl:if>
								</join>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:for-each>
				</xsl:variable>
				<xsl:choose>
					<xsl:when test="$mode='TEXT'">
						<xsl:call-template name="rdbms:join">
							<xsl:with-param name="joins" select="$all"/>
							<xsl:with-param name="bracket" select="$bracket" tunnel="yes"/>
						</xsl:call-template>
					</xsl:when>
					<xsl:otherwise>
						<xsl:copy-of select="$all">
							<!--Ajouter bracket oui non-->
						</xsl:copy-of>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:if>
			<xsl:if test="$froms">
				<xsl:if test="$explicitJoins">, 
</xsl:if>
				<xsl:variable name="allFrom">
					<xsl:for-each select="$froms">
						<xsl:sort select="tech:order()" data-type="number"/>
						<from>
							<xsl:value-of select="mdj:xpath(.,'FROM')"/>
							<xsl:variable name="after">
								<xsl:value-of select="mdj:xpath(.,'AFTER_FROM')"/>
							</xsl:variable>
							<xsl:if test="$after!=''">
								<xsl:value-of select="concat('
',$after)"/>
							</xsl:if>
						</from>
					</xsl:for-each>
				</xsl:variable>
				<xsl:value-of select="md:list($allFrom/from,',
','','')"/>
			</xsl:if>
		</xsl:variable>
		<xsl:choose>
			<xsl:when test="$mode='TEXT'">
				<xsl:value-of select="$result"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:sequence select="$result"/>
			</xsl:otherwise>
		</xsl:choose>
		<!--on donne les jointures, ca doit retourner les tables nécessaire-->
	</xsl:template>
	<xsl:template match="join" mode="joinBak2">
		<xsl:param name="bracket"/>
		<xsl:variable name="left">
			<xsl:choose>
				<xsl:when test="not(join)">
					<!--Si plus de jointures filles-->
					<xsl:value-of select="left"/>
					<xsl:value-of select="concat(' ',expr,' ')"/>
					<xsl:value-of select="right"/>
					<xsl:if test="on"> ON <xsl:value-of select="on"/>
					</xsl:if>
				</xsl:when>
				<xsl:when test="$bracket">
					<!--Si jointures filles-->
					<xsl:variable name="disableRight" select="right = join//left or right=join//right"/>
					<xsl:variable name="disableLeft" select="left = join//left or left=join//right"/>
					<xsl:choose>
						<xsl:when test="$disableRight">
							<xsl:value-of select="left"/>
							<xsl:value-of select="concat(' ',expr,' ')"/>
						</xsl:when>
					</xsl:choose>
					<xsl:if test="join">
						<xsl:if test="$bracket">(</xsl:if>
						<xsl:apply-templates select="join" mode="join"/>
						<xsl:if test="$bracket">)</xsl:if>
					</xsl:if>
					<xsl:choose>
						<xsl:when test="$disableLeft">
							<xsl:value-of select="concat(' ',expr,' ')"/>
							<xsl:value-of select="right"/>
						</xsl:when>
					</xsl:choose>
					<xsl:if test="on"> ON <xsl:value-of select="on"/>
					</xsl:if>
				</xsl:when>
				<xsl:otherwise>
					<xsl:variable name="disableRight" select="right = join//left or right=join//right">
						<!--si la partie droite est utilisée dans une sous jointure
alors on écrit la partie gauche-->
					</xsl:variable>
					<xsl:variable name="disableLeft" select="left = join//left or left=join//right"/>
					<xsl:if test="../name()!='join'">
						<xsl:value-of select="left"/>
					</xsl:if>
					<xsl:value-of select="concat(' ',expr,' ')"/>
					<xsl:choose>
						<xsl:when test="$disableRight"/>
					</xsl:choose>
					<xsl:value-of select="right"/>
					<xsl:if test="on"> ON <xsl:value-of select="on"/>
					</xsl:if>
					<xsl:apply-templates select="join" mode="join"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:value-of select="concat($left,' ')"/>
	</xsl:template>
	<xsl:template match="join" mode="joinback">
		<xsl:param name="bracket"/>
		<xsl:variable name="left">
			<xsl:choose>
				<xsl:when test="not(join)">
					<!--Si plus de jointures filles-->
					<xsl:if test="../name()!='join'">
						<xsl:value-of select="left"/>
					</xsl:if>
					<xsl:value-of select="concat(' ',expr,' ')"/>
					<xsl:value-of select="right"/>
					<xsl:if test="on"> ON <xsl:value-of select="on"/>
					</xsl:if>
				</xsl:when>
				<xsl:when test="$bracket">
					<xsl:variable name="disableRight" select="right = join//left or right=join//right">
						<!--si la partie droite est utilisée dans une sous jointure
alors on écrit la partie gauche-->
					</xsl:variable>
					<xsl:variable name="disableLeft" select="left = join//left or left=join//right"/>
					<xsl:choose>
						<xsl:when test="$disableRight">
							<xsl:value-of select="left"/>
							<xsl:value-of select="concat(' ',expr,' ')"/>
						</xsl:when>
					</xsl:choose>(<xsl:apply-templates select="join" mode="join"/>)<xsl:choose>
						<xsl:when test="$disableLeft">
							<xsl:value-of select="concat(' ',expr,' ')"/>
							<xsl:value-of select="right"/>
						</xsl:when>
					</xsl:choose>
					<xsl:if test="on"> ON <xsl:value-of select="on"/>
					</xsl:if>
				</xsl:when>
				<xsl:otherwise>
					<xsl:variable name="disableRight" select="right = join//left or right=join//right">
						<!--si la partie droite est utilisée dans une sous jointure
alors on écrit la partie gauche-->
					</xsl:variable>
					<xsl:variable name="disableLeft" select="left = join//left or left=join//right"/>
					<xsl:if test="../name()!='join'">
						<xsl:value-of select="left"/>
					</xsl:if>
					<xsl:value-of select="concat(' ',expr,' ')"/>
					<xsl:choose>
						<xsl:when test="$disableRight"/>
					</xsl:choose>
					<xsl:value-of select="right"/>
					<xsl:if test="on"> ON <xsl:value-of select="on"/>
					</xsl:if>
					<xsl:apply-templates select="join" mode="join"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:value-of select="concat($left,' ')"/>
	</xsl:template>
	<xsl:function name="rdbms:tablePath">
		<xsl:param name="context"/>
		<xsl:value-of select="rdbms:tablePath($context,'DEFAULT','','' )"/>
	</xsl:function>
	<xsl:function name="rdbms:tablePath">
		<xsl:param name="context"/>
		<xsl:param name="xPathCode"/>
		<xsl:value-of select="rdbms:tablePath($context,$xPathCode,'','' )"/>
	</xsl:function>
	<xsl:function name="rdbms:tablePath">
		<xsl:param name="context"/>
		<xsl:param name="xPathCode"/>
		<xsl:param name="xPathParentCode"/>
		<xsl:value-of select="rdbms:tablePath($context,$xPathCode, $xPathParentCode,'')"/>
	</xsl:function>
	<xsl:function name="rdbms:tablePath">
		<xsl:param name="context"/>
		<xsl:param name="xPathCode"/>
		<xsl:param name="xPathParentCode"/>
		<xsl:param name="mode"/>
		<xsl:variable name="parentRef" select="if ($xPathParentCode='REMOTE') then 'SRC_SCHEMA_REF' else ''"/>
		<xsl:variable name="pName">
			<xsl:choose>
				<xsl:when test="$xPathParentCode='A'">
					<xsl:value-of select="md:physicalName($context,$xPathCode, '',$parentRef)"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="md:physicalName($context,$xPathCode, $xPathParentCode,$parentRef)"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:choose>
			<xsl:when test="$mode='REMOTE'">
				<xsl:value-of select="md:remotePath($context,$pName)"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$pName"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:function>
	<!--Quick access-->
	<!--List-->
	<xsl:function name="rdbms:oldTargetFieldList">
		<xsl:param name="context"/>
		<xsl:param name="start"/>
		<xsl:param name="motif"/>
		<xsl:param name="separator"/>
		<xsl:param name="end"/>
		<xsl:value-of select="rdbms:oldTargetFieldList($context,$start,$motif,$separator,$end,'')"/>
	</xsl:function>
	<xsl:function name="rdbms:oldTargetFieldList">
		<xsl:param name="context"/>
		<xsl:param name="start"/>
		<xsl:param name="motif"/>
		<xsl:param name="separator"/>
		<xsl:param name="end"/>
		<xsl:param name="filter"/>
		<xsl:value-of select="rdbms:oldList($context/ref:targetColumns(),$start,$motif,$separator,$end,$filter)"/>
	</xsl:function>
	<xsl:function name="rdbms:oldFieldList">
		<xsl:param name="context"/>
		<xsl:param name="start"/>
		<xsl:param name="motif"/>
		<xsl:param name="separator"/>
		<xsl:param name="end"/>
		<xsl:value-of select="rdbms:oldFieldList($context,$start,$motif,$separator,$end,'')"/>
	</xsl:function>
	<xsl:function name="rdbms:oldFieldList">
		<xsl:param name="context"/>
		<xsl:param name="start"/>
		<xsl:param name="motif"/>
		<xsl:param name="separator"/>
		<xsl:param name="end"/>
		<xsl:param name="filter"/>
		<xsl:value-of select="rdbms:oldList($context/ref:columns(),$start,$motif,$separator,$end,$filter)"/>
	</xsl:function>
	<xsl:function name="rdbms:oldList">
		<xsl:param name="context"/>
		<xsl:param name="start"/>
		<xsl:param name="motif"/>
		<xsl:param name="separator"/>
		<xsl:param name="end"/>
		<xsl:param name="filter"/>
		<!--Ajouter des règles de conversion PK not ... -->
		<xsl:variable name="filter">
			<xsl:choose>
				<xsl:when test="$filter!=''">
					<xsl:value-of select="md:translateToMdjXpath(mdj:translateExpToXsl($filter))"/>
				</xsl:when>
				<xsl:otherwise>1=1</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:value-of select="md:list($context[mdj:evaluate(.,$filter)]/mdj:xpath(.,$motif),$separator,$start,$end)"/>
	</xsl:function>
</xsl:stylesheet>
