<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
	xmlns:proc="http://www.example.org/proc" 
	xmlns:jProp="java:java.util.Properties"
	xmlns:fn="http://www.w3.org/2005/02/xpath-functions" xmlns:md="http://www.stambia.com/md" xmlns:mds="java:com.indy.xsl.global.Strings" xmlns:mdj="java:com.indy.xsl.global.Functions" xmlns:mdv="java:com.indy.xsl.global.Variables" 
	xmlns:tech="http://www.stambia.com/tech" xmlns:saxon="http://saxon.sf.net/" xmlns:user="http://www.stambia.com/user" xmlns:ref="http://www.stambia.com/ref" 
	xmlns:sql="java://com.indy.xsl.sql.SQLElementFactory" xmlns:udf="http://www.stambia.com/udf"  
	xmlns:json="http://www.stambia.com/json"
	extension-element-prefixes="saxon sql">
	<xsl:template match="*" mode="analyzeDatastoreBak">
		<xsl:param name="resetPosition" select="false()"/>
		<xsl:param name="activeFilters" tunnel="yes"/>
		<xsl:param name="filters" tunnel="yes"/>
		<xsl:param name="datastorePrefix" tunnel="yes">XML_DATA_STORE</xsl:param>
		<xsl:param name="datastoreLogicalPrefix" tunnel="yes">XML_DATA_STORE</xsl:param>
		<xsl:if test="$resetPosition">
			<saxon:assign name="position" select="0"/>
		</xsl:if>
		<xsl:apply-templates mode="analyzeDatastore" select="*">
			<xsl:with-param name="resetPosition" select="false()" tunnel="yes"/>
		</xsl:apply-templates>
	</xsl:template>
	<xsl:template match="sequence | all | choice[@maxOccurs!='-1']" mode="analyzeDatastore">
		<xsl:param name="disableDatastoreField" tunnel="yes"/>
		<xsl:param tunnel="yes" name="path"/>
		<xsl:param tunnel="yes" name="fullPath"/>
		<xsl:apply-templates mode="analyzeDatastore" select="*"/>
	</xsl:template>
	<xsl:template match="documentation | appinfo" mode="analyzeDatastore"/>
	<xsl:template match="*" mode="analyzeDatastore">
		<!--* pour wsdl-->
		<xsl:param name="resetPosition" select="false()"/>
		<xsl:param name="disableDatastoreField" tunnel="yes"/>
		<xsl:param name="datastorePrefix" tunnel="yes"/>
		<xsl:param name="datastoreXpathName" tunnel="yes"/>
		<xsl:param name="datastoreLogicalPrefix" tunnel="yes"/>
		<xsl:param name="activeFilters" tunnel="yes"/>
		<xsl:param name="allExtraFields" tunnel="yes" select="None"/>
		<xsl:param name="extraFields" tunnel="yes" select="None"/>
		<xsl:param name="parentId"/>
		<xsl:param tunnel="yes" name="path"/>
		<xsl:param tunnel="yes" name="fullPath"/>
		<xsl:param name="filters" tunnel="yes"/>
		<xsl:param name="disableMerge" tunnel="yes"/>
		<xsl:param name="datastoreNameTruncationSize" tunnel="yes"/>
		<xsl:param name="columnNameTruncationSize" tunnel="yes"/>
		<xsl:variable name="xmlElementName" select="md:ifEmpty(tech:xmlForm(),name())"/>
		<xsl:if test="$resetPosition">
			<saxon:assign name="position" select="0"/>
		</xsl:if>
		<xsl:variable name="name">
			<xsl:choose>
				<xsl:when test="name()='choice'">
					<xsl:for-each select="element | attribute">
						<xsl:choose>
							<xsl:when test="position()>1">
								<xsl:value-of select="concat('|',md:ifEmpty(tech:xmlSelector(),md:ifEmpty(tech:xmlName(),@name)))"/>
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="md:ifEmpty(tech:xmlSelector(),md:ifEmpty(tech:xmlName(),@name))"/>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:for-each>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="md:ifEmpty(tech:xmlSelector(),md:ifEmpty(tech:xmlName(),@name))"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="name" select="if ($name!='') then $name else $xmlElementName"/>
		<xsl:variable name="fullPath1" select="$fullPath"/>
		<xsl:variable name="fullPath" select="if ($fullPath!='') then concat($fullPath,'/',$name) else $name"/>
		<xsl:variable name="fullPath1" select="if (name()='choice') then $fullPath1 else $fullPath"/>
		<xsl:variable name="path1" select="$path"/>
		<xsl:variable name="path" select="if ($path!='') then concat($path,'/',$name) else $name"/>
		<xsl:variable name="path1" select="if (name()='choice') then $path1 else $path"/>
		<xsl:variable name="maxOccurs" select="if ($disableMerge and not(@type!='')) then '-1' else md:ifEmpty(md:ifEmpty(tech:xmlMaxOccurs(),@maxOccurs),'1')"/>
		<xsl:variable name="children" select="if (tech:xmlChildrenEnable())then tech:xmlChildren() else *"/>
		<!-- pb: children are not the entire hierarchy -->
		<xsl:variable name="current" select="."/>
		<xsl:variable name="childreIds" select="if ($extraFields) then $extraFields[tech:parentId()=$current/@id]/tech:childId() else None"/>
		<xsl:variable name="children" select="$children | (if ($childreIds) then $allExtraFields[@id=$childreIds] else None)"/>
		<xsl:variable name="attributeOnStructureReference" select="tech:attributeOnStructureReference($children)"/>
	
		<xsl:choose>
			<xsl:when test="not($activeFilters) or ($children//@id=$filters) or ./@id=$filters">
			
				<xsl:choose>
					<xsl:when test="($xmlElementName='element' and (number($maxOccurs)=-1 or number($maxOccurs)>1 or not(contains($path,'/')))) or $xmlElementName!='element'">
						<!--Soit premier elt root (pas de / ds le nom), soit element and maxOccurs>1 ou = à -1-->
						<xsl:variable name="name2" select="md:ifEmpty(@alternateName,$name)"/>
						<xsl:variable name="name2" select="if ($datastoreNameTruncationSize!='') then substring($name2,1,$datastoreNameTruncationSize) else $name2"/>
						<datastore path="{$path}" fullPath="{$fullPath}" sourceName="{$name2}" originalType="{@originalType}">
						<xsl:apply-templates mode="analyzeDatastore" select="@*">
							<xsl:with-param name="fullPath" tunnel="yes" select="$fullPath"/>
							<xsl:with-param name="path" select="$path"/>
						</xsl:apply-templates>
						<xsl:choose>
							<xsl:when test="$datastoreXpathName!=''">
								<xsl:variable name="dataStoreName" select="saxon:evaluate($datastoreXpathName)"/>
								<xsl:attribute name="name" select="$dataStoreName"/>	
								<xsl:attribute name="logicalName" select="$dataStoreName"/>
							</xsl:when>
							<xsl:otherwise>
								<!--When there is a process parameter in the name we have to return a rhino expression that will truncate the resolved name at execution as we do not know the paremeter length at code generation-->
								<xsl:variable name="truncateAtExecution" select="(contains($datastorePrefix, '${') and contains($datastorePrefix, '}$'))"/>
								<xsl:attribute name="name" select="concat(if ($datastoreNameTruncationSize!='' and not($truncateAtExecution)) then substring($datastorePrefix,1,$datastoreNameTruncationSize - (string-length(string($position))+1)) else if ($datastoreNameTruncationSize!='' and $truncateAtExecution) then concat('%e(rhino){(&quot;',$datastorePrefix,'&quot;).substring(0,',$datastoreNameTruncationSize - (string-length(string($position))+1),');}e(rhino)%') else $datastorePrefix,'_',$position)"/>
								<xsl:attribute name="logicalName" select="concat($datastoreLogicalPrefix,'_',$position)"/>
							</xsl:otherwise>
						</xsl:choose>
						<saxon:assign name="position" select="number(number($position)+1)"/>
						<xsl:apply-templates mode="analyzeDatastore" select="$children">
							<xsl:with-param name="fullPath" tunnel="yes" select="$fullPath1"/>
							<xsl:with-param name="path" select="$path1" tunnel="yes"/>
							<xsl:with-param name="parentId" select="@id"/>

						</xsl:apply-templates>
						<xsl:if test="(not($activeFilters) or ./@id=$filters) and not($disableDatastoreField=true())">
							<xsl:variable name="name3" select="md:ifEmpty(@alternateName,$name)"/>
							<xsl:variable name="name3" select="if ($columnNameTruncationSize!='') then substring($name3,1,$columnNameTruncationSize) else $name3"/>
							<field path="{$path}" fullPath="{$fullPath}" originalType="element" sourceName="{$name3}" parentId="{$parentId}">
								<xsl:apply-templates mode="analyzeDatastore" select="@*"/>
							</field>
						</xsl:if>
					</datastore>
					</xsl:when>
					<xsl:otherwise>
					<xsl:apply-templates mode="analyzeDatastore" select="$children">
						<xsl:with-param name="path" tunnel="yes" select="$path1"/>
						<xsl:with-param name="fullPath" tunnel="yes" select="$fullPath1"/>
						<xsl:with-param name="parentId" select="@id"/>

					</xsl:apply-templates>
					<xsl:if test="not($activeFilters) or ./@id=$filters">
						<xsl:variable name="name2" select="md:ifEmpty(@alternateName,$name)"/>
						<xsl:variable name="name2" select="if ($columnNameTruncationSize!='') then substring($name2,1,$columnNameTruncationSize) else $name2"/>
						<field path="{$path}" fullPath="{$fullPath}" originalType="element" sourceName="{$name2}" parentId="{$parentId}">
							<xsl:apply-templates mode="analyzeDatastore" select="@*"/>
						</field>
					</xsl:if>
				</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<!--
			Some meta-data attributes can be references to other meta-data.
			For example, with 'Kafka structured',
			- the 'consumer' contains a reference to the 'topic'
			- the 'topic' also have 'key' and 'value' attributes,
			both can be references to JSON or AVRO meta-data
			A reference pattern is the following: [path]?#id
			References can be any attribute differente than ID
			(ID attribute is an auto-reference, so we discard it)
			-->
			<xsl:when test="count($attributeOnStructureReference)>0">
				<xsl:for-each select="$attributeOnStructureReference">
					<xsl:apply-templates select="mdj:getRef(.)" mode="analyzeDatastore">
						<xsl:with-param name="fullPath" tunnel="yes" select="concat($fullPath,'/',../name())"/>
					</xsl:apply-templates>
				</xsl:for-each>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="attribute |  *[tech:xmlForm()='attribute']" mode="analyzeDatastore">
		<xsl:param name="disableDatastoreField" tunnel="yes"/>
		<xsl:param name="datastorePrefix" tunnel="yes"/>
		<xsl:param name="datastoreXpathName" tunnel="yes"/>
		<xsl:param name="datastoreLogicalPrefix" tunnel="yes"/>
		<xsl:param name="activeFilters" tunnel="yes"/>
		<xsl:param name="filters" tunnel="yes"/>
		<xsl:param name="path" tunnel="yes"/>
		<xsl:param name="fullPath" tunnel="yes"/>
		<xsl:param name="columnNameTruncationSize" tunnel="yes"/>
		<xsl:param name="parentId"/>
		<xsl:variable name="path" select="concat($path,'/@',@name)"/>
		<xsl:variable name="fullPath" select="if ($fullPath!='') then concat($fullPath,'/@',@name) else @name"/>
		<xsl:if test="not($activeFilters) or .//@id=$filters or ./@id=$filters">
			<xsl:variable name="name" select="md:ifEmpty(@alternateName,@name)"/>
			<xsl:variable name="name" select="if ($columnNameTruncationSize!='') then substring($name,1,$columnNameTruncationSize) else $name"/>
			<field path="{$path}" fullPath="{$fullPath}" originalType="attribute" sourceName="{$name}" parentId="{$parentId}">
				<xsl:apply-templates mode="analyzeDatastore" select="@*"/>
			</field>
		</xsl:if>
	</xsl:template>
	<xsl:template match="@md:ref" mode="analyzeDatastore"/>
	
	<xsl:template match="@name" mode="analyzeDatastore">
		<xsl:choose>
			<xsl:when test="not(../tech:xmlName()!='')">
				<xsl:copy/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:attribute name="name" select="../tech:xmlName()"/>	
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template match="@type" mode="analyzeDatastore">
		<xsl:choose>
			<xsl:when test="not(../tech:xmlType()!='')">
				<xsl:copy/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:attribute name="type" select="../tech:xmlType()"/>	
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template match="@id" mode="analyzeDatastore">
		<xsl:attribute name="id" select="."/>	
		<xsl:if test="not(../@name) and ../tech:xmlName()!=''">
			<xsl:attribute name="name" select="../tech:xmlName()"/>	
		</xsl:if>
		<xsl:if test="not(../@type) and ../tech:xmlType()!=''">
			<xsl:attribute name="type" select="../tech:xmlType()"/>	
		</xsl:if>
	</xsl:template>
	
	<xsl:template match="@description" mode="analyzeDatastore"/>
	

	
	<xsl:template match="@*" mode="analyzeDatastore">
		<xsl:copy/>
	</xsl:template>
	
	<xsl:variable name="position" saxon:assignable="yes" select="0"/>
	<!--XmlToXsd-->
	<xsl:template match="*" mode="mdXmlToXsd">
		<xsl:apply-templates select="*" mode="mdXmlToXsd"/>
	</xsl:template>
	<xsl:template match="xsd" mode="mdXmlToXsd">
		<xs:schema xmlns:xs="http://www.w3.org/2001/XMLSchema">
			<xsl:if test="@prefixForElement!=''">
				<xsl:attribute name="elementFormDefault" select="@prefixForElement"/>
			</xsl:if>
			<xsl:if test="@prefixForAttribute!=''">
				<xsl:attribute name="elementFormDefault" select="@prefixForAttribute"/>
			</xsl:if>
			<xsl:copy-of select="@targetNamespace"/>
			<xsl:apply-templates mode="mdXmlToXsd" select="*"/>
		</xs:schema>
	</xsl:template>
	<xsl:template match="element" mode="mdXmlToXsd">
		<xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema">
			<xsl:if test="@type!=''">
				<xsl:attribute name="type" select="concat('xs:',@type)"/>
			</xsl:if>
			<xsl:copy-of select="@name  | @minOccurs"/>
			<xsl:choose>
				<xsl:when test="@maxOccurs='-1'">
					<xsl:attribute name="maxOccurs">unbounded</xsl:attribute>
				</xsl:when>
				<xsl:otherwise>
					<xsl:copy-of select="@maxOccurs"/>
				</xsl:otherwise>
			</xsl:choose>
			<xsl:if test="*">
				<xs:complexType>
					<xsl:if test="choice | all | sequence">
						<xsl:element name="xs:{(choice | all | sequence)[1]/name()}">
							<xsl:apply-templates mode="mdXmlToXsd" select="*/*"/>
						</xsl:element>
					</xsl:if>
					<xsl:apply-templates mode="mdXmlToXsd" select="attribute"/>
				</xs:complexType>
			</xsl:if>
		</xs:element>
	</xsl:template>
	<xsl:template match="attribute" mode="mdXmlToXsd">
		<xs:attribute xmlns:xs="http://www.w3.org/2001/XMLSchema">
			<xsl:if test="@type!=''">
				<xsl:attribute name="type" select="concat('xs:',@type)"/>
			</xsl:if>
			<xsl:copy-of select="@name"/>
		</xs:attribute>
	</xsl:template>
	<xsl:template match="text()" mode="mdXmlToXsd"/>
	
	<xsl:function name="fn:contains">
		<xsl:param name="value"/>
		<xsl:param name="values"/>
		<xsl:for-each select="$values">
			<xsl:if test=".=$value">
				<xsl:value-of select="true()"/>
			</xsl:if>
		</xsl:for-each>
	</xsl:function>

	<!-- jsonMdXmlToJsonSchema : generate the JSON Schema from a JSON MD in its XML form -->
	<xsl:function name="json:isRoot">
		<xsl:param name="defType"/>
		<xsl:value-of select="contains($defType, 'root')"/>
	</xsl:function>
	
	<xsl:function name="json:isArray">
		<xsl:param name="node"/>
		<xsl:value-of select="contains($node/@defType, 'rray')"/>
	</xsl:function>
	
	<xsl:function name="json:isObject">
		<xsl:param name="node"/>
		<xsl:value-of select="contains($node/@defType, 'bject')"/>
	</xsl:function>
	
	<xsl:variable name="jsonQuote" select="'&quot;'" />
	<xsl:template match="/" mode="jsonMdXmlToJsonSchema">
		<xsl:text>{</xsl:text>
		<xsl:apply-templates select="*" mode="jsonMdXmlToJsonSchema" />
	<xsl:text>}</xsl:text>
	</xsl:template>
  	
  	<xsl:template match="text()" mode="jsonMdXmlToJsonSchema"></xsl:template>
  	<xsl:template match="*[@defType='com.stambia.json.rootObject' ]" mode="jsonMdXmlToJsonSchema">
  		<xsl:variable name="wrappingVar">
	  		<xsl:text>{"title": "</xsl:text><xsl:value-of select=" @name" />"<xsl:text>, "type":"object","properties":{</xsl:text>
			
				<xsl:for-each select="*[@defType='com.stambia.json.rootObject' or @defType='com.stambia.json.object' or @defType='com.stambia.json.rootArray' or @defType='com.stambia.json.array'or @defType='com.stambia.json.rootValue' or @defType='com.stambia.json.value'] ">
	   				<xsl:apply-templates select="." mode="jsonMdXmlToJsonSchema"  />
					<xsl:if test="position() != last()">
				    	<xsl:text>,</xsl:text>
				   </xsl:if>
				</xsl:for-each>
			<xsl:text>}}</xsl:text>
		</xsl:variable>
		<!-- if we do not store the result in a var, the evaluation order is wrong ... dont know why -->
		<xsl:value-of select="$wrappingVar" />
		
	</xsl:template>
	
	<xsl:template match="*[@defType='com.stambia.json.rootArray']" mode="jsonMdXmlToJsonSchema">
		<xsl:variable name="isRoot" select="json:isRoot(@defType)=true()" />
		<xsl:variable name="wrappingVar">
			<xsl:text>{"title": "</xsl:text><xsl:value-of select=" @name" />"<xsl:text>, "type":"array","items":{</xsl:text>
			<xsl:variable name="hasMultipleChilds" select="count(*) > 1" />
			<xsl:if test="$hasMultipleChilds">
		    	<xsl:text>"anyOf":[{</xsl:text> 
		   	</xsl:if>
			<xsl:for-each select="*[@defType='com.stambia.json.rootObject' or @defType='com.stambia.json.object' or @defType='com.stambia.json.rootArray' or @defType='com.stambia.json.array'or @defType='com.stambia.json.rootValue' or @defType='com.stambia.json.value'] ">
  					<xsl:apply-templates select="." mode="jsonMdXmlToJsonSchema" />
				<xsl:if test="position() != last()">
		    		<xsl:text>,</xsl:text>
		   		</xsl:if>
			</xsl:for-each>
			<xsl:if test="$hasMultipleChilds">
		    	<xsl:text>}]</xsl:text> 
		   	</xsl:if>
			<xsl:text>}}</xsl:text>
		</xsl:variable>
		<xsl:value-of select="$wrappingVar" />
	</xsl:template>
		
	<xsl:template match="*[@defType='com.stambia.json.object']" mode="jsonMdXmlToJsonSchema">
  		<xsl:variable name="isRoot" select="json:isRoot(@defType)=true()" />
  		<xsl:variable name="wrappingVar">
			<xsl:if test="json:isObject(..)=true()">
				<xsl:value-of select="concat($jsonQuote, @name, $jsonQuote)" /> <xsl:text>: {</xsl:text>
			</xsl:if>
			<xsl:text>"type":"object","properties":{</xsl:text>
			
				<xsl:for-each select="*[@defType='com.stambia.json.rootObject' or @defType='com.stambia.json.object' or @defType='com.stambia.json.rootArray' or @defType='com.stambia.json.array'or @defType='com.stambia.json.rootValue' or @defType='com.stambia.json.value'] ">
	   				<xsl:apply-templates select="." mode="jsonMdXmlToJsonSchema"  />
					<xsl:if test="position() != last()">
				    	<xsl:text>,</xsl:text>
				   </xsl:if>
				</xsl:for-each>
			<xsl:text>}</xsl:text>
			<xsl:if test="json:isObject(..)=true()">
				<xsl:text>}</xsl:text>
			</xsl:if>
		</xsl:variable>
		
		<!-- if we do not store the result in a var, the evaluation order is wrong ... dont know why -->
		<xsl:value-of select="$wrappingVar" />
		
	</xsl:template>
	
	
	
	<xsl:template match="*[@defType='com.stambia.json.array']" mode="jsonMdXmlToJsonSchema">
		<xsl:variable name="wrappingVar">
			<xsl:if test="json:isObject(..)=true()">
				<xsl:value-of select="concat($jsonQuote, @name, $jsonQuote)" /> <xsl:text>: {</xsl:text>
			</xsl:if>
			<xsl:text>"type":"array","items":{ </xsl:text>
			<xsl:variable name="hasMultipleChilds" select="count(*) > 1" />
			<xsl:if test="$hasMultipleChilds">
		    	<xsl:text>"anyOf":[{</xsl:text> 
		   	</xsl:if>
				   	
			<xsl:for-each select="*[@defType='com.stambia.json.rootObject' or @defType='com.stambia.json.object' or @defType='com.stambia.json.rootArray' or @defType='com.stambia.json.array'or @defType='com.stambia.json.rootValue' or @defType='com.stambia.json.value'] ">
  					<xsl:apply-templates select="." mode="jsonMdXmlToJsonSchema" />
				<xsl:if test="position() != last()">
		    		<xsl:text>,</xsl:text>
		   		</xsl:if>
			</xsl:for-each>
			
			<xsl:if test="$hasMultipleChilds">
		    	<xsl:text>}]</xsl:text> 
		   	</xsl:if>
			<xsl:text>}</xsl:text>
			<xsl:if test="json:isObject(..)=true()">
				<xsl:text>}</xsl:text>
			</xsl:if>
		</xsl:variable>
		<xsl:value-of select="$wrappingVar" />
	</xsl:template>
	
	<xsl:template match="*[@defType='com.stambia.json.rootValue']" mode="jsonMdXmlToJsonSchema">
		<xsl:variable name="wrappingVar">
			<xsl:text>{"title": "</xsl:text><xsl:value-of select=" @name" />"<xsl:text>, "type":</xsl:text><xsl:value-of select="@type" />
				<xsl:choose>
					<xsl:when test="@type='string'">
						<xsl:if test="exists(@size) and not(@size='')">
							<xsl:text>,</xsl:text>
							<xsl:text>"maxLength":</xsl:text><xsl:value-of select="@size" />
						</xsl:if>
					</xsl:when>
				</xsl:choose>
			<xsl:text>}</xsl:text>

		</xsl:variable>
		<xsl:value-of select="$wrappingVar" />
	</xsl:template>
	 
	 <xsl:template match="*[@defType='com.stambia.json.value']" mode="jsonMdXmlToJsonSchema">
		<xsl:variable name="wrappingVar">
			<xsl:if test="json:isObject(..)=true()">
				<xsl:value-of select="concat($jsonQuote, @name, $jsonQuote)" /> <xsl:text>: {</xsl:text>
			</xsl:if>
			<xsl:text>"type":</xsl:text>
			<xsl:value-of select="concat($jsonQuote, @type, $jsonQuote)" />
				<xsl:choose>
					<xsl:when test="@type='string'">
						<xsl:if test="exists(@size) and not(@size='')">
							<xsl:text>,</xsl:text>
							<xsl:text>"maxLength":</xsl:text><xsl:value-of select="@size" />
						</xsl:if>
					</xsl:when>
				</xsl:choose>
			<xsl:if test="json:isObject(..)=true()">
				<xsl:text>}</xsl:text>
			</xsl:if>
		</xsl:variable>
		<xsl:value-of select="$wrappingVar" />
	</xsl:template>
	
	
	<!-- tools to generate FileDriver required XML from File MD -->
	<xsl:template match="*" mode="fileMdXmlToFileSchema">
		<!-- 
			boolean to specify the main usage of this templates
			when true, the ancestors of a file (directory, server) will also be generated
		 -->
		<xsl:param name = "isMain" />
		<!-- expect a string representing a valid xPathExpression
			this expression will be evaluated to potentially discard attributes of xml MdNodes.
			can be empty, in this case, all attributes are generated
		 -->
		<xsl:param name = "attributeFilterExpression" tunnel="yes"/>
		<xsl:variable name="res">
			<xsl:if test="$isMain=true()">
				<!--  -->
				<xsl:variable name="nodes" select="ancestor::server|ancestor::directory"/>
					<xsl:for-each select="$nodes">
					<xsl:text>&lt;</xsl:text>
					<xsl:value-of select="name()" />
					<xsl:apply-templates select="@*" mode="fileMdXmlToFileSchema"/>
					<xsl:text>&gt;</xsl:text>
				</xsl:for-each>	
			</xsl:if>
		
			<xsl:text>&lt;</xsl:text>
			<xsl:value-of select="name()" />
			<xsl:apply-templates select="@*" mode="fileMdXmlToFileSchema" />
			<xsl:choose>
				<xsl:when test="node()">
					<xsl:text>&gt;</xsl:text>
					<xsl:apply-templates mode="fileMdXmlToFileSchema" />
					<xsl:text>&lt;/</xsl:text>
					<xsl:value-of select="name()" />
					<xsl:text>&gt;</xsl:text>
				</xsl:when>
				<xsl:otherwise>
					<xsl:text> /&gt;</xsl:text>
				</xsl:otherwise>
			</xsl:choose>
			<xsl:if test="$isMain=true()">
				<xsl:variable name="nodes" select="ancestor::server|ancestor::directory"/>
				<xsl:for-each select="$nodes">
					<xsl:sort order="descending" select="position()"/>
					<xsl:text>&lt;/</xsl:text>
					<xsl:value-of select="name()" />
					<xsl:text>&gt;</xsl:text>
				</xsl:for-each>	
			</xsl:if>
		</xsl:variable>
		<xsl:value-of select="$res"/>
	</xsl:template>
	<xsl:template match="@*" mode="fileMdXmlToFileSchema">
		<xsl:param name = "attributeFilterExpression" tunnel="yes"/>
		<xsl:if test="not(exists($attributeFilterExpression)) or saxon:evaluate($attributeFilterExpression)=false()">
			<xsl:text> </xsl:text>
			<xsl:value-of select="name()" />
			<xsl:text>="</xsl:text>
			<xsl:choose>
				<xsl:when test="name()='transformLineScript' or name()='transformScript' or name()='name'">
					<xsl:variable name="escaped" select="replace(., '&amp;', concat(codepoints-to-string(38), 'amp;'))" />
					<xsl:value-of select="replace(replace($escaped, '&quot;', concat(codepoints-to-string(38), 'quot;')), '&lt;', concat(codepoints-to-string(38), 'lt;'))" />
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="." />
				</xsl:otherwise>
			</xsl:choose>
			
			<xsl:text>"</xsl:text>
		</xsl:if>
	</xsl:template>
	<!-- we want to use an xPathExpression instead of the attribute value for this one because directory is a hierarchy -->
	<xsl:template match="@path" mode="fileMdXmlToFileSchema">
		<xsl:text> </xsl:text>
			<xsl:value-of select="name()" />
			<xsl:text>="</xsl:text>
			<xsl:choose>
				<xsl:when test="../../name()='directory'">
					<xsl:value-of select="substring-after(mdj:xpath(.., 'PATH'), mdj:xpath(../.., 'PATH'))" />
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="mdj:xpath(.., 'PATH')" />
				</xsl:otherwise>
			</xsl:choose>
			
			<xsl:text>"</xsl:text>
	</xsl:template>
</xsl:stylesheet>
