--
-- You have to replace XDI_RUNTIME_SCHEDULER occurrences with the
-- org.quartz.scheduler.instanceName parameter value contained into
-- engineScheduler.properties file.
--

--
-- drop tables that are no longer used
--
drop table stb_job_listeners;
drop table stb_trigger_listeners;

--
-- drop columns that are no longer used
--
alter table stb_job_details drop column is_volatile;
alter table stb_triggers drop column is_volatile;
alter table stb_fired_triggers drop column is_volatile;

--
-- add new columns that replace the 'is_stateful' column
--
alter table stb_job_details add column is_nonconcurrent BOOLEAN;
alter table stb_job_details add column is_update_data BOOLEAN;
update stb_job_details set is_nonconcurrent = is_stateful;
update stb_job_details set is_update_data = is_stateful;
alter table stb_job_details drop column is_stateful;
alter table stb_fired_triggers add column is_nonconcurrent BOOLEAN;
update stb_fired_triggers set is_nonconcurrent = is_stateful;
alter table stb_fired_triggers drop column is_stateful;

--
-- add new 'sched_name' column to all tables --- replace "RUNTIME_H2_STD" with your scheduler's configured name
--
alter table stb_blob_triggers add column sched_name varchar(120) not null DEFAULT 'RUNTIME_H2_STD';
alter table stb_calendars add column sched_name varchar(120) not null DEFAULT 'RUNTIME_H2_STD';
alter table stb_cron_triggers add column sched_name varchar(120) not null DEFAULT 'RUNTIME_H2_STD';
alter table stb_fired_triggers add column sched_name varchar(120) not null DEFAULT 'RUNTIME_H2_STD';
alter table stb_job_details add column sched_name varchar(120) not null DEFAULT 'RUNTIME_H2_STD';
alter table stb_locks add column sched_name varchar(120) not null DEFAULT 'RUNTIME_H2_STD';
alter table stb_paused_trigger_grps add column sched_name varchar(120) not null DEFAULT 'RUNTIME_H2_STD';
alter table stb_scheduler_state add column sched_name varchar(120) not null DEFAULT 'RUNTIME_H2_STD';
alter table stb_simple_triggers add column sched_name varchar(120) not null DEFAULT 'RUNTIME_H2_STD';
alter table stb_triggers add column sched_name varchar(120) not null DEFAULT 'RUNTIME_H2_STD';

--
-- add new 'sched_time' column to stb_fired_triggers
--
alter table stb_fired_triggers add column sched_time BIGINT;
update stb_fired_triggers set sched_time = fired_time;
alter table stb_fired_triggers alter column sched_time BIGINT NOT NULL;

--
-- create temporary tables
--
CREATE TABLE stb_job_details_temp (
  SCHED_NAME VARCHAR(120) NOT NULL,
  JOB_NAME VARCHAR (200)  NOT NULL ,
  JOB_GROUP VARCHAR (200)  NOT NULL ,
  DESCRIPTION VARCHAR (250) NULL ,
  JOB_CLASS_NAME VARCHAR (250)  NOT NULL ,
  IS_DURABLE BOOLEAN  NOT NULL ,
  IS_NONCONCURRENT BOOLEAN  NOT NULL ,
  IS_UPDATE_DATA BOOLEAN  NOT NULL ,
  REQUESTS_RECOVERY BOOLEAN  NOT NULL ,
  JOB_DATA IMAGE NULL
);

CREATE TABLE stb_triggers_temp (
  SCHED_NAME VARCHAR(120) NOT NULL,
  TRIGGER_NAME VARCHAR (200)  NOT NULL ,
  TRIGGER_GROUP VARCHAR (200)  NOT NULL ,
  JOB_NAME VARCHAR (200)  NOT NULL ,
  JOB_GROUP VARCHAR (200)  NOT NULL ,
  DESCRIPTION VARCHAR (250) NULL ,
  NEXT_FIRE_TIME BIGINT NULL ,
  PREV_FIRE_TIME BIGINT NULL ,
  PRIORITY INTEGER NULL ,
  TRIGGER_STATE VARCHAR (16)  NOT NULL ,
  TRIGGER_TYPE VARCHAR (8)  NOT NULL ,
  START_TIME BIGINT NOT NULL ,
  END_TIME BIGINT NULL ,
  CALENDAR_NAME VARCHAR (200)  NULL ,
  MISFIRE_INSTR SMALLINT NULL ,
  JOB_DATA IMAGE NULL
);

CREATE TABLE stb_simple_triggers_temp (
  SCHED_NAME VARCHAR(120) NOT NULL,
  TRIGGER_NAME VARCHAR (200)  NOT NULL ,
  TRIGGER_GROUP VARCHAR (200)  NOT NULL ,
  REPEAT_COUNT BIGINT NOT NULL ,
  REPEAT_INTERVAL BIGINT NOT NULL ,
  TIMES_TRIGGERED BIGINT NOT NULL
);

CREATE TABLE stb_cron_triggers_temp (
  SCHED_NAME VARCHAR(120) NOT NULL,
  TRIGGER_NAME VARCHAR (200)  NOT NULL ,
  TRIGGER_GROUP VARCHAR (200)  NOT NULL ,
  CRON_EXPRESSION VARCHAR (120)  NOT NULL ,
  TIME_ZONE_ID VARCHAR (80) 
);

CREATE TABLE stb_blob_triggers_temp (
  SCHED_NAME VARCHAR(120) NOT NULL,
  TRIGGER_NAME VARCHAR (200)  NOT NULL ,
  TRIGGER_GROUP VARCHAR (200)  NOT NULL ,
  BLOB_DATA IMAGE NULL
);

CREATE TABLE stb_calendars_temp (
  SCHED_NAME VARCHAR(120) NOT NULL,
  CALENDAR_NAME VARCHAR (200)  NOT NULL ,
  CALENDAR IMAGE NOT NULL
);

CREATE TABLE stb_paused_trigger_grps_temp (
  SCHED_NAME VARCHAR(120) NOT NULL,
  TRIGGER_GROUP VARCHAR (200)  NOT NULL 
);

CREATE TABLE stb_fired_triggers_temp (
  SCHED_NAME VARCHAR(120) NOT NULL,
  ENTRY_ID VARCHAR (95)  NOT NULL ,
  TRIGGER_NAME VARCHAR (200)  NOT NULL ,
  TRIGGER_GROUP VARCHAR (200)  NOT NULL ,
  INSTANCE_NAME VARCHAR (200)  NOT NULL ,
  FIRED_TIME BIGINT NOT NULL ,
  SCHED_TIME BIGINT NOT NULL ,
  PRIORITY INTEGER NOT NULL ,
  STATE VARCHAR (16)  NOT NULL,
  JOB_NAME VARCHAR (200)  NULL ,
  JOB_GROUP VARCHAR (200)  NULL ,
  IS_NONCONCURRENT BOOLEAN  NULL ,
  REQUESTS_RECOVERY BOOLEAN  NULL 
);

CREATE TABLE stb_scheduler_state_temp (
  SCHED_NAME VARCHAR(120) NOT NULL,
  INSTANCE_NAME VARCHAR (200)  NOT NULL ,
  LAST_CHECKIN_TIME BIGINT NOT NULL ,
  CHECKIN_INTERVAL BIGINT NOT NULL
);

CREATE TABLE stb_locks_temp (
  SCHED_NAME VARCHAR(120) NOT NULL,
  LOCK_NAME VARCHAR (40)  NOT NULL 
);


--
-- fill temporary tables
--
INSERT INTO stb_job_details_temp (SCHED_NAME, JOB_NAME, JOB_GROUP, DESCRIPTION, JOB_CLASS_NAME, IS_DURABLE, IS_NONCONCURRENT, IS_UPDATE_DATA, REQUESTS_RECOVERY, JOB_DATA)
SELECT SCHED_NAME, JOB_NAME, JOB_GROUP, DESCRIPTION, JOB_CLASS_NAME, IS_DURABLE, IS_NONCONCURRENT, IS_UPDATE_DATA, REQUESTS_RECOVERY, JOB_DATA
FROM stb_job_details;

INSERT INTO stb_triggers_temp (SCHED_NAME, TRIGGER_NAME, TRIGGER_GROUP, JOB_NAME, JOB_GROUP, DESCRIPTION, NEXT_FIRE_TIME, PREV_FIRE_TIME, PRIORITY, TRIGGER_STATE, TRIGGER_TYPE, START_TIME, END_TIME, CALENDAR_NAME, MISFIRE_INSTR, JOB_DATA)
SELECT SCHED_NAME, TRIGGER_NAME, TRIGGER_GROUP, JOB_NAME, JOB_GROUP, DESCRIPTION, NEXT_FIRE_TIME, PREV_FIRE_TIME, PRIORITY, TRIGGER_STATE, TRIGGER_TYPE, START_TIME, END_TIME, CALENDAR_NAME, MISFIRE_INSTR, JOB_DATA
FROM stb_triggers;

INSERT INTO stb_simple_triggers_temp (SCHED_NAME, TRIGGER_NAME, TRIGGER_GROUP, REPEAT_COUNT, REPEAT_INTERVAL, TIMES_TRIGGERED)
SELECT SCHED_NAME, TRIGGER_NAME, TRIGGER_GROUP, REPEAT_COUNT, REPEAT_INTERVAL, TIMES_TRIGGERED
FROM stb_simple_triggers;

INSERT INTO stb_cron_triggers_temp (SCHED_NAME, TRIGGER_NAME, TRIGGER_GROUP, CRON_EXPRESSION, TIME_ZONE_ID)
SELECT SCHED_NAME, TRIGGER_NAME, TRIGGER_GROUP, CRON_EXPRESSION, TIME_ZONE_ID
FROM stb_cron_triggers;

INSERT INTO stb_blob_triggers_temp (SCHED_NAME, TRIGGER_NAME, TRIGGER_GROUP, BLOB_DATA)
SELECT SCHED_NAME, TRIGGER_NAME, TRIGGER_GROUP, BLOB_DATA
FROM stb_blob_triggers;

INSERT INTO stb_calendars_temp (SCHED_NAME, CALENDAR_NAME, CALENDAR)
SELECT SCHED_NAME, CALENDAR_NAME, CALENDAR
FROM stb_calendars;

INSERT INTO stb_paused_trigger_grps_temp (SCHED_NAME, TRIGGER_GROUP)
SELECT SCHED_NAME, TRIGGER_GROUP
FROM stb_paused_trigger_grps;

INSERT INTO stb_fired_triggers_temp (SCHED_NAME, ENTRY_ID,  TRIGGER_NAME,  TRIGGER_GROUP,  INSTANCE_NAME,  FIRED_TIME,  SCHED_TIME,  PRIORITY,  STATE,  JOB_NAME,  JOB_GROUP,  IS_NONCONCURRENT, REQUESTS_RECOVERY)
SELECT SCHED_NAME, ENTRY_ID,  TRIGGER_NAME,  TRIGGER_GROUP,  INSTANCE_NAME,  FIRED_TIME,  SCHED_TIME,  PRIORITY,  STATE,  JOB_NAME,  JOB_GROUP,  IS_NONCONCURRENT, REQUESTS_RECOVERY
FROM stb_fired_triggers;

INSERT INTO stb_scheduler_state_temp (SCHED_NAME, INSTANCE_NAME, LAST_CHECKIN_TIME,  CHECKIN_INTERVAL)
SELECT SCHED_NAME, INSTANCE_NAME, LAST_CHECKIN_TIME,  CHECKIN_INTERVAL
FROM stb_scheduler_state;

INSERT INTO stb_locks_temp (SCHED_NAME, LOCK_NAME)
SELECT SCHED_NAME, LOCK_NAME
FROM stb_locks;



--
-- remove old tables
--
DROP TABLE stb_locks;
DROP TABLE stb_scheduler_state;
DROP TABLE stb_fired_triggers;
DROP TABLE stb_paused_trigger_grps;
DROP TABLE stb_calendars;
DROP TABLE stb_blob_triggers;
DROP TABLE stb_cron_triggers;
DROP TABLE stb_simple_triggers;
DROP TABLE stb_triggers;
DROP TABLE stb_job_details;

--
-- rename new tables
--
ALTER TABLE stb_locks_temp RENAME TO stb_locks;
ALTER TABLE stb_scheduler_state_temp RENAME TO stb_scheduler_state;
ALTER TABLE stb_fired_triggers_temp RENAME TO stb_fired_triggers;
ALTER TABLE stb_paused_trigger_grps_temp RENAME TO stb_paused_trigger_grps;
ALTER TABLE stb_scheduler_state_temp RENAME TO stb_scheduler_state;
ALTER TABLE stb_calendars_temp RENAME TO stb_calendars;
ALTER TABLE stb_blob_triggers_temp RENAME TO stb_blob_triggers;
ALTER TABLE stb_cron_triggers_temp RENAME TO stb_cron_triggers;
ALTER TABLE stb_simple_triggers_temp RENAME TO stb_simple_triggers;
ALTER TABLE stb_triggers_temp RENAME TO stb_triggers;
ALTER TABLE stb_job_details_temp RENAME TO stb_job_details;



--
-- add all primary and foreign key constraints, based on new columns
--
alter table stb_job_details add primary key (sched_name, job_name, job_group);
alter table stb_triggers add primary key (sched_name, trigger_name, trigger_group);
alter table stb_triggers add foreign key (sched_name, job_name, job_group) references stb_job_details(sched_name, job_name, job_group);
alter table stb_blob_triggers add primary key (sched_name, trigger_name, trigger_group);
alter table stb_blob_triggers add foreign key (sched_name, trigger_name, trigger_group) references stb_triggers(sched_name, trigger_name, trigger_group);
alter table stb_cron_triggers add primary key (sched_name, trigger_name, trigger_group);
alter table stb_cron_triggers add foreign key (sched_name, trigger_name, trigger_group) references stb_triggers(sched_name, trigger_name, trigger_group);
alter table stb_simple_triggers add primary key (sched_name, trigger_name, trigger_group);
alter table stb_simple_triggers add foreign key (sched_name, trigger_name, trigger_group) references stb_triggers(sched_name, trigger_name, trigger_group);
alter table stb_fired_triggers add primary key (sched_name, entry_id);
alter table stb_calendars add primary key (sched_name, calendar_name);
alter table stb_locks add primary key (sched_name, lock_name);
alter table stb_paused_trigger_grps add primary key (sched_name, trigger_group);
alter table stb_scheduler_state add primary key (sched_name, instance_name);

--
-- add new simprop_triggers table
--
CREATE TABLE stb_simprop_triggers
 (
    SCHED_NAME VARCHAR(120) NOT NULL,
    TRIGGER_NAME VARCHAR(200) NOT NULL,
    TRIGGER_GROUP VARCHAR(200) NOT NULL,
    STR_PROP_1 VARCHAR(512) NULL,
    STR_PROP_2 VARCHAR(512) NULL,
    STR_PROP_3 VARCHAR(512) NULL,
    INT_PROP_1 INTEGER NULL,
    INT_PROP_2 INTEGER NULL,
    LONG_PROP_1 BIGINT NULL,
    LONG_PROP_2 BIGINT NULL,
    DEC_PROP_1 NUMERIC(13,4) NULL,
    DEC_PROP_2 NUMERIC(13,4) NULL,
    BOOL_PROP_1 BOOLEAN NULL,
    BOOL_PROP_2 BOOLEAN NULL,
    PRIMARY KEY (SCHED_NAME,TRIGGER_NAME,TRIGGER_GROUP),
    FOREIGN KEY (SCHED_NAME,TRIGGER_NAME,TRIGGER_GROUP)
    REFERENCES stb_TRIGGERS(SCHED_NAME,TRIGGER_NAME,TRIGGER_GROUP)
);


COMMIT;