--
-- You have to replace XDI_RUNTIME_SCHEDULER occurrences with the
-- org.quartz.scheduler.instanceName parameter value contained into
-- engineScheduler.properties file.
--

--
-- drop tables that are no longer used
--
drop table stb_job_listeners;
drop table stb_trigger_listeners;

--
-- drop columns that are no longer used
--
alter table stb_job_details drop column is_volatile;
alter table stb_triggers drop column is_volatile;
alter table stb_fired_triggers drop column is_volatile;

--
-- add new columns that replace the 'is_stateful' column
--
alter table stb_job_details add is_nonconcurrent VARCHAR2(1);
alter table stb_job_details add is_update_data VARCHAR2(1);
update stb_job_details set is_nonconcurrent = is_stateful;
update stb_job_details set is_update_data = is_stateful;
alter table stb_job_details drop column is_stateful;
alter table stb_fired_triggers add is_nonconcurrent VARCHAR2(1);
update stb_fired_triggers set is_nonconcurrent = is_stateful;
alter table stb_fired_triggers drop column is_stateful;

--
-- add new 'sched_name' column to all tables --- replace "XDI_RUNTIME_SCHEDULER" with your scheduler's configured name
--
alter table stb_blob_triggers add sched_name VARCHAR2(120) DEFAULT 'XDI_RUNTIME_SCHEDULER' NOT NULL;
alter table stb_calendars add sched_name VARCHAR2(120) DEFAULT 'XDI_RUNTIME_SCHEDULER' NOT NULL;
alter table stb_cron_triggers add sched_name VARCHAR2(120) DEFAULT 'XDI_RUNTIME_SCHEDULER' NOT NULL;
alter table stb_fired_triggers add sched_name VARCHAR2(120) DEFAULT 'XDI_RUNTIME_SCHEDULER' NOT NULL;
alter table stb_job_details add sched_name VARCHAR2(120) DEFAULT 'XDI_RUNTIME_SCHEDULER' NOT NULL;
alter table stb_locks add sched_name VARCHAR2(120) DEFAULT 'XDI_RUNTIME_SCHEDULER' NOT NULL;
alter table stb_paused_trigger_grps add sched_name VARCHAR2(120) DEFAULT 'XDI_RUNTIME_SCHEDULER' NOT NULL;
alter table stb_scheduler_state add sched_name VARCHAR2(120) DEFAULT 'XDI_RUNTIME_SCHEDULER' NOT NULL;
alter table stb_simple_triggers add sched_name VARCHAR2(120)DEFAULT 'XDI_RUNTIME_SCHEDULER' NOT NULL;
alter table stb_triggers add sched_name VARCHAR2(120) DEFAULT 'XDI_RUNTIME_SCHEDULER' NOT NULL;

--
-- add new 'sched_time' column to stb_fired_triggers
--
alter table stb_fired_triggers add sched_time NUMBER(13) NULL;
update stb_fired_triggers set sched_time = fired_time;
alter table stb_fired_triggers modify sched_time NUMBER(13) NOT NULL;

--
-- drop all primary and foreign key constraints, so that we can define new ones
--
DECLARE
     constraint_name VARCHAR2(120);
BEGIN
	 select CONSTRAINT_NAME INTO constraint_name from user_constraints where table_name = 'STB_TRIGGERS' AND constraint_type = 'R' ;
	 EXECUTE IMMEDIATE 'ALTER TABLE STB_TRIGGERS DROP CONSTRAINT ' || constraint_name ;
END;


DECLARE
     constraint_name VARCHAR2(120);
BEGIN
	 select CONSTRAINT_NAME INTO constraint_name from user_constraints where table_name = 'STB_BLOB_TRIGGERS' AND constraint_type = 'P' ;
	 EXECUTE IMMEDIATE 'ALTER TABLE STB_BLOB_TRIGGERS DROP CONSTRAINT ' || constraint_name ;
END;

DECLARE
     constraint_name VARCHAR2(120);
BEGIN
	 select CONSTRAINT_NAME INTO constraint_name from user_constraints where table_name = 'STB_BLOB_TRIGGERS' AND constraint_type = 'R' ;
	 EXECUTE IMMEDIATE 'ALTER TABLE STB_BLOB_TRIGGERS DROP CONSTRAINT ' || constraint_name ;
END;

DECLARE
     constraint_name VARCHAR2(120);
BEGIN
	 select CONSTRAINT_NAME INTO constraint_name from user_constraints where table_name = 'STB_SIMPLE_TRIGGERS' AND constraint_type = 'P' ;
	 EXECUTE IMMEDIATE 'ALTER TABLE STB_SIMPLE_TRIGGERS DROP CONSTRAINT ' || constraint_name ;
END;

DECLARE
     constraint_name VARCHAR2(120);
BEGIN
	 select CONSTRAINT_NAME INTO constraint_name from user_constraints where table_name = 'STB_SIMPLE_TRIGGERS' AND constraint_type = 'R' ;
	 EXECUTE IMMEDIATE 'ALTER TABLE STB_SIMPLE_TRIGGERS DROP CONSTRAINT ' || constraint_name ;
END;


DECLARE
     constraint_name VARCHAR2(120);
BEGIN
	 select CONSTRAINT_NAME INTO constraint_name from user_constraints where table_name = 'STB_CRON_TRIGGERS' AND constraint_type = 'P' ;
	 EXECUTE IMMEDIATE 'ALTER TABLE STB_CRON_TRIGGERS DROP CONSTRAINT ' || constraint_name ;
END;

DECLARE
     constraint_name VARCHAR2(120);
BEGIN
	 select CONSTRAINT_NAME INTO constraint_name from user_constraints where table_name = 'STB_CRON_TRIGGERS' AND constraint_type = 'R' ;
	 EXECUTE IMMEDIATE 'ALTER TABLE STB_CRON_TRIGGERS DROP CONSTRAINT ' || constraint_name ;
END;

DECLARE
     constraint_name VARCHAR2(120);
BEGIN
	 select CONSTRAINT_NAME INTO constraint_name from user_constraints where table_name = 'STB_JOB_DETAILS' AND constraint_type = 'P' ;
	 EXECUTE IMMEDIATE 'ALTER TABLE STB_JOB_DETAILS DROP CONSTRAINT ' || constraint_name ;
END;

alter table stb_job_details add primary key (sched_name, job_name, job_group);

DECLARE
     constraint_name VARCHAR2(120);
BEGIN
	 select CONSTRAINT_NAME INTO constraint_name from user_constraints where table_name = 'STB_TRIGGERS' AND constraint_type = 'P' ;
	 EXECUTE IMMEDIATE 'ALTER TABLE STB_TRIGGERS DROP CONSTRAINT ' || constraint_name ;
END;

--
-- add all primary and foreign key constraints, based on new columns
--
alter table stb_triggers add primary key (sched_name, trigger_name, trigger_group);
alter table stb_triggers add foreign key (sched_name, job_name, job_group) references stb_job_details(sched_name, job_name, job_group);
alter table stb_blob_triggers add primary key (sched_name, trigger_name, trigger_group);
alter table stb_blob_triggers add foreign key (sched_name, trigger_name, trigger_group) references stb_triggers(sched_name, trigger_name, trigger_group);
alter table stb_cron_triggers add primary key (sched_name, trigger_name, trigger_group);
alter table stb_cron_triggers add foreign key (sched_name, trigger_name, trigger_group) references stb_triggers(sched_name, trigger_name, trigger_group);
alter table stb_simple_triggers add primary key (sched_name, trigger_name, trigger_group);
alter table stb_simple_triggers add foreign key (sched_name, trigger_name, trigger_group) references stb_triggers(sched_name, trigger_name, trigger_group);

DECLARE
     constraint_name VARCHAR2(120);
BEGIN
	 select CONSTRAINT_NAME INTO constraint_name from user_constraints where table_name = 'STB_FIRED_TRIGGERS' AND constraint_type = 'P' ;
	 EXECUTE IMMEDIATE 'ALTER TABLE STB_FIRED_TRIGGERS DROP CONSTRAINT ' || constraint_name ;
END;

alter table stb_fired_triggers add primary key (sched_name, entry_id);

DECLARE
     constraint_name VARCHAR2(120);
BEGIN
	 select CONSTRAINT_NAME INTO constraint_name from user_constraints where table_name = 'STB_CALENDARS' AND constraint_type = 'P' ;
	 EXECUTE IMMEDIATE 'ALTER TABLE STB_CALENDARS DROP CONSTRAINT ' || constraint_name ;
END;

alter table stb_calendars add primary key (sched_name, calendar_name);

DECLARE
     constraint_name VARCHAR2(120);
BEGIN
	 select CONSTRAINT_NAME INTO constraint_name from user_constraints where table_name = 'STB_LOCKS' AND constraint_type = 'P' ;
	 EXECUTE IMMEDIATE 'ALTER TABLE STB_LOCKS DROP CONSTRAINT ' || constraint_name ;
END;

alter table stb_locks add primary key (sched_name, lock_name);

DECLARE
     constraint_name VARCHAR2(120);
BEGIN
	 select CONSTRAINT_NAME INTO constraint_name from user_constraints where table_name = 'STB_PAUSED_TRIGGER_GRPS' AND constraint_type = 'P' ;
	 EXECUTE IMMEDIATE 'ALTER TABLE STB_PAUSED_TRIGGER_GRPS DROP CONSTRAINT ' || constraint_name ;
END;

alter table stb_paused_trigger_grps add primary key (sched_name, trigger_group);

DECLARE
     constraint_name VARCHAR2(120);
BEGIN
	 select CONSTRAINT_NAME INTO constraint_name from user_constraints where table_name = 'STB_SCHEDULER_STATE' AND constraint_type = 'P' ;
	 EXECUTE IMMEDIATE 'ALTER TABLE STB_SCHEDULER_STATE DROP CONSTRAINT ' || constraint_name ;
END;

alter table stb_scheduler_state add primary key (sched_name, instance_name);


--
-- add new simprop_triggers table
--
CREATE TABLE stb_simprop_triggers
 (
    SCHED_NAME VARCHAR2(120) NOT NULL,
    TRIGGER_NAME VARCHAR2(200) NOT NULL,
    TRIGGER_GROUP VARCHAR2(200) NOT NULL,
    STR_PROP_1 VARCHAR2(512) NULL,
    STR_PROP_2 VARCHAR2(512) NULL,
    STR_PROP_3 VARCHAR2(512) NULL,
    INT_PROP_1 NUMBER(10) NULL,
    INT_PROP_2 NUMBER(10) NULL,
    LONG_PROP_1 NUMBER(13) NULL,
    LONG_PROP_2 NUMBER(13) NULL,
    DEC_PROP_1 NUMERIC(13,4) NULL,
    DEC_PROP_2 NUMERIC(13,4) NULL,
    BOOL_PROP_1 VARCHAR2(1) NULL,
    BOOL_PROP_2 VARCHAR2(1) NULL,
    CONSTRAINT STB_SIMPROP_TRIG_PK PRIMARY KEY (SCHED_NAME,TRIGGER_NAME,TRIGGER_GROUP),
    CONSTRAINT STB_SIMPROP_TRIG_TO_TRIG_FK FOREIGN KEY (SCHED_NAME,TRIGGER_NAME,TRIGGER_GROUP) 
      REFERENCES STB_TRIGGERS(SCHED_NAME,TRIGGER_NAME,TRIGGER_GROUP)
);

--
-- create indexes for faster queries
--
create index idx_stb_j_grp on stb_job_details(SCHED_NAME,JOB_GROUP);
create index idx_stb_t_j on stb_triggers(SCHED_NAME,JOB_NAME,JOB_GROUP);
create index idx_stb_t_jg on stb_triggers(SCHED_NAME,JOB_GROUP);
create index idx_stb_t_c on stb_triggers(SCHED_NAME,CALENDAR_NAME);
create index idx_stb_t_g on stb_triggers(SCHED_NAME,TRIGGER_GROUP);
create index idx_stb_t_n_state on stb_triggers(SCHED_NAME,TRIGGER_NAME,TRIGGER_GROUP,TRIGGER_STATE);
create index idx_stb_t_n_g_state on stb_triggers(SCHED_NAME,TRIGGER_GROUP,TRIGGER_STATE);
create index idx_stb_t_nft_misfire on stb_triggers(SCHED_NAME,MISFIRE_INSTR,NEXT_FIRE_TIME);
create index idx_stb_t_nft_st_misfire on stb_triggers(SCHED_NAME,MISFIRE_INSTR,NEXT_FIRE_TIME,TRIGGER_STATE);
create index idx_stb_t_nft_st_misfire_grp on stb_triggers(SCHED_NAME,MISFIRE_INSTR,NEXT_FIRE_TIME,TRIGGER_GROUP,TRIGGER_STATE);
create index idx_stb_ft_inst_job_req_rcvry on stb_fired_triggers(SCHED_NAME,INSTANCE_NAME,REQUESTS_RECOVERY);
create index idx_stb_ft_j_g on stb_fired_triggers(SCHED_NAME,JOB_NAME,JOB_GROUP);
create index idx_stb_ft_jg on stb_fired_triggers(SCHED_NAME,JOB_GROUP);
create index idx_stb_ft_t_g on stb_fired_triggers(SCHED_NAME,TRIGGER_NAME,TRIGGER_GROUP);
create index idx_stb_ft_tg on stb_fired_triggers(SCHED_NAME,TRIGGER_GROUP);

commit;